/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faov.tree.history;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.Node;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.system.SystemNode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class HistoryFileNode
extends Node<HistoryFileNode> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern datasetPattern = Pattern.compile("(\\S+?)(?:\\((\\S+?)\\))*");
    private String dataset;
    private String member;

    public HistoryFileNode(String host, String port, String path) {
        super(host, port, path, path.contains("(") ? HistoryFileNode.getHFPath(path).split("\\(")[1].replace(")", "") : HistoryFileNode.getHFPath(path));
        IFile file = FACorePlugin.getRoot().getFile(path);
        String name = file.getProjectRelativePath().removeFileExtension().lastSegment();
        Matcher m = datasetPattern.matcher(name);
        if (m.matches()) {
            if (m.groupCount() > 0) {
                this.dataset = m.group(1);
            }
            if (m.groupCount() > 1) {
                this.member = m.group(2);
            }
        }
    }

    private static String getHFPath(String path) {
        IFile file = FACorePlugin.getRoot().getFile(path);
        IPath location = file.getProjectRelativePath();
        return location.removeFileExtension().lastSegment();
    }

    @Override
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    @Override
    public String getText() {
        IFile file = FACorePlugin.getRoot().getFile(this.getPath());
        if (!file.exists()) {
            logger.warn((Object)(String.valueOf(file.getFullPath()) + " does not exist."));
            return null;
        }
        XMLMemento memento = MementoUtils.loadXMLMementoFromIFile((IFile)file, (boolean)true, (Charset)StandardCharsets.UTF_8);
        if (memento != null) {
            String title = memento.getString("title");
            if (title != null && !title.isEmpty()) {
                return this.getDescription() + " [" + title + "]";
            }
        } else {
            logger.warn((Object)("Failed to read xml from " + String.valueOf(file)));
        }
        return this.getDescription();
    }

    public SystemNode getParent() {
        return new SystemNode(this.getHost(), this.getPort());
    }

    public String getMember() {
        return this.member;
    }

    public String getDataset() {
        return this.dataset;
    }
}

