/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faov.tree;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.graphics.Image;

public abstract class Node<T extends Node<?>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2027. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(Node.class);
    private String path = "";
    private String host;
    private String port;
    private String description;

    public String getPort() {
        return this.port;
    }

    public Node(String host, String port, String path, String description) {
        this.path = path;
        this.host = Ipv6Utils.encode((String)host);
        this.port = port;
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            return ((Node)obj).getPath().equals(this.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public abstract Image getImage();

    public abstract String getText();

    public abstract Node<?> getParent();

    public boolean hasChildren() {
        return false;
    }

    public Collection<? extends Node<?>> getChildren() {
        return Collections.emptyList();
    }

    public String getDescription() {
        return this.description;
    }
}

