/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.view;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.DuplicateInfo;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.FaultEntries;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.FaultEntryInfo;
import com.ibm.etools.fa.pdtclient.ui.util.EclipseUtils;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnNames;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ViewParser {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ViewParser.class);
    private static int currentVersion = -1;
    private static List<Map<String, String>> faultEntrytList = null;

    public static FaultEntries parse(int version, String address, String port, String dataset, String member) {
        currentVersion = version;
        return ViewParser.parse(address, port, dataset, member, (IProgressMonitor)new NullProgressMonitor());
    }

    public static FaultEntries parse(String address, String port, String dataset, String member, IProgressMonitor monitor) {
        return ViewParser.parse(FAResourceUtils.getProjectRelativePath((String)address, (String)port, (String)dataset, (String)member), monitor);
    }

    public static FaultEntries parse(String _view) {
        return ViewParser.parse(_view, (IProgressMonitor)new NullProgressMonitor());
    }

    public static FaultEntries parse(String _view, IProgressMonitor monitor) {
        Objects.requireNonNull(_view, "Must provide a non-null _view.");
        FaultEntries entries = new FaultEntries();
        ViewParser.parse(_view, entries, monitor);
        if (entries.getColumns().isEmpty()) {
            ViewParser.parse(".cols", entries, monitor);
        }
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)(MessageFormat.format("Parsing view: ''{0}''", _view) + " | " + (entries.getColumns().isEmpty() ? "also parsed .cols" : "") + MessageFormat.format("| Fault entries={0} | Columns={1}", entries.getEntryCount(), entries.getColumns())));
        }
        return entries;
    }

    private static FaultEntries parse(String _view, FaultEntries _entries, IProgressMonitor monitor) {
        Objects.requireNonNull(_view, "Must provide a non-null _view.");
        IFile in_file = (IFile)IResourceUtils.getCaseInsensitive((IResource)FACorePlugin.getRoot().getFile(_view), (IProgressMonitor)monitor, (boolean)false);
        if (in_file == null) {
            logger.trace((Object)("file doesn't exist: " + String.valueOf(in_file)));
            return _entries;
        }
        if (!in_file.exists()) {
            logger.trace((Object)("file doesn't exist: " + String.valueOf(in_file)));
            return _entries;
        }
        XMLMemento root = MementoUtils.loadXMLMementoFromIFile((IFile)in_file, (boolean)false, (Charset)StandardCharsets.UTF_8, (IProgressMonitor)monitor);
        if (root != null) {
            if (root.getType().equals("ul")) {
                _entries.setComment(root.getString("title"));
                IMemento[] iMementoArray = root.getChildren("li");
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento li = iMementoArray[n2];
                    if (li.getTextData() != null && !li.getTextData().trim().isEmpty()) {
                        String index = ViewParser.getTextDataUpperTrimmed(li);
                        String index_path = FACorePlugin.getRoot().getFile(_view).getProjectRelativePath().removeLastSegments(1).append(index).append("index.hfml").toString();
                        _entries.addIndex(index);
                        ViewParser.parse(index_path, _entries, monitor);
                    } else if (new HashSet<String>(Arrays.asList(li.getAttributeKeys())).contains("id")) {
                        IMemento ol;
                        if (li.getString("id").equals("columns")) {
                            ol = li.getChild("ol");
                            if (ol != null) {
                                var13_22 = ol.getChildren("li");
                                var12_20 = var13_22.length;
                                var11_17 = 0;
                                while (var11_17 < var12_20) {
                                    col_li = var13_22[var11_17];
                                    column_name = ViewParser.getTextDataUpperTrimmed(col_li);
                                    if (column_name != null && ColumnNames.columnNamesSet.contains(column_name)) {
                                        _entries.addColumn(column_name);
                                        ViewParser.getFilter(_entries, col_li, column_name);
                                    }
                                    ++var11_17;
                                }
                            }
                        } else if (li.getString("id").equals("match") && (ol = li.getChild("ol")) != null) {
                            var13_22 = ol.getChildren("li");
                            var12_20 = var13_22.length;
                            var11_17 = 0;
                            while (var11_17 < var12_20) {
                                col_li = var13_22[var11_17];
                                column_name = ViewParser.getTextDataUpperTrimmed(col_li);
                                if (column_name != null && ColumnNames.columnNamesSet.contains(column_name)) {
                                    ViewParser.getFilter(_entries, col_li, column_name);
                                }
                                ++var11_17;
                            }
                        }
                    }
                    ++n2;
                }
            } else if (root.getType().equals("table")) {
                IMemento[] iMementoArray = root.getChildren("tr");
                int n = iMementoArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IMemento tr = iMementoArray[n3];
                    IMemento[] td = tr.getChildren("td");
                    HashMap<String, String> entry = new HashMap<String, String>();
                    if (currentVersion == 150101 || currentVersion == 150102) {
                        d = 0;
                        while (d < td.length && d < ColumnNames.column_names.length) {
                            if (td[d].getTextData() != null && d >= 36 && !ColumnNames.column_names[d].toUpperCase().equals("SPILLED")) {
                                entry.put(ColumnNames.column_names[d].toUpperCase(), td[d + 1].getTextData().trim());
                            } else if (td[d].getTextData() != null && d >= 36 && ColumnNames.column_names[d].toUpperCase().equals("SPILLED")) {
                                entry.put(ColumnNames.column_names[d].toUpperCase(), td[36].getTextData().trim());
                            } else {
                                entry.put(ColumnNames.column_names[d].toUpperCase(), td[d].getTextData().trim());
                            }
                            ++d;
                        }
                    } else {
                        d = 0;
                        while (d < td.length && d < ColumnNames.column_names.length) {
                            if (td[d].getTextData() != null) {
                                entry.put(ColumnNames.column_names[d].toUpperCase(), td[d].getTextData().trim());
                            }
                            ++d;
                        }
                    }
                    entry.put(ViewParser.class.getCanonicalName(), _view);
                    if ("deleted".equals(tr.getString("class"))) {
                        entry.put(ViewParser.class.getCanonicalName() + ".deleted", "true");
                    }
                    _entries.addEntry(entry);
                    ViewParser.setFaultEntrytList(_entries.getEntries());
                    IMemento last_td = td[td.length - 1];
                    if ("dupinfo".equals(last_td.getString("id"))) {
                        DuplicateInfo dup_info = new DuplicateInfo();
                        IMemento dup_details = last_td.getChild("table");
                        IMemento[] iMementoArray2 = dup_details.getChildren("tr");
                        int n4 = iMementoArray2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            IMemento dup_tr = iMementoArray2[n5];
                            IMemento[] dup_tds = dup_tr.getChildren("td");
                            HashMap<String, String> details = new HashMap<String, String>();
                            int p = 0;
                            while (p < dup_tds.length && p < ColumnNames.DUPLICATE_COLUMN_NAMES.length) {
                                details.put(ColumnNames.DUPLICATE_COLUMN_NAMES[p], dup_tds[p].getTextData());
                                ++p;
                            }
                            dup_info.addDuplicate(details);
                            ++n5;
                        }
                        _entries.addDuplicate(entry, dup_info);
                        dup_info.setRecentDupTime(last_td.getString("recent_dup_time"));
                        dup_info.setInitAbendTime(last_td.getString("init_abend_time"));
                        dup_info.setDupCount(last_td.getString("dup_count"));
                    }
                    FaultEntryInfo entry_info = FaultEntryInfo.createFaultEntry(tr);
                    _entries.addInfo(entry, entry_info);
                    ++n3;
                }
            } else {
                logger.debug((Object)root.getType());
            }
        }
        return _entries;
    }

    private static void getFilter(FaultEntries faultEntries, IMemento li, String columnName) {
        Objects.requireNonNull(faultEntries);
        Objects.requireNonNull(li);
        Objects.requireNonNull(columnName);
        String filter = li.getString("filter");
        if (filter != null && !filter.isEmpty()) {
            faultEntries.addFilter(columnName, EclipseUtils.sanitiseRegexInput(filter));
        }
    }

    private static String getTextDataUpperTrimmed(IMemento m) {
        return m.getTextData() != null ? m.getTextData().trim().toUpperCase() : null;
    }

    public static List<Map<String, String>> getFaultEntrytList() {
        return faultEntrytList;
    }

    public static void setFaultEntrytList(List<Map<String, String>> faultEntrytList) {
        ViewParser.faultEntrytList = faultEntrytList;
    }
}

