/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.view;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.Node;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.history.HistoryFileNode;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.history.LocalHistoryFileNode;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.system.SystemNode;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ViewNode
extends Node<HistoryFileNode> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String dataset;

    public ViewNode(ViewNode node) {
        super(node.getHost(), node.getPort(), FAResourceUtils.getHistoryFileFolderRelativePath((String)node.getHost(), (String)node.getPort(), (String)node.dataset).toString(), node.dataset);
        this.dataset = node.dataset;
    }

    public ViewNode(String host, String port, String dataset) {
        super(host, port, FAResourceUtils.getHistoryFileFolderRelativePath((String)host, (String)port, (String)dataset).toString(), dataset);
        this.dataset = dataset;
    }

    public String getDataset() {
        return this.dataset;
    }

    @Override
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String getText() {
        return this.getDescription();
    }

    public SystemNode getParent() {
        return new SystemNode(this.getHost(), this.getPort());
    }

    @Override
    public Collection<HistoryFileNode> getChildren() {
        IContainer system = FACorePlugin.getRoot().getFolder(this.getPath()).getParent();
        if (system.exists()) {
            ArrayList<HistoryFileNode> nodes = new ArrayList<HistoryFileNode>();
            for (IResource member : IResourceUtils.ls((IFolder)((IFolder)system), (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
                if (!FAResourceUtils.isFileExtension((IResource)member, (String)"hfml") || !member.getName().contains("(")) continue;
                if (this.isHistoryFileNode(member)) {
                    nodes.add(new HistoryFileNode(this.getHost(), this.getPort(), member.getProjectRelativePath().toString()));
                    continue;
                }
                if (!this.isLocalHistoryFileNode(member)) continue;
                nodes.add(new LocalHistoryFileNode(this.getHost(), this.getPort(), member.getProjectRelativePath().toString()));
            }
            return nodes;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isHistoryFileNode(IResource member) {
        String dataSetName = member.getLocation().removeFileExtension().lastSegment().split("\\(")[0];
        boolean dataSetIsParent = dataSetName.equals(this.getDescription());
        return dataSetIsParent && !this.isLocalHistoryFileNode(member);
    }

    private boolean isLocalHistoryFileNode(IResource member) {
        String dataSetName = member.getLocation().removeFileExtension().lastSegment().split("\\(")[0];
        boolean dataSetIsLocalView = dataSetName.equals("local.views");
        boolean parentIsLocalView = this.getDescription().equals("local.views");
        return dataSetIsLocalView && parentIsLocalView;
    }
}

