/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.view;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;

public abstract class ViewListHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright IBM Corp. 2015. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ViewListHandler.class);

    public static FATPJob addViewList(String hostname, int port, String username, final Combo dataset) {
        URI uri = FARL.getFARLURI((String)hostname, (String)("" + port));
        if (uri != null) {
            FATPJob job = new FATPJob(Messages.ViewListHandler_Adding_view_list, FARL.get_view_list((URI)uri)){

                @Override
                protected void finalize_responses(IProgressMonitor _mon) {
                    for (FATP[] request_response : this.responses) {
                        ViewListHandler.handleViewListResponse(request_response, dataset);
                    }
                }
            };
            job.set_user(username);
            job.schedule();
            return job;
        }
        return null;
    }

    private static void handleViewListResponse(FATP[] request_response, final Combo dataset) {
        String status_code;
        FATP response = request_response[1];
        if (response.is_successful_response() && (status_code = response.get_status_code()).equals("200")) {
            logger.info((Object)request_response[0].toString());
            String responseStr = response.get_body(FARL.CHARSET_ENGLISH);
            if (responseStr.contains(",")) {
                final HashSet<String> setOfViews = new HashSet<String>(Arrays.asList(responseStr.split(",")));
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!dataset.isDisposed()) {
                            String[] current = dataset.getItems();
                            if (current != null && current.length > 0) {
                                setOfViews.addAll(Arrays.asList(current));
                            }
                            dataset.setItems(setOfViews.toArray(new String[0]));
                        }
                    }
                });
            }
        }
    }
}

