/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader;

import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewBrowseView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.FAVersionHolder;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.FATPUtils;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader.HostVersionFetchingOperation;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.lookup.view.LookedUpMessage;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class FATPQueries {
    private static final PDLogger logger = PDLogger.get(FATPQueries.class);

    public static Result<EXISTS_STATUS> checkExists(String hostName, String port, IProgressMonitor monitor, String dataset) {
        final AtomicReference<EXISTS_STATUS> existsStatus = new AtomicReference<EXISTS_STATUS>(EXISTS_STATUS.NOT_EXISTS);
        monitor.beginTask(Messages.FATPQueries_Checks_exist_task, 2);
        URI uri = FARL.getFARLURI((String)hostName, (String)port, (String)dataset);
        if (uri != null) {
            FATPJob job = new FATPJob(Messages.FATPQueries_Checks_exist, FARL.get_check_history_file_exists((URI)uri)){

                @Override
                protected void finalize_responses(IProgressMonitor _mon) {
                    for (FATP[] request_response : this.responses) {
                        if (request_response[1].is_successful_response()) {
                            if (!request_response[1].get_status_code().equals("200")) continue;
                            existsStatus.set(EXISTS_STATUS.EXISTS);
                            continue;
                        }
                        if (!request_response[1].get_status_code().equals("501")) continue;
                        existsStatus.set(EXISTS_STATUS.HOST_DOES_NOT_EXIST_CHECK);
                    }
                }
            };
            FATPQueries.waitForJob(job, monitor);
        }
        return new Result((Object)existsStatus.get());
    }

    public static LookedUpMessage lookupMessageCode(String hostName, String port, IProgressMonitor monitor, String code) {
        monitor.beginTask(Messages.FATPQueries_lookupMessage, 2);
        final LookedUpMessage lookedUpMessage = new LookedUpMessage();
        URI uri = FARL.getFARLURI((String)hostName, (String)String.valueOf(port));
        if (uri != null) {
            FATPJob job = new FATPJob(Messages.FATPQueries_lookupMessage, FARL.lookup_message((URI)uri, (String)code)){

                @Override
                protected void finalize_responses(IProgressMonitor monitor2) {
                    if (this.responses.size() > 0) {
                        FATPQueries.parseResponseForMessage((FATP[])this.responses.get(0), monitor2, lookedUpMessage);
                    } else {
                        PDLogger.get(FATPQueries.class).error((Object)Messages.FATPQueries_noResponses);
                    }
                }
            };
            FATPQueries.waitForJobAndLockUI(job, monitor, Messages.FATPQueries_lookupBeginTask, Messages.FATPQueries_lookupProgress);
        }
        return lookedUpMessage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void parseResponseForMessage(FATP[] request_response, IProgressMonitor monitor, LookedUpMessage lookedUpMessage) {
        var3_3 = null;
        var4_5 = null;
        try {
            block32: {
                block30: {
                    block31: {
                        block29: {
                            block28: {
                                block27: {
                                    request = request_response[0];
                                    try {
                                        block26: {
                                            response = request_response[1];
                                            if (FATPUtils.isStatusCodeNoContent(response)) {
                                                lookedUpMessage.setErrorMessage(Messages.FATPQueries_lookupNotFound);
                                                if (response == null) break block26;
                                            }
                                            ** GOTO lbl-1000
                                            response.close();
                                        }
                                        if (request == null) return;
                                    }
                                    catch (Throwable var4_6) {
                                        if (var3_3 == null) {
                                            var3_3 = var4_6;
                                        } else if (var3_3 != var4_6) {
                                            var3_3.addSuppressed(var4_6);
                                        }
                                        if (request == null) throw var3_3;
                                        request.close();
                                        throw var3_3;
                                    }
                                    request.close();
                                    return;
lbl-1000:
                                    // 1 sources

                                    {
                                        if (FATPUtils.isStatusCodeOk(response)) ** GOTO lbl-1000
                                        lookedUpMessage.setErrorMessage(MessageFormat.format(Messages.FATPQueries_badStatusCode, new Object[]{response.get_status_code(), response.get_status_reason_phrase()}));
                                        if (response == null) break block27;
                                    }
                                    response.close();
                                }
                                if (request == null) return;
                                request.close();
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    content_encoding = response.get_entity_header("Content-Encoding");
                                    if (content_encoding.equals("identity") || content_encoding.equals("")) ** GOTO lbl-1000
                                    lookedUpMessage.setErrorMessage(Messages.FATPQueries_contentEncodingUnspecified);
                                    if (response == null) break block28;
                                }
                                response.close();
                            }
                            if (request == null) return;
                            request.close();
                            return;
lbl-1000:
                            // 1 sources

                            {
                                media_type = FATPUtils.getMediaTypeFromResponse(response);
                                if (media_type != null && (media_type.isEmpty() || media_type.equals("text/xml") || media_type.equals("text/plain"))) ** GOTO lbl-1000
                                lookedUpMessage.setErrorMessage(Messages.FATPQueries_notXML);
                                if (response == null) break block29;
                            }
                            response.close();
                        }
                        if (request == null) return;
                        request.close();
                        return;
lbl-1000:
                        // 1 sources

                        {
                            charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type"));
                            contents = response.get_body(charset).replaceAll("\u0000", " ");
                            if (!contents.isEmpty()) break block30;
                            lookedUpMessage.setErrorMessage(Messages.FATPQueries_notResponseBody);
                            if (response == null) break block31;
                        }
                        response.close();
                    }
                    if (request == null) return;
                    request.close();
                    return;
                }
                ** try [egrp 12[TRYBLOCK] [6 : 299->354)] { 
lbl68:
                // 1 sources

                try {
                    root = XMLMemento.createReadRoot((Reader)new StringReader(contents));
                    if (root.getType().equals("DATA")) {
                        FATPQueries.parseLookedUpMessage((IMemento)root, lookedUpMessage);
                    }
                    break block32;
                }
                catch (WorkbenchException e) {
                    lookedUpMessage.setErrorMessage(Messages.FATPQueries_parseDataError + ". " + e.getLocalizedMessage());
                }
                break block32;
lbl77:
                // 1 sources

                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            if (request == null) return;
            request.close();
            return;
        }
        catch (Throwable var4_7) {
            if (var3_3 == null) {
                var3_3 = var4_7;
                throw var3_3;
            }
            if (var3_3 == var4_7) throw var3_3;
            var3_3.addSuppressed(var4_7);
            throw var3_3;
        }
    }

    private static void parseLookedUpMessage(IMemento root, LookedUpMessage lookedUpMessage) {
        String typeString;
        int index;
        String code;
        IMemento id = root.getChild("ID");
        IMemento description = root.getChild("DESCRIPTION");
        if (!(id == null || description == null || StringUtils.isNullOrEmpty((String)(code = id.getTextData())) || (index = (code = code.trim()).lastIndexOf(95)) <= -1 || (typeString = code.substring(0, index).trim()).isEmpty() || code.isEmpty())) {
            IMemento rows;
            LookedUpMessage.LookedUpMessageType type = null;
            try {
                type = LookedUpMessage.LookedUpMessageType.valueOf((String)typeString);
            }
            catch (IllegalArgumentException e) {
                lookedUpMessage.setErrorMessage(MessageFormat.format(Messages.FATPQueries_unknownCodeType, typeString));
                return;
            }
            if (type != null && (rows = description.getChild("ROWS")) != null) {
                StringBuilder desc = new StringBuilder();
                IMemento[] iMementoArray = rows.getChildren("ROW");
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento row = iMementoArray[n2];
                    String rowData = row.getTextData();
                    desc.append(rowData == null ? System.lineSeparator() : rowData.trim()).append(System.lineSeparator());
                    ++n2;
                }
                if (desc.length() > 0) {
                    lookedUpMessage.setType(type);
                    lookedUpMessage.setCode(code);
                    lookedUpMessage.setDescription(desc.toString());
                    return;
                }
            }
        }
        lookedUpMessage.setErrorMessage(Messages.FATPQueries_parseDataError + ": " + root.toString());
    }

    public static FAVersionHolder.Version getVersionFromHost(String hostName, int port, IProgressMonitor monitor) {
        monitor.beginTask(Messages.FATPQueries_Checks_version, 2);
        final AtomicReference version = new AtomicReference();
        URI uri = FARL.getFARLURI((String)hostName, (String)String.valueOf(port), (String)"DOESNOTEXIST");
        if (uri != null) {
            FATPJob job = new FATPJob(Messages.FATPQueries_Checks_version, FARL.get_check_history_file_exists((URI)uri)){

                @Override
                protected void finalize_responses(IProgressMonitor monitor2) {
                    for (FATP[] requestResponse : this.responses) {
                        int ver = requestResponse[1].getHostVersion();
                        if (ver <= 0) continue;
                        String details = requestResponse[1].toString();
                        int index = details.indexOf(System.lineSeparator());
                        if (index > -1) {
                            details = details.substring(index + 1);
                        }
                        version.set(new FAVersionHolder.Version(ver, details + "\nHost Ver:" + ver));
                        return;
                    }
                }
            };
            FATPQueries.waitForJobAndLockUI(job, monitor, Messages.FATPQueries_versionBeginTask, Messages.FATPQueries_versionProgress);
        }
        return (FAVersionHolder.Version)version.get();
    }

    public static void waitForJobAndLockUI(Job job, IProgressMonitor monitor, String beginTaskMessage, String subtaskMessage) {
        Objects.requireNonNull(job, "Must provide a non-null job");
        Objects.requireNonNull(monitor, "Must provide a non-null monitor");
        monitor.beginTask(job.getName(), 100);
        job.schedule();
        int timeout = 600;
        if (Display.getCurrent() != null) {
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)new HostVersionFetchingOperation(!monitor.isCanceled() && job.getResult() == null && --timeout > 0, beginTaskMessage, subtaskMessage));
                monitor.worked(1);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getMessage());
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Cancelled", (String)e.getMessage());
            }
        }
        if (monitor.isCanceled()) {
            job.cancel();
        }
        monitor.done();
    }

    public static void waitForJob(Job job, IProgressMonitor monitor) {
        Objects.requireNonNull(job, "Must provide a non-null job");
        Objects.requireNonNull(monitor, "Must provide a non-null monitor");
        monitor.beginTask(job.getName(), 100);
        job.schedule();
        try {
            int timeout = 600;
            while (!monitor.isCanceled() && job.getResult() == null && --timeout > 0) {
                Thread.sleep(50L);
                monitor.worked(1);
            }
        }
        catch (InterruptedException e) {
            logger.info((Object)"Interrupted while waiting for job completion", (Throwable)e);
        }
        if (monitor.isCanceled()) {
            job.cancel();
        }
        monitor.done();
    }

    public static Result<List<SystemsViewBrowseView>> loadRecentViews(final IPDHost system, IProgressMonitor monitor) {
        final ArrayList v = new ArrayList();
        FATPJob job = new FATPJob(Messages.FATPQueries_Recent_views, FARL.get_view_list((URI)FARL.getFARLURI((String)system.getHostName(), (String)("" + system.getPort())))){

            @Override
            protected void finalize_responses(IProgressMonitor _mon) {
                for (FATP[] request_response : this.responses) {
                    if (!request_response[1].is_successful_response() || !request_response[1].get_status_code().equals("200")) continue;
                    logger.info((Object)request_response[0].toString());
                    String str = request_response[1].get_body(FARL.CHARSET_ENGLISH);
                    if (!str.contains(",")) continue;
                    String[] stringArray = str.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        v.add(SystemsViewBrowseView.create((IPDHost)system, (String)s));
                        ++n2;
                    }
                }
            }
        };
        FATPQueries.waitForJob(job, monitor);
        return new Result(v);
    }

    public static Result<List<SystemsViewHistoryFile>> loadRecentHistoryFiles(final IPDHost system, IProgressMonitor monitor) {
        if (system == null) {
            throw new IllegalArgumentException("Must provide a non-null IPDHost");
        }
        final ArrayList recentlyAccessedHFs = new ArrayList();
        FATPJob job = null;
        URI uri = FARL.getFARLURI((String)system.getHostName(), (String)("" + system.getPort()));
        Throwable throwable = null;
        Object var6_7 = null;
        try (FATP get_history_files = FARL.get_last_accessed_history_files((URI)uri);){
            logger.trace((Object)get_history_files);
            job = new FATPJob(Messages.FATPQueries_Recent_history_files, get_history_files){

                @Override
                protected void finalize_responses(IProgressMonitor _mon) {
                    for (FATP[] request_response : this.responses) {
                        List<SystemsViewHistoryFile> fileList;
                        if (!request_response[1].is_successful_response() || !request_response[1].get_status_code().equals("200") || (fileList = FATPQueries.processSuccessfulResponse(request_response, system)) == null) continue;
                        recentlyAccessedHFs.addAll(fileList);
                    }
                }
            };
            FATPQueries.waitForJob(job, monitor);
            if (!job.getResult().matches(8) && recentlyAccessedHFs.isEmpty()) {
                logger.trace((Object)get_history_files);
                job = new FATPJob(Messages.FATPQueries_Recent_history_files, get_history_files){

                    @Override
                    protected void finalize_responses(IProgressMonitor _mon) {
                        for (FATP[] request_response : this.responses) {
                            List<SystemsViewHistoryFile> fileList;
                            if (!request_response[1].is_successful_response() || !request_response[1].get_status_code().equals("200") || (fileList = FATPQueries.processSuccessfulResponse(request_response, system)) == null) continue;
                            recentlyAccessedHFs.addAll(fileList);
                        }
                    }
                };
                FATPQueries.waitForJob(job, monitor);
            }
            return new Result(recentlyAccessedHFs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static List<SystemsViewHistoryFile> processSuccessfulResponse(FATP[] request_response, IPDHost system) {
        List<SystemsViewHistoryFile> fileList = null;
        String[] content_type = request_response[1].get_entity_header("Content-Type").split(";", 2);
        String media_type = content_type[0].trim();
        String content_encoding = request_response[1].get_entity_header("Content-Encoding");
        if ((content_encoding.equals("identity") || content_encoding.equalsIgnoreCase("")) && (media_type.isEmpty() || media_type.equals("text/xml") || media_type.equals("text/plain"))) {
            Charset charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(request_response[1].get_entity_header("Content-Type"));
            fileList = FATPQueries.parseHistoryFileList(system, request_response, charset);
        }
        return fileList;
    }

    private static List<SystemsViewHistoryFile> parseHistoryFileList(IPDHost system, FATP[] request_response, Charset charset) {
        XMLMemento memento;
        ArrayList<SystemsViewHistoryFile> v = new ArrayList<SystemsViewHistoryFile>();
        String contents = request_response[1].get_body(charset).replaceAll("\u0000", " ");
        if (!contents.isEmpty() && (memento = MementoUtils.loadXMLMementoFromString((String)contents)) != null && memento.getType().equals("ul")) {
            IMemento[] iMementoArray = memento.getChildren("li");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento li = iMementoArray[n2];
                if (li.getString("id") != null && !li.getString("id").isEmpty()) {
                    IMemento[] iMementoArray2 = li.getChild("ul").getChildren("li");
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento lahf = iMementoArray2[n4];
                        v.add(new SystemsViewHistoryFile(system, lahf.getTextData().trim().toUpperCase(), ""));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return v;
    }

    public static enum EXISTS_STATUS {
        EXISTS,
        NOT_EXISTS,
        HOST_DOES_NOT_EXIST_CHECK;

    }
}

