/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.historyfile;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.HistoryFileAlllocationDetails;
import com.ibm.etools.fa.pdtclient.core.model.HistoryFileType;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.RecentlyUsedHostHistoryFileDatasetLookupDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.StringVerifiers;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class HistoryFileAllocationParametersDialog
extends Wizard {
    private HistoryFileAlllocationDetails model;

    private HistoryFileAllocationParametersDialog() {
    }

    public static int open(HistoryFileAlllocationDetails model) {
        return PDScrollableWizardDialog.openWizard((IWizard)new HistoryFileAllocationParametersDialog().init(model));
    }

    public void addPages() {
        this.addPage((IWizardPage)new HistoryFileAllocationParametersDialogPage(this.model));
    }

    public HistoryFileAllocationParametersDialog init(HistoryFileAlllocationDetails inModel) {
        Objects.requireNonNull(inModel, "Must provide a non-null model.");
        this.setWindowTitle(Messages.MissingParameters_CreateHistoryFile);
        this.model = inModel;
        this.setHelpAvailable(false);
        return this;
    }

    public boolean performFinish() {
        return true;
    }

    private static class DecoratingValidator
    implements IValidator {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private final ControlDecoration controlDecoration;
        private final IValidator validator;

        public DecoratingValidator(ControlDecoration controlDecoration, IValidator customValidation) {
            this.controlDecoration = controlDecoration;
            this.validator = customValidation;
        }

        public IStatus validate(Object value) {
            IStatus validate = this.validator.validate(value);
            if (!validate.isOK()) {
                this.controlDecoration.show();
                return ValidationStatus.error((String)validate.getMessage());
            }
            this.controlDecoration.hide();
            return ValidationStatus.ok();
        }
    }

    public static class HistoryFileAllocationParametersDialogPage
    extends WizardPage {
        private static final String PLEASE_SPECIFY_A_VALUE = Messages.HistoryFileAllocationParametersDialog_0;
        private HistoryFileAlllocationDetails model;

        protected HistoryFileAllocationParametersDialogPage(HistoryFileAlllocationDetails inModel) {
            super("HistoryFileAllocationParametersDialogPage", Messages.MissingParameters_CreateHistoryFile, null);
            this.model = inModel;
        }

        public void createControl(Composite parent) {
            DataBindingContext controller = new DataBindingContext();
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)controller);
            this.setMessage(Messages.RemoteHistoryFileInputDialog_0);
            Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
            this.createHistoryFileNameComposite(controller, composite);
            Composite fields = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)3));
            this.createPrimarySpaceControl(controller, fields);
            this.createSecondarySpaceControl(controller, fields);
            this.createFaultEntryPrefixControl(controller, fields);
            GUI.label.left((Composite)fields, (String)Messages.HistoryFileAllocationParametersDialog_DataSetType, (Object)GUI.grid.d.left1());
            final Combo dataSetType = GUI.combo.readOnly((Composite)fields, (Object)GUI.grid.d.fillH((int)1), (Object[])new String[]{HistoryFileType.LIBRARY.toString(), HistoryFileType.PDS.toString()});
            dataSetType.setToolTipText(Messages.HistoryFileAllocationParametersDialog_TypeShouldBeLibOrPds);
            dataSetType.setTextLimit(10);
            StringVerifiers.applyTo(dataSetType, StringVerifiers.ensureUpperNoSpacesOrQuotes());
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)dataSetType), BeanProperties.value((String)"HistoryFileType").observe((Object)this.model), null, null);
            dataSetType.select(0);
            final StackLayout stack = new StackLayout();
            final Composite minMaxFaultEntries = GUI.composite((Composite)fields, (Layout)stack, (Object)GUI.grid.d.fillH((int)2));
            final Composite min = GUI.composite((Composite)minMaxFaultEntries, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.standard());
            GUI.label.left((Composite)min, (String)Messages.HistoryFileAllocationParametersDialog_MinFE, (Object)GUI.grid.d.left1());
            Combo minFaultEntries = GUI.combo.editable((Composite)min, (Object)GUI.grid.d.fillH((int)1));
            minFaultEntries.setToolTipText(Messages.HistoryFileAllocationParametersDialog_MinFETooltip);
            minFaultEntries.addVerifyListener(StringVerifiers.textLimit(minFaultEntries, 7));
            minFaultEntries.addVerifyListener(StringVerifiers.NUMBER_FORCER);
            ComboValueSaver.assignTo((Combo)minFaultEntries, (String)(((Object)((Object)this)).getClass().getCanonicalName() + ".minFaultEntries")).setCustomItems(new String[]{"100"}, false);
            final Composite max = GUI.composite((Composite)minMaxFaultEntries, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.standard());
            GUI.label.left((Composite)max, (String)Messages.HistoryFileAllocationParametersDialog_MaxFE, (Object)GUI.grid.d.left1());
            Combo maxFaultEntries = GUI.combo.editable((Composite)max, (Object)GUI.grid.d.fillH((int)1));
            maxFaultEntries.setToolTipText(Messages.HistoryFileAllocationParametersDialog_MaxFETooltip);
            maxFaultEntries.addVerifyListener(StringVerifiers.textLimit(maxFaultEntries, 7));
            maxFaultEntries.addVerifyListener(StringVerifiers.NUMBER_FORCER);
            ComboValueSaver.assignTo((Combo)maxFaultEntries, (String)(((Object)((Object)this)).getClass().getCanonicalName() + ".maxFaultEntries")).setCustomItems(new String[]{"100"}, false);
            dataSetType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    stack.topControl = dataSetType.getText().equals(HistoryFileType.LIBRARY.toString()) ? min : max;
                    minMaxFaultEntries.layout();
                }
            });
            stack.topControl = min;
            minMaxFaultEntries.layout();
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)minFaultEntries), BeanProperties.value((String)"minMaxFaultEntries").observe((Object)this.model), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new DecoratingValidator(HistoryFileAllocationParametersDialogPage.createControlDecoration(minFaultEntries, PLEASE_SPECIFY_A_VALUE), HistoryFileAllocationParametersDialogPage.rangeValidator(25, 9999999))), null);
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)maxFaultEntries), BeanProperties.value((String)"minMaxFaultEntries").observe((Object)this.model), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new DecoratingValidator(HistoryFileAllocationParametersDialogPage.createControlDecoration(maxFaultEntries, PLEASE_SPECIFY_A_VALUE), HistoryFileAllocationParametersDialogPage.rangeValidator(25, 9999999))), null);
            controller.updateTargets();
            this.setControl((Control)parent);
        }

        private void createFaultEntryPrefixControl(DataBindingContext controller, Composite fields) {
            GUI.label.left((Composite)fields, (String)Messages.HistoryFileAllocationParametersDialog_FEPrefix, (Object)GUI.grid.d.left1());
            Combo faultEntryPrefix = GUI.combo.editable((Composite)fields, (Object)GUI.grid.d.fillH((int)1));
            faultEntryPrefix.setToolTipText(Messages.HistoryFileAllocationParametersDialog_FEPrefixTooltip);
            faultEntryPrefix.addVerifyListener(StringVerifiers.textLimit(faultEntryPrefix, 3));
            StringVerifiers.applyTo(faultEntryPrefix, StringVerifiers.ensureUpperNoSpacesOrQuotes());
            faultEntryPrefix.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    if (event.text != null && !event.text.trim().isEmpty() && !event.text.matches("[a-zA-Z]")) {
                        event.doit = false;
                    }
                }
            });
            ComboValueSaver.assignTo((Combo)faultEntryPrefix, (String)(((Object)((Object)this)).getClass().getCanonicalName() + ".faultEntryPrefix"));
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)faultEntryPrefix), BeanProperties.value((String)"faultEntryPrefix").observe((Object)this.model), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new DecoratingValidator(HistoryFileAllocationParametersDialogPage.createControlDecoration(faultEntryPrefix, PLEASE_SPECIFY_A_VALUE), new IValidator(){

                public IStatus validate(Object arg0) {
                    if (arg0 instanceof String && ((String)arg0).matches("[a-zA-Z]{1,3}")) {
                        return ValidationStatus.ok();
                    }
                    return ValidationStatus.error((String)Messages.HistoryFileAllocationParametersDialog_PrefixErrorMessage);
                }
            })), null);
        }

        private void createSecondarySpaceControl(DataBindingContext controller, Composite fields) {
            GUI.label.left((Composite)fields, (String)Messages.HistoryFileAllocationParametersDialog_SecSpace, (Object)GUI.grid.d.left1());
            Combo secondarySpace = GUI.combo.editable((Composite)fields, (Object)GUI.grid.d.fillH((int)1));
            secondarySpace.setToolTipText(Messages.HistoryFileAllocationParametersDialog_SecSpaceTooltip);
            secondarySpace.addVerifyListener(StringVerifiers.NUMBER_FORCER);
            secondarySpace.addVerifyListener(StringVerifiers.textLimit(secondarySpace, 4));
            ComboValueSaver.assignTo((Combo)secondarySpace, (String)(((Object)((Object)this)).getClass().getCanonicalName() + ".secondarySpace"));
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)secondarySpace), BeanProperties.value((String)"secondarySpace").observe((Object)this.model), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new DecoratingValidator(HistoryFileAllocationParametersDialogPage.createControlDecoration(secondarySpace, PLEASE_SPECIFY_A_VALUE), HistoryFileAllocationParametersDialogPage.rangeValidator(0, 9999))), null);
        }

        private void createPrimarySpaceControl(DataBindingContext controller, Composite fields) {
            GUI.label.left((Composite)fields, (String)Messages.HistoryFileAllocationParametersDialog_PrimarySpace, (Object)GUI.grid.d.left1());
            Combo wPrimarySpace = GUI.combo.editable((Composite)fields, (Object)GUI.grid.d.fillH((int)1));
            wPrimarySpace.setToolTipText(Messages.HistoryFileAllocationParametersDialog_PriSpaceTooltip);
            wPrimarySpace.addVerifyListener(StringVerifiers.NUMBER_FORCER);
            wPrimarySpace.addVerifyListener(StringVerifiers.textLimit(wPrimarySpace, 4));
            ComboValueSaver.assignTo((Combo)wPrimarySpace, (String)(((Object)((Object)this)).getClass().getCanonicalName() + ".primarySpace"));
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)wPrimarySpace), BeanProperties.value((String)"primarySpace").observe((Object)this.model), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new DecoratingValidator(HistoryFileAllocationParametersDialogPage.createControlDecoration(wPrimarySpace, PLEASE_SPECIFY_A_VALUE), HistoryFileAllocationParametersDialogPage.rangeValidator(1, 9999))), null);
        }

        private void createHistoryFileNameComposite(DataBindingContext controller, Composite composite) {
            Composite historyFileNameComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
            GUI.label((Composite)historyFileNameComposite, (String)Messages.RemoteHistoryFileInputDialog_1, (Object)GUI.grid.d.left1(), (int)0);
            Combo wHistoryFileName = GUI.combo((Composite)historyFileNameComposite, (Object)GUI.grid.d.standard(), (int)2048);
            StringVerifiers.applyTo(wHistoryFileName, StringVerifiers.ensureUpperNoSpacesOrQuotes());
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)wHistoryFileName), BeanProperties.value((String)"historyFileName").observe((Object)this.model), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new DecoratingValidator(HistoryFileAllocationParametersDialogPage.createControlDecoration(wHistoryFileName, Messages.RemoteHistoryFileInputDialog_2), new IValidator(){

                public IStatus validate(Object newText) {
                    if (Validator.validateDataSetName((String)((String)newText))) {
                        return ValidationStatus.ok();
                    }
                    return ValidationStatus.error((String)Messages.RemoteHistoryFileInputDialog_2);
                }
            })), null);
            ComboValueSaver.assignTo((Combo)wHistoryFileName, (String)"com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.RemoteHistoryFileInputDialog");
            GUI.button.push((Composite)historyFileNameComposite, (Image)new ImageLoader().getImageByName("com.ibm.pdtools.common.component.ui", "search"), (String)Messages.RemoteHistoryFileInputDialog_3, (Object)GUI.grid.d.left1(), (boolean)true, (int)64).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String choice;
                    SystemsViewHistoryFile promptForView = RecentlyUsedHostHistoryFileDatasetLookupDialog.promptForValue(model.getHost(), null);
                    if (promptForView != null && (choice = promptForView.getName()) != null) {
                        model.setHistoryFileName(choice);
                    }
                }
            });
        }

        private static ControlDecoration createControlDecoration(Combo wHistoryFileName, String errorText) {
            ControlDecoration controlDecoration = new ControlDecoration((Control)wHistoryFileName, 16512);
            controlDecoration.setDescriptionText(errorText);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            controlDecoration.setImage(fieldDecoration.getImage());
            return controlDecoration;
        }

        private static IValidator rangeValidator(final int from, final int to) {
            return new IValidator(){

                public IStatus validate(Object o) {
                    if (o != null && o instanceof String) {
                        try {
                            Integer integer = Integer.parseInt((String)o);
                            if (integer >= from && integer <= to) {
                                return ValidationStatus.ok();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return ValidationStatus.error((String)MessageFormat.format(Messages.HistoryFileAllocationParametersDialog_RangeValidationErrorMessage, from, to));
                }
            };
        }
    }
}

