/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;

public abstract class StringVerifiers {
    public static final VerifyListener QUOTE_REMOVER = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.text = event.text.replaceAll("'\"", "");
        }
    };
    public static final VerifyListener STRING_TRIM = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.text = event.text.trim();
        }
    };
    public static final VerifyListener UPPERCASER = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.text = event.text.toUpperCase();
        }
    };
    public static final VerifyListener NUMBER_FORCER = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            String newText = event.text;
            if (newText != null && !newText.trim().isEmpty()) {
                try {
                    Integer.parseInt(newText);
                }
                catch (NumberFormatException e) {
                    event.doit = false;
                }
            }
        }
    };

    public static List<VerifyListener> ensureUpperNoSpacesOrQuotes() {
        return Arrays.asList(QUOTE_REMOVER, STRING_TRIM, UPPERCASER);
    }

    public static final VerifyListener textLimit(final Combo combo2, final int width) {
        return new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String existingText;
                Object newText = event.text;
                if (newText != null && ((String)newText).length() > 0 && ((String)(newText = (existingText = combo2.getText()).substring(0, event.start) + (String)newText + existingText.substring(event.end))).length() > width) {
                    event.doit = false;
                }
            }
        };
    }

    public static void applyTo(Combo c, VerifyListener ... vl) {
        VerifyListener[] verifyListenerArray = vl;
        int n = vl.length;
        int n2 = 0;
        while (n2 < n) {
            VerifyListener v = verifyListenerArray[n2];
            c.addVerifyListener(v);
            ++n2;
        }
    }

    public static void applyTo(Combo c, List<VerifyListener> vl) {
        StringVerifiers.applyTo(c, vl.toArray(new VerifyListener[0]));
    }
}

