/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog;

import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.CustomItemValidatingComboValueSaverWithContentAssist;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SingleComboInputDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final IInputValidator validator;
    private Combo combo;
    private String comboLabel;
    protected String choice;
    private final String title;
    private final String message;
    private final List<VerifyListener> comboVerifiers;
    final CustomItemValidatingComboValueSaverWithContentAssist customItemValidatingComboValueSaver;

    public SingleComboInputDialog(String title, String message, String comboLabel, String comboSaverId, String defaultComboValue, IInputValidator validator, List<VerifyListener> comboVerifierListeners) {
        this.title = Objects.requireNonNull(title);
        this.message = Objects.requireNonNull(message);
        this.comboLabel = Objects.requireNonNull(comboLabel);
        this.validator = Objects.requireNonNull(validator);
        this.customItemValidatingComboValueSaver = new CustomItemValidatingComboValueSaverWithContentAssist(comboSaverId, validator, defaultComboValue);
        this.comboVerifiers = new ArrayList<VerifyListener>();
        if (comboVerifierListeners != null) {
            this.comboVerifiers.addAll(comboVerifierListeners);
        }
    }

    protected Composite createDialogContent(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label((Composite)composite, (String)this.comboLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.combo = GUI.combo((Composite)composite, (Object)GUI.grid.d.standard(), (int)2048);
        for (VerifyListener listener : this.comboVerifiers) {
            this.combo.addVerifyListener(listener);
        }
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SingleComboInputDialog.this.validateInput();
            }
        });
        this.customItemValidatingComboValueSaver.assignTo(this.combo);
        this.combo.setFocus();
        return composite;
    }

    private void validateInput() {
        this.setErrorMessage(this.validator.isValid(this.combo.getText()));
        this.setComplete(this.getErrorMessage() == null);
        if (this.isComplete()) {
            this.choice = this.combo.getText();
        }
    }

    protected void okPressed() {
        this.validateInput();
        if (this.isComplete()) {
            super.okPressed();
        }
    }

    public String getChoice() {
        return this.choice;
    }

    protected void cancelPressed() {
        this.choice = null;
        super.cancelPressed();
    }

    public Combo getCombo() {
        return this.combo;
    }
}

