/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.RecentlyUsedHostHistoryFileDatasetLookupDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.SingleComboInputWithLookupButtonDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.StringVerifiers;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;

public class RemoteHistoryFileInputDialog
extends SingleComboInputWithLookupButtonDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public RemoteHistoryFileInputDialog(final IPDHost host) {
        super(Messages.MissingParameters_AddHistoryFile, Messages.RemoteHistoryFileInputDialog_0, Messages.RemoteHistoryFileInputDialog_1, "com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.RemoteHistoryFileInputDialog", "", new IInputValidator(){

            public String isValid(String newText) {
                if (Validator.validateDataSetName((String)newText)) {
                    return null;
                }
                return Messages.RemoteHistoryFileInputDialog_2;
            }
        }, StringVerifiers.ensureUpperNoSpacesOrQuotes(), Messages.RemoteHistoryFileInputDialog_3);
        this.setLookupListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemsViewHistoryFile promptForView = RecentlyUsedHostHistoryFileDatasetLookupDialog.promptForValue(host, null);
                if (promptForView != null) {
                    RemoteHistoryFileInputDialog.this.choice = promptForView.getName();
                    if (RemoteHistoryFileInputDialog.this.getChoice() != null) {
                        RemoteHistoryFileInputDialog.this.getCombo().setText(RemoteHistoryFileInputDialog.this.getChoice());
                        RemoteHistoryFileInputDialog.this.getButton(0).setFocus();
                    } else {
                        RemoteHistoryFileInputDialog.this.getCombo().setFocus();
                    }
                }
            }
        });
    }

    public static String promptForValue(IPDHost host) {
        final RemoteHistoryFileInputDialog dialog = new RemoteHistoryFileInputDialog(host);
        final AtomicReference choice = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (dialog.open() != 1) {
                    choice.set(dialog.getChoice());
                }
            }
        });
        return (String)choice.get();
    }
}

