/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewBrowseView;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader.FATPQueries;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.FastSortLookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class RecentlyUsedHostViewDatasetLookupDialog
extends FastSortLookupDialog<SystemsViewBrowseView> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String[] subsystemLookupColumnNames = new String[]{Messages.RecentlyUsedHostViewDatasetLookupDialog_0};
    private static final String[] subsystemLabelList = new String[]{Messages.RecentlyUsedHostViewDatasetLookupDialog_1};

    public RecentlyUsedHostViewDatasetLookupDialog(IPDHost system) {
        this(Objects.requireNonNull(system, "Must provide a non-null system."), new String[]{""});
    }

    public RecentlyUsedHostViewDatasetLookupDialog(final IPDHost system, String[] initialPatternList) {
        super(subsystemLabelList, subsystemLookupColumnNames, new String[subsystemLabelList.length], SystemsViewBrowseView.class);
        Objects.requireNonNull(system, "Must provide a non-null system.");
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException {
                Result<List<SystemsViewBrowseView>> result = FATPQueries.loadRecentViews(system, (IProgressMonitor)monitor.getMonitor());
                if (result.isSuccessfulWithoutWarnings()) {
                    return (List)result.getOutput();
                }
                return Arrays.asList(Messages.RecentlyUsedHostViewDatasetLookupDialog_2);
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.RecentlyUsedHostViewDatasetLookupDialog_3});
        this.setInitialPatternList(initialPatternList);
    }

    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new RemoteViewViewerFilter()};
    }

    protected String getDialogName() {
        return Messages.RecentlyUsedHostViewDatasetLookupDialog_4;
    }

    public String getColumnText(Object item, int index) {
        return RecentlyUsedHostViewDatasetLookupDialog.getTableProperty(item, index);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof SystemsViewBrowseView) {
            SystemsViewBrowseView config = (SystemsViewBrowseView)element;
            switch (columnIndex) {
                case 0: {
                    return config.getViewName();
                }
            }
        } else if (element instanceof String && columnIndex == 0) {
            return (String)element;
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new RemoteViewDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public static SystemsViewBrowseView promptForView(IPDHost host, SystemsViewBrowseView selectedConfig) {
        Objects.requireNonNull(host, "Must provide a non-null host.");
        while (selectedConfig == null) {
            RecentlyUsedHostViewDatasetLookupDialog lookupDialog = new RecentlyUsedHostViewDatasetLookupDialog(host);
            if (lookupDialog.open() != 0) {
                return null;
            }
            selectedConfig = (SystemsViewBrowseView)lookupDialog.getFirstSelectedObject();
        }
        return selectedConfig;
    }

    protected String getSelectedName(SystemsViewBrowseView item) {
        return item.getViewName();
    }

    protected static class RemoteViewDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public RemoteViewDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof SystemsViewBrowseView) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return RecentlyUsedHostViewDatasetLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }

    private static class RemoteViewViewerFilter
    extends ViewerFilter {
        private RemoteViewViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof SystemsViewBrowseView && parentElement instanceof PatternState) {
                SystemsViewBrowseView subsystem = (SystemsViewBrowseView)element;
                PatternState input = (PatternState)parentElement;
                return RecentlyUsedHostViewDatasetLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)subsystem.getViewName());
            }
            return true;
        }
    }
}

