/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.DataSetAndIncludeCoupledDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.SingleComboInputDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.StringVerifiers;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.Display;

public abstract class PromptUserWithDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static IInputValidator DATASET_NAME_VALIDATOR = new IInputValidator(){

        public String isValid(String newText) {
            if (Validator.validateDataSetName((String)newText)) {
                return null;
            }
            return Messages.PromptUserWithDialog_0;
        }
    };
    public static IInputValidator DATASET_MEMBER_NAME_VALIDATOR = new IInputValidator(){

        public String isValid(String newText) {
            if (Validator.validateDataSetNameWithMember((String)newText)) {
                return null;
            }
            return Messages.PromptUserWithDialog_DSNAndMember;
        }
    };

    public static String askingForDatasetName(String title, String message, String comboLabel, String comboSaverId, String defaultComboValue) {
        return PromptUserWithDialog.askingForDatasetName(title, message, comboLabel, comboSaverId, defaultComboValue, DATASET_NAME_VALIDATOR);
    }

    public static String askingForDatasetMemberName(String title, String message, String comboLabel, String comboSaverId, String defaultComboValue) {
        return PromptUserWithDialog.askingForDatasetName(title, message, comboLabel, comboSaverId, defaultComboValue, DATASET_MEMBER_NAME_VALIDATOR);
    }

    public static String askingForDatasetName(String title, String message, String comboLabel, String comboSaverId, String defaultComboValue, IInputValidator validator) {
        final SingleComboInputDialog dialog = new SingleComboInputDialog(title, message, comboLabel, comboSaverId, defaultComboValue, validator, StringVerifiers.ensureUpperNoSpacesOrQuotes());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (dialog.open() == 1) {
                    return;
                }
            }
        });
        return dialog.getChoice();
    }

    public static DSNAndInclude askForDataSetAndIncludeTightlyCoupled(IPDHost host, String title, String message, String comboLabel, String comboSaverId, String defaultComboValue) {
        final DataSetAndIncludeCoupledDialog dialog = new DataSetAndIncludeCoupledDialog(host, title, message, comboLabel, comboSaverId, defaultComboValue, DATASET_NAME_VALIDATOR, StringVerifiers.ensureUpperNoSpacesOrQuotes());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (dialog.open() == 1) {
                    return;
                }
            }
        });
        if (dialog.getReturnCode() == 0) {
            return new DSNAndInclude(dialog.getChoice(), dialog.getIncludeDataSetValue());
        }
        return null;
    }

    public static class DSNAndInclude {
        private String dataSetName;
        private String includeDataSets;

        public DSNAndInclude(String dataSetName, String includeDataSets) {
            this.dataSetName = dataSetName;
            this.includeDataSets = includeDataSets;
        }

        public String getDataSetName() {
            return this.dataSetName;
        }

        public String getIncludeDataSets() {
            return this.includeDataSets;
        }
    }
}

