/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history;

import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FATPUtils {
    public static String getMediaTypeFromResponse(FATP response) {
        Objects.requireNonNull(response, "Must provide non-null response.");
        String get_entity_header = response.get_entity_header("Content-Type");
        String[] content_type = get_entity_header.split(";", 2);
        if (content_type.length > 0) {
            return content_type[0].trim();
        }
        return null;
    }

    public static String getCharsetFromResponse(FATP response) {
        Matcher matcher;
        Objects.requireNonNull(response, "Must provide non-null response.");
        String getEntityHeader = response.get_entity_header("Content-Type");
        String[] content_type = getEntityHeader.split(";", 2);
        if (content_type.length > 1 && (matcher = Pattern.compile("charset=(.+?)").matcher(content_type[1])).groupCount() > 0) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean isStatusCodeOk(FATP response) {
        Objects.requireNonNull(response, "Must provide non-null response.");
        String status_code = response.get_status_code();
        return status_code.equals("200");
    }

    public static boolean isStatusCodeNoContent(FATP response) {
        Objects.requireNonNull(response, "Must provide non-null response.");
        String status_code = response.get_status_code();
        return status_code.equals("204");
    }
}

