/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.faobjects.FaultAnalyzerParameters;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListDisplayedResource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteFaultEntryHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DeleteFaultEntryHandler.class);

    protected void handle(ExecutionEvent event) {
        if (Preferences.isConfirmDeleteEnabled() && !PDDialogs.openConfirm((String)Messages.DeleteFaultEntryHandler_DeleteFaultEntry, (String)Messages.DeleteFaultEntryHandler_DeleteFaultEntryConfirm)) {
            return;
        }
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof ReportsList) {
            HashMap<String, String> member_origin_list = new HashMap<String, String>();
            ReportsList reportsList = (ReportsList)activePart;
            List<Map<String, String>> selectedFaultEntries = reportsList.getSelectedFaultEntries();
            ReportsListDisplayedResource r = reportsList.getDisplayedResource();
            if (!selectedFaultEntries.isEmpty()) {
                for (Map<String, String> fault : selectedFaultEntries) {
                    String origin = FACorePlugin.getRoot().getFile(fault.get(ViewParser.class.getCanonicalName()).toString()).getProjectRelativePath().segment(2);
                    if (!member_origin_list.containsKey(origin)) {
                        member_origin_list.put(origin, "");
                    }
                    member_origin_list.put(origin, ((String)member_origin_list.get(origin)).concat(fault.get("FAULT_ID")).concat(","));
                }
                final StringBuffer messages = new StringBuffer();
                final CopyOnWriteArrayList<1> jobs = new CopyOnWriteArrayList<1>();
                for (Map.Entry entry : member_origin_list.entrySet()) {
                    String[] member_list2 = ((String)entry.getValue()).split(",");
                    Object members = "";
                    ArrayList<FATP> requests = new ArrayList<FATP>();
                    int i = 0;
                    while (i < member_list2.length) {
                        members = (String)members + member_list2[i] + ",";
                        if (i % 100 == 99 || i + 1 == member_list2.length) {
                            requests.add(FARL.delete_fault_entry((URI)FARL.getFARLURI((String)Ipv6Utils.decodeAndWrap((String)r.getResourceAddress()), (String)r.getResourceService(), (String)((String)entry.getKey()), (String)((String)members).substring(0, ((String)members).length() - 1))));
                            members = "";
                        }
                        ++i;
                    }
                    final FATPJob job = new FATPJob(Messages.DeleteFaultEntryHandler_DeleteFaultEntry, requests.toArray(new FATP[requests.size()]), null){

                        @Override
                        protected void finalize_responses(IProgressMonitor _monitor) {
                            for (FATP[] request_response : this.responses) {
                                FATP request = request_response[0];
                                FATP response = request_response[1];
                                if (!response.is_successful_response() || !"200".equals(response.get_status_code())) continue;
                                logger.debug((Object)request.toString());
                                Charset charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type"));
                                XMLMemento memento = MementoUtils.loadXMLMementoFromString((String)response.get_body(charset));
                                if (memento != null) {
                                    IMemento[] iMementoArray = memento.getChildren("tr");
                                    int n = iMementoArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IMemento tr = iMementoArray[n2];
                                        messages.append(tr.getChildren("td")[3].getTextData().trim() + "\n");
                                        ++n2;
                                    }
                                    continue;
                                }
                                logger.warn((Object)"A problem occurred while parsing response.");
                            }
                        }
                    };
                    jobs.add(job);
                    try {
                        job.set_user(FaultAnalyzerParameters.getUserFromHost(r.getResourceAddress(), r.getResourceService(), PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor())));
                    }
                    catch (InterruptedException e1) {
                        logger.error((Throwable)e1);
                        return;
                    }
                    job.schedule();
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            jobs.remove((Object)job);
                            if (jobs.isEmpty()) {
                                RefreshHistoryFile.refresh(true);
                            }
                        }
                    });
                }
                Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent e) {
                        if (messages.length() != 0) {
                            if (jobs.isEmpty()) {
                                Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                                return;
                            }
                            for (Job job : jobs) {
                                if (job.getResult() != null) continue;
                                return;
                            }
                            jobs.clear();
                            PDDialogs.openInfoThreadSafe((String)Messages.DeleteFaultEntryHandler_DeleteFaultEntryResult, (String)messages.toString());
                            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                        }
                    }
                });
            }
        }
    }
}

