/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.FAVersionHolder;
import com.ibm.etools.fa.pdtclient.ui.faobjects.FaultAnalyzerParameters;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.PromptUserWithDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader.FATPQueries;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.handler.historyfile.NewHistoryFileHandler;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListDisplayedResource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyFaultEntryHandler
extends SkeletonHandler {
    private static final PDLogger logger = PDLogger.get(CopyFaultEntryHandler.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        List<Map<String, String>> selectedFaultEntries;
        ReportsList reportsList;
        ReportsListDisplayedResource res;
        logger.trace((Object)"- - - - - - - - - -  Copy Fault Entry Start: - - - - - -- - - - ");
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof ReportsList && (res = (reportsList = (ReportsList)activePart).getDisplayedResource()).isAResourceBeingDisplayed() && !(selectedFaultEntries = reportsList.getSelectedFaultEntries()).isEmpty()) {
            final HashMap<String, String> member_origin_list = new HashMap<String, String>();
            for (Map<String, String> fe : selectedFaultEntries) {
                String origin = FACorePlugin.getRoot().getFile(fe.get(ViewParser.class.getCanonicalName()).toString()).getProjectRelativePath().segment(2);
                if (!member_origin_list.containsKey(origin)) {
                    member_origin_list.put(origin, "");
                }
                member_origin_list.put(origin, ((String)member_origin_list.get(origin)).concat(fe.get("FAULT_ID")).concat(","));
            }
            final IPDHost host = res.getHost() != null ? res.getHost() : PDTreeHandlerUtil.getHost((String)res.getResourceAddress(), (int)Integer.parseInt(res.getResourceService()));
            final PromptUserWithDialog.DSNAndInclude choices = PromptUserWithDialog.askForDataSetAndIncludeTightlyCoupled(host, Messages.CopyFaultEntryHandler_CopyFaultEntry, Messages.CopyFaultEntryHandler_0, Messages.FaultAnalyzerParameters_Dataset_destination_name, "com.ibm.etools.fa.pdtclient.ui.faobjects.history.CopyFaultEntryHandler.dest.dataset", member_origin_list.size() > 0 ? (String)member_origin_list.entrySet().iterator().next().getKey() : "");
            if (choices != null) {
                Job job = new Job(Messages.CopyFaultEntryHandler_CheckingIfHistoryFileExists){

                    protected IStatus run(IProgressMonitor monitor) {
                        Result<FATPQueries.EXISTS_STATUS> checkExistsResult = FATPQueries.checkExists(res.getResourceAddress(), res.getResourceService(), monitor, choices.getDataSetName());
                        FATPQueries.EXISTS_STATUS output = (FATPQueries.EXISTS_STATUS)((Object)checkExistsResult.getOutput());
                        if (FATPQueries.EXISTS_STATUS.NOT_EXISTS.equals((Object)output)) {
                            NewHistoryFileHandler.promptForHistoryFileParameters(null, host, choices.getDataSetName(), new JobChangeAdapter(){

                                public void done(IJobChangeEvent changeEvent) {
                                    if (changeEvent.getResult().isOK()) {
                                        CopyFaultEntryHandler.copyFaultEntry(host.getHostID(), res.getResourceAddress(), res.getResourceService(), choices.getDataSetName(), choices.getIncludeDataSets(), member_origin_list, true);
                                    }
                                }
                            });
                        } else {
                            CopyFaultEntryHandler.copyFaultEntry(host.getHostID(), res.getResourceAddress(), res.getResourceService(), choices.getDataSetName(), choices.getIncludeDataSets(), member_origin_list, true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    private static void copyFaultEntry(String hostId, String address, String service, String datasetDest, String includeDataSets, Map<String, String> memberOriginList, boolean showResultsDialog) {
        Objects.requireNonNull(address, "Must specify a non-null address.");
        Objects.requireNonNull(service, "Must specify a non-null service.");
        Objects.requireNonNull(datasetDest, "Must specify a non-null datasetDest.");
        Objects.requireNonNull(includeDataSets, "Must specify a non-null includeDataSets.");
        Objects.requireNonNull(memberOriginList, "Must specify a non-null member_origin_list.");
        logger.trace((Object)MessageFormat.format("copyFaultEntry: {0} {1} {2} {3} {4}", address, service, datasetDest, includeDataSets, memberOriginList));
        final StringBuffer messages = new StringBuffer();
        final ArrayList<Job> jobs = new ArrayList<Job>();
        String user = "";
        try {
            user = FaultAnalyzerParameters.getUserFromHost(address, service, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (InterruptedException e1) {
            logger.error((Throwable)e1);
            return;
        }
        for (Map.Entry<String, String> entry : memberOriginList.entrySet()) {
            CopyFaultEntryHandler.copyFaultEntriesFromSingleDataSet(hostId, address, service, datasetDest, includeDataSets, user, messages, jobs, entry.getKey(), entry.getValue());
        }
        if (showResultsDialog) {
            Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent e) {
                    if (!messages.toString().isEmpty()) {
                        if (jobs.isEmpty()) {
                            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                        } else {
                            for (Job job : jobs) {
                                if (job.getResult() != null) continue;
                                return;
                            }
                            jobs.clear();
                            PDDialogs.openInfoThreadSafe((String)Messages.CopyFaultEntryHandler_CopyFaultEntryResult, (String)messages.toString());
                            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                            logger.trace((Object)"- - - - - - - - - -  Copy Fault Entry End. - - - - - -- - - - ");
                        }
                    }
                }
            });
        }
    }

    private static void copyFaultEntriesFromSingleDataSet(String hostId, String address, String service, final String datasetDest, String includeDataSets, String user, final StringBuffer messages, ArrayList<Job> jobs, final String srcDataset, String srcMembers) {
        String[] member_list = srcMembers.split(",");
        Object members = "";
        ArrayList<FATP> requests = new ArrayList<FATP>();
        int i = 0;
        while (i < member_list.length) {
            members = (String)members + member_list[i] + ",";
            if (i % 100 == 99 || i + 1 == member_list.length) {
                URI _dst;
                URI _src = FARL.getFARLURI((String)Ipv6Utils.decodeAndWrap((String)address), (String)service, (String)srcDataset, (String)((String)members).substring(0, ((String)members).length() - 1));
                FATP fatp = FARL.copy_fault_entry((URI)_src, (URI)(_dst = FARL.getFARLURI((String)Ipv6Utils.decodeAndWrap((String)address), (String)service, (String)datasetDest)), (String)includeDataSets, (FAVersionHolder.getInstance().getVersion(hostId) >= 150102 ? 1 : 0) != 0);
                if (fatp == null) {
                    logger.error((Object)("Check source or destination dataset names? source:" + String.valueOf(_src) + " destination:" + String.valueOf(_dst)));
                } else {
                    requests.add(fatp);
                }
                members = "";
            }
            ++i;
        }
        FATPJob job = new FATPJob(Messages.CopyFaultEntryHandler_CopyFaultEntry, requests.toArray(new FATP[requests.size()]), null){

            @Override
            protected void finalize_responses(IProgressMonitor _monitor) {
                for (FATP[] request_response : this.responses) {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try {
                        FATP request = request_response[0];
                        try {
                            try (FATP response = request_response[1];){
                                String status_code;
                                if (response.is_successful_response() && (status_code = response.get_status_code()).equals("200")) {
                                    logger.debug((Object)request.toString());
                                    Charset charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type"));
                                    XMLMemento memento = MementoUtils.loadXMLMementoFromString((String)response.get_body(charset));
                                    if (memento != null) {
                                        IMemento[] iMementoArray = memento.getChildren("tr");
                                        int n = iMementoArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IMemento tr = iMementoArray[n2];
                                            messages.append(this.getResultMessageWithDataset(request, tr.getChildren("td")[3].getTextData().trim()) + "\n");
                                            ++n2;
                                        }
                                    }
                                }
                            }
                            if (request == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (request != null) {
                                request.close();
                            }
                            throw throwable;
                        }
                        request.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                if (srcDataset.equals(datasetDest)) {
                    logger.trace((Object)"copied to src so refreshing....");
                    RefreshHistoryFile.refresh(true);
                }
            }

            private String getResultMessageWithDataset(FATP request, String raw) {
                String[] parts;
                String get_request_uri = request.get_request_uri();
                if (get_request_uri != null && !get_request_uri.trim().isEmpty() && get_request_uri.trim().length() > 1 && (parts = get_request_uri.replace("/", "").split("\\(")).length > 0) {
                    String copiedTo = "copied to";
                    return parts[0].trim() + "(" + raw.trim().replace(copiedTo, ") " + copiedTo);
                }
                return raw;
            }
        };
        jobs.add(job);
        job.set_user(user);
        job.schedule();
    }
}

