/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history;

import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharsetResponseHelper {
    public static Charset getCharsetFromResponseOrEnglishFromContentTypeHeader(String contentTypeHeader) {
        return CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(contentTypeHeader, FARL.CHARSET_ENGLISH);
    }

    public static Charset getCharsetFromResponseOrDefaultFromContentTypeHeader(String contentTypeHeader) {
        return CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(contentTypeHeader, CharsetResponseHelper.getLanguageCharset());
    }

    public static Charset getCharsetFromResponseOrDefaultFromContentTypeHeader(String contentTypeHeader, Charset defaultCharset) {
        Matcher matcher;
        String[] content_type = contentTypeHeader.split(";", 2);
        if (content_type.length > 1 && (matcher = Pattern.compile("charset=(.+)").matcher(content_type[1])).find() && matcher.groupCount() > 0 && Charset.isSupported(matcher.group(1))) {
            return Charset.forName(matcher.group(1));
        }
        return defaultCharset;
    }

    @Deprecated
    public static Charset getCharsetFromSystem(String system) {
        if (system != null) {
            List allHostNodes = PDTreeContentHolder.getInstance().getNodesOfType(HostNode.class);
            for (HostNode hostNode : allHostNodes) {
                IPDHost host = (IPDHost)hostNode.getDataObject();
                if (host == null || system.compareTo(host.getDescription()) != 0) continue;
                return Charset.forName(host.getCodePage());
            }
        }
        return FARL.CHARSET_ENGLISH;
    }

    public static Charset getLanguageCharset() {
        switch (Activator.getDefault().getPreferenceStore().getString("com.ibm.etools.fa.pdtclient.ui.preferences.nl")) {
            case "ja": {
                return FARL.CHARSET_JAPANESE;
            }
            case "ko": {
                return FARL.CHARSET_KOREAN;
            }
        }
        return FARL.CHARSET_ENGLISH;
    }
}

