/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class BatchFATPJobExecutor {
    private static PDLogger logger = PDLogger.get(BatchFATPJobExecutor.class);

    public static Job runAllInOrder(final List<Job> jobs) {
        Objects.requireNonNull(jobs, "Please provide a non-null List of jobs to execute.");
        return new Job(Messages.BatchFATPJobExecutor_Working){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                int i = 0;
                for (Job job : jobs) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.beginTask(MessageFormat.format(Messages.BatchFATPJobExecutor_RunningJobName, i++, job.getName()), -1);
                    job.schedule();
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)"Cancelled.");
                        return Status.CANCEL_STATUS;
                    }
                    if (job.getResult().matches(8)) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!job.getResult().matches(4)) continue;
                    return job.getResult();
                }
                return Status.OK_STATUS;
            }
        };
    }
}

