/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faobjects.history;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

public class AutomaticReportsListRefreshJob
extends Job {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright IBM Corp. 2014. All rights reserved.";
    private static final int UNIT_CONVERSION = 60000;
    public static final String JOB_NAME = Messages.AutomaticReportsListRefreshJob_JobName;

    public AutomaticReportsListRefreshJob() {
        super(JOB_NAME);
    }

    protected IStatus run(IProgressMonitor mon) {
        if (!RefreshHistoryFile.isRefreshAlreadyRunning()) {
            RefreshHistoryFile.refresh(false);
        }
        this.scheduleRefresh();
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        return Preferences.isAutomaticReportsListRefreshEnabled();
    }

    public boolean belongsTo(Object family) {
        return this.getName().equals(family);
    }

    public void scheduleRefresh() {
        this.schedule(Preferences.getAutomaticReportsListRefreshInterval() * 60000);
    }

    public static void update() {
        AutomaticReportsListRefreshJob.cancelAnyJobs();
        if (Preferences.isAutomaticReportsListRefreshEnabled()) {
            AutomaticReportsListRefreshJob refreshJob = new AutomaticReportsListRefreshJob();
            refreshJob.scheduleRefresh();
        }
    }

    public static void cancelAnyJobs() {
        Job[] runningJobs;
        IJobManager jobManager = Job.getJobManager();
        Job[] jobArray = runningJobs = jobManager.find((Object)JOB_NAME);
        int n = runningJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.cancel();
            ++n2;
        }
    }
}

