/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.editor.localview;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewLocalView;
import com.ibm.etools.fa.pdtclient.ui.editor.localview.LocalViewEditorInput;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewLocalViewNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;

public class OpenLocalViewEditorHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.command.editor.localview.OpenLocalViewEditor";

    protected void handle(ExecutionEvent event) {
        SystemsTreeNode node = PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event);
        if (node instanceof SystemsViewLocalViewNode) {
            SystemsViewLocalView lv = (SystemsViewLocalView)((SystemsViewLocalViewNode)node).getDataObject();
            OpenLocalViewEditorHandler.openLocalView(lv.getSystem(), lv.getName());
        }
    }

    public static void openLocalView(IPDHost host, String name) {
        IFile localView = FAResourceUtils.getSpecifiedLocalViewHFMLFile((String)host.getHostName(), (String)("" + host.getPort()), (String)name);
        String localViewName = localView.getProjectRelativePath().toString();
        if (localView.exists()) {
            if (PDPlatformUIUtils.editor.openEditor((IEditorInput)new LocalViewEditorInput(localView, host), (String)"com.ibm.etools.fa.pdtclient.ui.editor.localview.LocalViewEditor") == null) {
                PDDialogs.openErrorThreadSafe((String)Messages.OpenLocalViewEditorHandler_ErrorTitleFailedToOpenEditor, (String)MessageFormat.format(Messages.OpenLocalViewEditorHandler_ErrorMessageErrorOccurredWhileOpeningEditor, localViewName));
            }
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.OpenLocalViewEditorHandler_ErrorTitleFileNotFound, (String)MessageFormat.format(Messages.OpenLocalViewEditorHandler_ErrorMessageFileCouldNotBeFound, localViewName));
        }
    }
}

