/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.editor.localview;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.editor.localview.LocalViewEditorInput;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.RemoteHistoryFileInputDialog;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnConfigurationTable;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.IColumnConfigurationUser;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewHistoryFileNode;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewLocalViewNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DecoratedText;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDXMLMementoUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.EditorPart;

public class LocalViewEditor
extends EditorPart
implements IColumnConfigurationUser {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.editor.localview.LocalViewEditor";
    private final PDLogger logger = PDLogger.get(LocalViewEditor.class);
    private Set<String> historyFilesInViewModel = new TreeSet<String>();
    private Composite outerEditorComposite;
    private Composite editorComposite;
    private Group nameGroup;
    private Label nameLabel;
    private DecoratedText nameText;
    private Label descriptionLabel;
    private DecoratedText descriptionText;
    private Composite listComposite;
    private Group localViewHistoryFilesGroup;
    private Composite viewHistoryFilesComposite;
    private Label historyFilesInViewLabel;
    private List historyFilesInViewList;
    private ListViewer historyFilesInViewListViewer;
    private Composite listButtonsComposite;
    private Button addHistoryFileButton;
    private Button removeHistoryFileButton;
    private Group defaultColumnConfigurationGroup;
    private ColumnConfigurationTable defaultColumnConfigurationTable;
    private boolean dirty;
    private IFile localViewFile;
    private IPDHost host;
    IResourceChangeListener resourceListener;

    public void doSave(IProgressMonitor monitor) {
        if (this.nameText.isValid() != null) {
            PDDialogs.openErrorThreadSafe((String)Messages.LocalViewEditor_ErrorTitleInvalidViewName, (String)this.nameText.isValid());
            monitor.setCanceled(true);
            return;
        }
        if (this.descriptionText.isValid() != null) {
            PDDialogs.openErrorThreadSafe((String)Messages.LocalViewEditor_ErrorTitleInvalidViewDescription, (String)this.descriptionText.isValid());
            monitor.setCanceled(true);
            return;
        }
        this.saveToLocalView();
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof LocalViewEditorInput)) {
            this.logger.error((Object)"Did not receive local view as input.");
            throw new RuntimeException();
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.host = ((LocalViewEditorInput)input).getHost();
        this.localViewFile = ((LocalViewEditorInput)input).getLocalViewFile();
        this.defaultColumnConfigurationTable = new ColumnConfigurationTable(this);
        this.setPartName(MessageFormat.format(Messages.LocalViewEditor_0, LocalViewEditor.getMemberName(this.localViewFile.getName())));
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GridData nameTextData = GUI.grid.d.fillH((int)1);
        nameTextData.widthHint = 300;
        nameTextData.horizontalIndent = 10;
        this.outerEditorComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.editorComposite = GUI.composite((Composite)this.outerEditorComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.outerEditorComposite.setBackground(this.editorComposite.getBackground());
        this.nameGroup = GUI.group((Composite)this.editorComposite, (String)Messages.LocalViewEditor_NameGroupTitle, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.nameLabel = GUI.label((Composite)this.nameGroup, (String)Messages.LocalViewEditor_NameLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.nameText = new DecoratedText(GUI.text((Composite)this.nameGroup, (Object)nameTextData, (int)4), new IInputValidator(){

            public String isValid(String newText) {
                if (!Validator.validateSegment((String)newText)) {
                    return Messages.LocalViewEditor_ErrorDecorationInvalidViewName;
                }
                IFile tempFile = FAResourceUtils.getSpecifiedLocalViewHFMLFile((String)LocalViewEditor.this.host.getHostName(), (String)Integer.toString(LocalViewEditor.this.host.getPort()), (String)newText.toUpperCase());
                if (tempFile.exists() && !tempFile.equals((Object)LocalViewEditor.this.localViewFile)) {
                    return Messages.LocalViewEditor_ViewNameExists;
                }
                return null;
            }
        });
        this.nameText.getTextWidget().setTextLimit(8);
        this.descriptionLabel = GUI.label((Composite)this.nameGroup, (String)Messages.LocalViewEditor_DescriptionLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.descriptionText = new DecoratedText(GUI.text((Composite)this.nameGroup, (Object)nameTextData, (int)4), new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() <= 40) {
                    return null;
                }
                return Messages.LocalViewEditor_ErrorDecorationInvalidViewDescription;
            }
        });
        this.descriptionText.getTextWidget().setTextLimit(40);
        this.listComposite = GUI.composite((Composite)this.editorComposite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.localViewHistoryFilesGroup = GUI.group((Composite)this.listComposite, (String)Messages.LocalViewEditor_HistoryFilesInViewGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.viewHistoryFilesComposite = GUI.composite((Composite)this.localViewHistoryFilesGroup, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.historyFilesInViewList = new List(this.viewHistoryFilesComposite, 2562);
        this.historyFilesInViewList.setLayoutData((Object)GUI.grid.d.fillAll());
        this.historyFilesInViewList.setToolTipText(Messages.LocalViewEditor_HistoryFilesInGroupTooltip);
        this.historyFilesInViewListViewer = new ListViewer(this.historyFilesInViewList);
        this.historyFilesInViewListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listButtonsComposite = GUI.composite((Composite)this.localViewHistoryFilesGroup, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GridDataFactory.fillDefaults().create());
        this.addHistoryFileButton = GUI.button.push((Composite)this.listButtonsComposite, (String)Messages.LocalViewEditor_AddButtonLabel, (Object)GridDataFactory.swtDefaults().create());
        this.removeHistoryFileButton = GUI.button.push((Composite)this.listButtonsComposite, (String)Messages.LocalViewEditor_RemoveButtonLabel, (Object)GridDataFactory.swtDefaults().create());
        this.defaultColumnConfigurationGroup = GUI.group((Composite)this.listComposite, (String)Messages.LocalViewEditor_DefaultViewColumnConfigurationGroupTitle, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.defaultColumnConfigurationTable.createTable((Composite)this.defaultColumnConfigurationGroup, GUI.grid.d.fillAll());
        this.defaultColumnConfigurationTable.setToolTipText(Messages.LocalViewEditor_ColumnConfigurationTableToolTipText);
        this.loadLocalView();
        this.historyFilesInViewListViewer.setInput(this.historyFilesInViewModel);
        this.addContextMenuToHFViewer();
        this.addDropSupportToHFViewer();
        this.setupListeners();
    }

    private void addDropSupportToHFViewer() {
        this.historyFilesInViewListViewer.addDropSupport(19, (Transfer[])new ByteArrayTransfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.historyFilesInViewListViewer){

            public boolean performDrop(Object data) {
                if (data instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)data;
                    for (Object item : selection.toList()) {
                        if (!(item instanceof SystemsDataNode)) continue;
                        SystemsDataNode new_name = (SystemsDataNode)item;
                        Object dataObj = new_name.getDataObject();
                        if (dataObj instanceof SystemsViewHistoryFile) {
                            LocalViewEditor.this.addHistoryFileToList(((SystemsViewHistoryFile)dataObj).copyName());
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                    if (selection != null && selection instanceof StructuredSelection) {
                        StructuredSelection ss = (StructuredSelection)selection;
                        for (Object o : ss.toList()) {
                            if (o instanceof SystemsViewHistoryFileNode) continue;
                            LocalSelectionTransfer.getTransfer().setSelection(null);
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void addContextMenuToHFViewer() {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.historyFilesInViewListViewer.getList());
        this.historyFilesInViewListViewer.getList().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.historyFilesInViewListViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.historyFilesInViewListViewer);
    }

    private void setupListeners() {
        this.nameText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalViewEditor.this.setDirty(true);
            }
        });
        this.descriptionText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalViewEditor.this.setDirty(true);
            }
        });
        this.historyFilesInViewList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\u007f': {
                        IStructuredSelection selection = (IStructuredSelection)LocalViewEditor.this.historyFilesInViewListViewer.getSelection();
                        if (selection.isEmpty() || selection.getFirstElement() == null) break;
                        String historyFileName = (String)selection.getFirstElement();
                        LocalViewEditor.this.removeHistoryFileFromList(historyFileName);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addHistoryFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dataSetName = RemoteHistoryFileInputDialog.promptForValue(LocalViewEditor.this.host);
                if (dataSetName != null && !dataSetName.trim().isEmpty()) {
                    LocalViewEditor.this.addHistoryFileToList(dataSetName);
                }
            }
        });
        this.removeHistoryFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LocalViewEditor.this.historyFilesInViewListViewer.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() != null) {
                    String historyFileName = (String)selection.getFirstElement();
                    LocalViewEditor.this.removeHistoryFileFromList(historyFileName);
                }
            }
        });
    }

    public void setFocus() {
        this.historyFilesInViewList.setFocus();
    }

    private boolean loadLocalView() {
        String viewFileName = LocalViewEditor.getMemberName(this.localViewFile.getName());
        this.nameText.getTextWidget().setText(viewFileName);
        try {
            IMemento[] liMementos;
            XMLMemento memento = PDXMLMementoUtils.loadMementoFromFile((File)this.localViewFile.getRawLocation().toFile());
            String description = memento.getString("title");
            if (description != null) {
                this.descriptionText.getTextWidget().setText(description);
            }
            IMemento[] iMementoArray = liMementos = memento.getChildren("li");
            int n = liMementos.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento liMemento = iMementoArray[n2];
                String historyFileName = liMemento.getTextData();
                if (Validator.validateDataSetName((String)historyFileName)) {
                    this.historyFilesInViewModel.add(historyFileName);
                }
                ++n2;
            }
            this.defaultColumnConfigurationTable.setTableContentsFromInputFile((IMemento)memento);
            return true;
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)MessageFormat.format("Could not find local view file {0}.", this.localViewFile.getName()), (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)Messages.LocalViewEditor_ErrorTitleCouldNotOpenFile, (String)MessageFormat.format(Messages.LocalViewEditor_ErrorMessageCouldNotFindLocalViewFile, this.localViewFile.getName()));
        }
        catch (IOException | CoreException e) {
            this.logger.error((Object)MessageFormat.format("An error occurred while opening the local view file {0}.", this.localViewFile.getName()), e);
            PDDialogs.openErrorThreadSafe((String)Messages.LocalViewEditor_ErrorTitleCouldNotOpenFile, (String)MessageFormat.format(Messages.LocalViewEditor_ErrorMessageErrorOpeningFile, this.localViewFile.getName()));
        }
        return false;
    }

    void addHistoryFileToList(String historyFileName) {
        this.historyFilesInViewModel.add(historyFileName);
        this.setDirty(true);
        this.historyFilesInViewListViewer.refresh();
        this.historyFilesInViewListViewer.setSelection((ISelection)new StructuredSelection((Object)historyFileName));
    }

    private void removeHistoryFileFromList(String historyFileName) {
        this.logger.trace((Object)("removeHistoryFileFromList: " + historyFileName));
        this.historyFilesInViewModel.remove(historyFileName);
        this.setDirty(true);
        this.historyFilesInViewListViewer.refresh();
        if (!this.historyFilesInViewModel.isEmpty()) {
            this.historyFilesInViewListViewer.setSelection((ISelection)new StructuredSelection((Object)this.historyFilesInViewModel.iterator().next()));
        }
    }

    private void saveToLocalView() {
        final String oldPath = this.localViewFile.getProjectRelativePath().toString();
        String oldName = LocalViewEditor.getMemberName(this.localViewFile.getName());
        if (!oldName.equals(this.nameText.getTextWidget().getText().trim())) {
            try {
                this.localViewFile.move((IPath)new Path(LocalViewEditor.createFileName(this.nameText.getTextWidget().getText().trim().toUpperCase())), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                this.logger.error((Object)MessageFormat.format("An error occurred while saving the local view file {0}.", this.localViewFile.getName()), (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)Messages.LocalViewEditor_ErrorTitleFailedToSaveFile, (String)MessageFormat.format(Messages.LocalViewEditor_ErrorMessageErrorSavingFile, this.localViewFile.getName()));
                return;
            }
            this.localViewFile = FAResourceUtils.getSpecifiedLocalViewHFMLFile((String)this.host.getHostName(), (String)("" + this.host.getPort()), (String)this.nameText.getTextWidget().getText().trim().toUpperCase());
            Activator.updateAll(SystemsViewLocalViewNode.class);
            PDSystemsView.tryRefresh();
            this.setPartName(MessageFormat.format(Messages.LocalViewEditor_0, LocalViewEditor.getMemberName(this.localViewFile.getName())));
            this.setTitleToolTip(LocalViewEditor.getMemberName(this.localViewFile.getName()));
            this.nameText.getTextWidget().setText(this.nameText.getTextWidget().getText().toUpperCase());
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)"ul");
        memento.putString("class", "view");
        memento.putString("title", this.descriptionText.getTextWidget().getText().trim());
        for (String historyFile : this.historyFilesInViewModel) {
            IMemento newListing = memento.createChild("li");
            newListing.putTextData(historyFile.trim());
        }
        this.defaultColumnConfigurationTable.saveConfiguration((IMemento)memento);
        if (!MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)memento, (IFile)this.localViewFile, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor())) {
            this.logger.error((Object)MessageFormat.format("An error occurred while saving the local view file {0}.", this.localViewFile.getName()));
            PDDialogs.openErrorThreadSafe((String)Messages.LocalViewEditor_ErrorTitleFailedToSaveFile, (String)MessageFormat.format(Messages.LocalViewEditor_ErrorMessageErrorSavingFile, this.localViewFile.getName()));
        } else {
            this.setDirty(false);
            final String view2 = this.nameText.getTextWidget().getText().trim().toUpperCase();
            Job updateReportsList = new Job(Messages.LocalViewEditor_1){

                protected IStatus run(IProgressMonitor monitor) {
                    ReportsList reportsList = ReportsList.getIfOpen();
                    if (reportsList != null && oldPath.equals(reportsList.getInputName())) {
                        RefreshHistoryFile.refresh(LocalViewEditor.this.host, LocalViewEditor.this.host.getHostName(), "" + LocalViewEditor.this.host.getPort(), "local.views", view2);
                        ReportsList.setSource(LocalViewEditor.this.host, LocalViewEditor.this.localViewFile.getProjectRelativePath().toString());
                    }
                    return Status.OK_STATUS;
                }
            };
            updateReportsList.setUser(true);
            updateReportsList.schedule();
        }
    }

    public static String getMemberName(String fileName) {
        return fileName.split("\\(")[1].split("\\)")[0];
    }

    public static String createFileName(String member) {
        return "local.views(" + member + ").hfml";
    }

    @Override
    public void setDirtyByTable() {
        this.setDirty(true);
    }

    public void removeSelectedHFs() {
        for (Object hf : ((StructuredSelection)this.historyFilesInViewListViewer.getSelection()).toList()) {
            this.removeHistoryFileFromList((String)hf);
        }
    }
}

