/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.dump;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.dump.DumpNode;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.Node;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.system.SystemNode;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class DumpsNode
extends Node<DumpNode> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public DumpsNode(String address, String port, String path) {
        super(address, port, path, "Dumps");
    }

    @Override
    public String getDescription() {
        return "Dumps " + this.getClass().getCanonicalName();
    }

    @Override
    public Image getImage() {
        return Activator.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String getText() {
        return "Dumps " + this.getClass().getCanonicalName();
    }

    public SystemNode getParent() {
        return new SystemNode(this.getHost(), this.getPort());
    }

    @Override
    public Collection<Node<?>> getChildren() {
        ArrayList dumps = new ArrayList();
        IFolder system = FACorePlugin.getRoot().getFolder(this.getPath());
        if (system.exists()) {
            Collection members = IResourceUtils.ls((IFolder)system, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
            for (IResource member : members) {
                if (!member.getName().endsWith(".zip dump")) continue;
                dumps.add(new DumpNode(this.getHost(), this.getPort(), member.getProjectRelativePath().toString()));
            }
        } else {
            logger.warn((Object)(String.valueOf(system) + " doesn't exist, so doesn't have children."));
        }
        return dumps;
    }
}

