/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.dialog;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.DuplicateInfo;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.FaultEntries;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.FaultEntryInfo;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnNames;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FaultEntryPropertiesDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String NOT_APPLICABLE = Messages.PropertiesHandler_NotApplicable;
    private static final String NOT_LOCKED_MESSAGE = "(Not locked)";
    private static final String LOCKED_INDEFINITELY_MESSAGE = "(Locked indefinitely)";
    private static final String LOCKED_DAYS_REMAINING_MESSAGE_FORMAT = "(Locked days remaining: %d)";
    private static final int MAX_USERNAME_LENGTH = 8;
    private static final int MAX_USER_TITLE_LENGTH = 40;
    private static final int MAX_LOCK_FLAG_LENGTH = 2;
    private static final int SCROLL_SPEED_MULTIPLIER = 3;
    private FATPJob job;
    private Map<String, Text> editableFields;
    private Map<String, String> originalValues;
    private String faultEntry;
    private String faultID;

    public FaultEntryPropertiesDialog(String historyFileIndexPath, String faultID) {
        Objects.requireNonNull(historyFileIndexPath, "Must provide a non-null historyFileIndexPath.");
        this.editableFields = new HashMap<String, Text>();
        this.originalValues = new HashMap<String, String>();
        this.faultEntry = Ipv6Utils.encodedFaultIdPathToUri((String)historyFileIndexPath, (String)faultID);
        this.faultID = faultID;
    }

    private static int getLockDurationRemaining(Calendar abendDate, int lockDuration) {
        int lockDurationRemaining = 0;
        Calendar todaysDate = Calendar.getInstance();
        long dateDifference = todaysDate.getTimeInMillis() - abendDate.getTimeInMillis();
        int daysSinceCreation = (int)((float)dateDifference / 8.64E7f);
        if (daysSinceCreation >= 0 && lockDuration > daysSinceCreation) {
            lockDurationRemaining = lockDuration - daysSinceCreation;
        }
        return lockDurationRemaining;
    }

    private static Calendar getDateFromString(String dateString) {
        Calendar creationDate = null;
        try {
            Date parsedDate = new SimpleDateFormat("yyyy/MM/dd", Locale.ENGLISH).parse(dateString);
            creationDate = Calendar.getInstance();
            creationDate.setTime(parsedDate);
        }
        catch (ParseException e) {
            logger.warn((Throwable)e);
        }
        return creationDate;
    }

    private void addListenerForUpdatingInfoLabel(final Text lockFlagTextField, final Label infoLabel, final Calendar abendDate) {
        ModifyListener fieldModificationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FaultEntryPropertiesDialog.this.setLockFlagMessage(lockFlagTextField, infoLabel, abendDate);
            }
        };
        lockFlagTextField.addModifyListener(fieldModificationListener);
    }

    private void setLockFlagMessage(Text lockField, Label infoLabel, Calendar abendDate) {
        String hintMessage;
        String trimmedValue = lockField.getText().trim();
        Pattern numberOfDaysPattern = Pattern.compile("^(\\d+)$");
        Matcher numberOfDaysMatcher = numberOfDaysPattern.matcher(trimmedValue);
        if (trimmedValue.isEmpty()) {
            hintMessage = NOT_LOCKED_MESSAGE;
        } else if (numberOfDaysMatcher.matches() && numberOfDaysMatcher.groupCount() == 1 && abendDate != null) {
            int lockDuration = Integer.valueOf(numberOfDaysMatcher.group(1));
            int lockDurationRemaining = FaultEntryPropertiesDialog.getLockDurationRemaining(abendDate, lockDuration);
            hintMessage = String.format(LOCKED_DAYS_REMAINING_MESSAGE_FORMAT, lockDurationRemaining);
        } else if (trimmedValue.matches("\\([LN].+")) {
            hintMessage = "";
            for (Map.Entry<String, Text> editableFieldEntry : this.editableFields.entrySet()) {
                editableFieldEntry.getValue().setEditable(false);
            }
        } else {
            hintMessage = LOCKED_INDEFINITELY_MESSAGE;
        }
        infoLabel.setText(hintMessage);
    }

    private static Point getIdealTextBoxSize(Text textField, int maxCharacters) {
        GC gc = new GC((Drawable)textField);
        FontMetrics fm = gc.getFontMetrics();
        int width = maxCharacters * fm.getAverageCharWidth();
        int height = fm.getHeight();
        gc.dispose();
        return new Point(width, height);
    }

    private Text addEditableTextField(Composite propertyComposite, String label, String currentValue, int maxValueLength) {
        currentValue = currentValue == null ? NOT_APPLICABLE : currentValue.trim();
        int currentValueLength = currentValue.length();
        maxValueLength = currentValueLength > maxValueLength ? currentValueLength : maxValueLength;
        Text textField = new Text(propertyComposite, 2052);
        textField.setText(currentValue);
        textField.setTextLimit(maxValueLength);
        textField.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.editableFields.put(label, textField);
        this.originalValues.put(label, currentValue);
        return textField;
    }

    private static void addProperty(Composite propertyComposite, String label, String value, String tooltip) {
        Label lab = new Label(propertyComposite, 0);
        lab.setText(label);
        lab.setToolTipText(tooltip);
        Text text = new Text(propertyComposite, 12);
        text.setText(value == null ? NOT_APPLICABLE : value.trim());
        text.setToolTipText(tooltip);
        text.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
    }

    private Text addEditableProperty(Composite propertyComposite, String label, String currentValue, int maxValueLength, String tooltip) {
        Label lab = new Label(propertyComposite, 0);
        lab.setText(label);
        lab.setToolTipText(tooltip);
        Text text = this.addEditableTextField(propertyComposite, label, currentValue, maxValueLength);
        text.setToolTipText(tooltip);
        return text;
    }

    private Label addEditablePropertyWithExtraLabel(Composite propertyComposite, String label, String currentValue, int maxValueLength, String tooltip) {
        Label lab = new Label(propertyComposite, 0);
        lab.setText(label);
        lab.setToolTipText(tooltip);
        Composite nestedComposite = new Composite(propertyComposite, 0);
        nestedComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout nestedCompositeLayout = new GridLayout(2, false);
        nestedCompositeLayout.marginWidth = 0;
        nestedCompositeLayout.marginHeight = 0;
        nestedComposite.setLayout((Layout)nestedCompositeLayout);
        Text text = this.addEditableTextField(nestedComposite, label, currentValue, maxValueLength);
        text.setToolTipText(tooltip);
        Label infoLabel = new Label(nestedComposite, 0);
        infoLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        infoLabel.setToolTipText(tooltip);
        nestedComposite.pack();
        return infoLabel;
    }

    private void addProperties(Composite propertyComposite, FaultEntryInfo info) {
        this.addEditableProperty(propertyComposite, Messages.PropertiesHandler_Username, info.getUserName(), 8, ColumnNames.USERNAME_TOOLTIP);
        this.addEditableProperty(propertyComposite, Messages.PropertiesHandler_UserTitle, info.getUserTitle(), 40, ColumnNames.USER_TITLE_TOOLTIP);
        Label infoLabel = this.addEditablePropertyWithExtraLabel(propertyComposite, Messages.PropertiesHandler_LockFlag, info.getLockFlag(), 2, ColumnNames.LOCKED_TOOLTIP);
        Text lockFlagTextField = this.editableFields.get(Messages.PropertiesHandler_LockFlag);
        Calendar abendDate = FaultEntryPropertiesDialog.getDateFromString(info.getAbendDate());
        this.setLockFlagMessage(lockFlagTextField, infoLabel, abendDate);
        this.addListenerForUpdatingInfoLabel(lockFlagTextField, infoLabel, abendDate);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_LockUserID, info.getLockUserID(), ColumnNames.LOCK_USERID_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_AbendCode, info.getAbendCode(), ColumnNames.ABEND_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_PofModuleName, info.getPofModuleName(), ColumnNames.MODULE_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_PofProgramName, info.getPofProgramName(), ColumnNames.PROGRAM_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_PofOffset, info.getPofOffset(), ColumnNames.OFFSET_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_AbendData, info.getAbendDate(), ColumnNames.DATE_STR_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_AbendTime, info.getAbendTime(), ColumnNames.TIME_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_JobName, info.getJobName(), ColumnNames.JOBNAME_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_JobId, info.getJobID(), ColumnNames.JOB_ID_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_JobExecutionClass, info.getJobExecutionClass(), "CLASS");
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_JobType, info.getJobType(), ColumnNames.JOB_TYPE_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_JobStepName, info.getJobStepName(), ColumnNames.STEPNAME_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_ExecProgramName, info.getExecProgramName(), ColumnNames.EXEC_PGM_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_UserId, info.getUserID(), ColumnNames.USER_ID_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_GroupId, info.getGroupID(), ColumnNames.GROUP_ID_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_SystemName, info.getSystemName(), ColumnNames.SYSTEM_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_ApplicationId, info.getApplicationID(), ColumnNames.APPL_ID_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_CicsTransactionId, info.getCicsTransactionID(), ColumnNames.CICS_TRN_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_CicsTaskNumber, info.getCicsTaskNumber(), ColumnNames.TASK_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_CicsTerminalId, info.getCicsTerminalID(), ColumnNames.TERM_ID_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_CicsTerminalNetname, info.getCicsTerminalNetName(), ColumnNames.NETNAME_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_ImsProgramName, info.getImsProgramName(), ColumnNames.IMS_PGM_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_AccountingInformation, info.getAccountingInformation(), ColumnNames.ACCT_INFO_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_DuplicateCount, info.getDuplicateCount(), ColumnNames.DUPS_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_MinidumpPages, info.getMiniDumpPages(), ColumnNames.MD_PAGES_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_HistoryFileDataSetName, info.getHistoryFileDatasetName(), ColumnNames.HISTORY_FILE_DSN_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_MvsDumpDataSetName, info.getMvsDumpDatasetName(), ColumnNames.MVS_DUMP_DSN_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_MvsDumpStatus, info.getMvsDumpStatus(), ColumnNames.MVS_DUMP_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_InvokingExit, info.getInvokingExit(), ColumnNames.INVOKING_EXIT_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.PropertiesHandler_CPUSeconds, info.getCpuSeconds(), ColumnNames.CPU_SEC_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.FaultEntryPropertiesDialog_DTFJStatus, info.getDTFJStatus(), ColumnNames.DTFJ_STATUS_TOOLTIP);
        FaultEntryPropertiesDialog.addProperty(propertyComposite, Messages.FaultEntryPropertiesDialog_Locked, info.getLocked(), ColumnNames.LOCKED_TOOLTIP);
    }

    private void populateInformationTab(TabFolder tabFolder, TabItem infoTab, FaultEntryInfo informationData) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tabFolder, 768);
        Composite propertyComposite = new Composite((Composite)scrolledComposite, 0);
        propertyComposite.setLayout((Layout)new GridLayout(2, false));
        this.addProperties(propertyComposite, informationData);
        scrolledComposite.setContent((Control)propertyComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(propertyComposite.computeSize(-1, -1));
        propertyComposite.pack();
        scrolledComposite.pack();
        scrolledComposite.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                scrolledComposite.setFocus();
            }
        });
        int scrollIncrementSize = scrolledComposite.getVerticalBar().getIncrement() * 3;
        scrolledComposite.getVerticalBar().setIncrement(scrollIncrementSize);
        infoTab.setControl((Control)scrolledComposite);
    }

    private static void populateDuplicateInformationTab(TabFolder tabFolder, TabItem duplicateTab, DuplicateInfo duplicateInformationData) {
        Composite dup_composite = new Composite((Composite)tabFolder, 0);
        dup_composite.setLayout((Layout)new FormLayout());
        Table summary = new Table(dup_composite, 32772);
        TableColumn dup_key_column = new TableColumn(summary, 131072);
        TableColumn dup_val_column = new TableColumn(summary, 16384);
        duplicateTab.setControl((Control)dup_composite);
        TableItem item = new TableItem(summary, 0);
        item.setText(new String[]{Messages.PropertiesHandler_MostRecentDuplicateOccured, duplicateInformationData.getRecentDupTime() == null ? NOT_APPLICABLE : duplicateInformationData.getRecentDupTime()});
        item = new TableItem(summary, 0);
        item.setText(new String[]{Messages.PropertiesHandler_InitialAbendOccured, duplicateInformationData.getInitAbendTime() == null ? NOT_APPLICABLE : duplicateInformationData.getInitAbendTime()});
        item = new TableItem(summary, 0);
        item.setText(new String[]{Messages.PropertiesHandler_TotalDuplicateCount, duplicateInformationData.getDupCount() == null ? NOT_APPLICABLE : duplicateInformationData.getDupCount()});
        dup_key_column.pack();
        dup_val_column.pack();
        FormData data = new FormData();
        data.left = new FormAttachment((Control)dup_composite, 7);
        data.top = new FormAttachment((Control)dup_composite, 7);
        summary.setLayoutData((Object)data);
        Label details_label = new Label(dup_composite, 0);
        details_label.setText(Messages.PropertiesHandler_DuplicateDetailsInReverseChronologicalOrder);
        data = new FormData();
        data.left = new FormAttachment((Control)dup_composite, 7);
        data.top = new FormAttachment((Control)summary, 11);
        details_label.setLayoutData((Object)data);
        Table details = new Table(dup_composite, 34820);
        details.setLinesVisible(true);
        details.setHeaderVisible(true);
        String[] stringArray = ColumnNames.DUPLICATE_COLUMN_NAMES;
        int n = ColumnNames.DUPLICATE_COLUMN_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            TableColumn col = new TableColumn(details, 0);
            col.setText(column);
            col.pack();
            ++n2;
        }
        data = new FormData();
        data.left = new FormAttachment((Control)dup_composite, 7);
        data.right = new FormAttachment(100, -7);
        data.top = new FormAttachment((Control)details_label, 7);
        data.bottom = new FormAttachment(100, -7);
        details.setLayoutData((Object)data);
        for (Map<String, String> detail : duplicateInformationData.getDupDetails()) {
            TableItem detail_item = new TableItem(details, 0);
            String[] strings = new String[ColumnNames.DUPLICATE_COLUMN_NAMES.length];
            int c = 0;
            while (c < ColumnNames.DUPLICATE_COLUMN_NAMES.length) {
                strings[c] = detail.get(ColumnNames.DUPLICATE_COLUMN_NAMES[c]);
                ++c;
            }
            detail_item.setText(strings);
        }
    }

    private IFile createTempPropertyStorageFile(FATP request, String responseContents) {
        IFile indexFile;
        IFolder folder;
        IFolder server_local = FACorePlugin.getRoot().getFolder(request.getHostOSPath());
        String uri = request.get_request_uri();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!(folder = server_local.getFolder(uri = uri.replaceAll("\\(.*?\\)$", ""))).exists()) {
            IResourceUtils.mkdirs((IFolder)folder, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        if (!(indexFile = folder.getFile(this.faultID + ".hfml")).exists()) {
            try {
                IResourceUtils.createEmptyIFile((IFile)indexFile, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                indexFile.setHidden(true);
            }
            catch (CoreException e) {
                logger.warn((Throwable)e);
            }
        }
        IResourceUtils.setIFileContents((IFile)indexFile, (String)responseContents, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        return indexFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlePropertyResponse(IProgressMonitor _monitor, FATP[] request_response, Composite composite, final TabFolder tabFolder, final TabItem informationTab, final TabItem duplicateInformationTab) {
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            FATP request = request_response[0];
            try {
                try (FATP response = request_response[1];){
                    Charset charset;
                    String responseContents;
                    String status_code;
                    if (response.is_successful_response() && (status_code = response.get_status_code()).equals("200") && (responseContents = response.get_body(charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type"))).replaceAll("\u0000", " ")) != null) {
                        IFile indexFile = this.createTempPropertyStorageFile(request, responseContents);
                        FaultEntries faultInformationProperties = ViewParser.parse(indexFile.getProjectRelativePath().toString());
                        HashMap propertyMap = (HashMap)faultInformationProperties.getList()[0];
                        final FaultEntryInfo info = faultInformationProperties.getInfo(propertyMap);
                        final DuplicateInfo dup_info = faultInformationProperties.getDupInfo(propertyMap);
                        composite.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FaultEntryPropertiesDialog.this.populateInformationTab(tabFolder, informationTab, info);
                                FaultEntryPropertiesDialog.populateDuplicateInformationTab(tabFolder, duplicateInformationTab, dup_info);
                                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                                FaultEntryPropertiesDialog.this.getShell().setSize(FaultEntryPropertiesDialog.this.getShell().getBounds().width, screenSize.height / 2);
                            }
                        });
                        IResourceUtils.deleteIFile((IFile)indexFile, (boolean)true, (boolean)false, (IProgressMonitor)_monitor, (boolean)false);
                    }
                }
                if (request == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (request == null) throw throwable;
                request.close();
                throw throwable;
            }
            request.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void saveFieldValues(FATP[] requests) {
        FATPJob saveFieldValuesJob = new FATPJob(Messages.PropertiesHandler_SavingUpdatedFaultEntryPropertyValues, requests, null){

            @Override
            protected void finalize_responses(IProgressMonitor _monitor) {
            }
        };
        saveFieldValuesJob.schedule();
    }

    private String getModifiedFieldValue(String fieldLabel) {
        String newValue = null;
        Text textField = this.editableFields.get(fieldLabel);
        if (textField != null) {
            String originalValue = this.originalValues.get(fieldLabel);
            String currentValue = textField.getText();
            if (!currentValue.equals(originalValue)) {
                newValue = currentValue;
            }
        }
        return newValue;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.PropertiesHandler_FaultEntryInformation);
        this.setTitle(Messages.PropertiesHandler_FaultEntryInformation);
        this.setMessage(this.faultEntry);
        final Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        final TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        final TabItem info_tab = new TabItem(tabFolder, 0);
        info_tab.setText(Messages.PropertiesHandler_FaultEntryInformation);
        Label wait_label = new Label((Composite)tabFolder, 0);
        wait_label.setText(Messages.PropertiesHandler_RetrievingFaultEntryInformation);
        info_tab.setControl((Control)wait_label);
        final TabItem dup_tab = new TabItem(tabFolder, 0);
        dup_tab.setText(Messages.PropertiesHandler_DuplicatesInformation);
        Label label = new Label((Composite)tabFolder, 0);
        label.setText(Messages.PropertiesHandler_RetrievingDuplicatesInformation);
        dup_tab.setControl((Control)label);
        this.job = new FATPJob(Messages.PropertiesHandler_GetFaultEntryInformation, FARL.get_info((URI)FARL.getFARLURI((String)this.getMessage()), (String)Preferences.getNL())){

            @Override
            protected void finalize_responses(IProgressMonitor _monitor) {
                for (FATP[] request_response : this.responses) {
                    if (FaultEntryPropertiesDialog.this.getShell() != null && FaultEntryPropertiesDialog.this.getShell().isDisposed()) {
                        this.cancel();
                    }
                    FaultEntryPropertiesDialog.this.handlePropertyResponse(_monitor, request_response, composite, tabFolder, info_tab, dup_tab);
                }
            }
        };
        this.job.schedule();
        return composite;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void okPressed() {
        ArrayList<FATP> requestList = new ArrayList<FATP>();
        try {
            String newLockFlagValue;
            String newUserTitleValue;
            URI faultEntryUri = new URI("fatp://" + this.faultEntry);
            String newUsernameValue = this.getModifiedFieldValue(Messages.PropertiesHandler_Username);
            if (newUsernameValue != null) {
                requestList.add(FARL.set_fault_entry_username((URI)faultEntryUri, (String)newUsernameValue.toUpperCase()));
            }
            if ((newUserTitleValue = this.getModifiedFieldValue(Messages.PropertiesHandler_UserTitle)) != null) {
                requestList.add(FARL.set_fault_entry_user_title((URI)faultEntryUri, (String)newUserTitleValue));
            }
            if ((newLockFlagValue = this.getModifiedFieldValue(Messages.PropertiesHandler_LockFlag)) != null) {
                requestList.add(FARL.set_fault_entry_lock_flag((URI)faultEntryUri, (String)newLockFlagValue));
            }
            if (requestList.size() > 0) {
                FaultEntryPropertiesDialog.saveFieldValues(requestList.toArray(new FATP[requestList.size()]));
            }
        }
        catch (URISyntaxException e) {
            logger.warn((Throwable)e);
        }
        super.okPressed();
    }

    public boolean close() {
        this.job.cancel();
        return super.close();
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonsBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)new GridData(0x1000008, 4, false, false));
        this.createButtonsForButtonBar(buttonsBar);
        return buttonsBar;
    }
}

