/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.PromptUserWithDialog;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.XMLUtils;
import com.ibm.pdtools.common.component.ui.dialog.PDPopupDialogWithTimeout;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class PreferencesAnalysis
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String DD_IDISYSDB = "IDISYSDB";
    private static final String DD_IDIPLIE = "IDILPLIE";
    private static final String DD_IDIPLI = "IDILPLI";
    private static final String DD_IDILANGX = "IDILANGX";
    private static final String DD_IDILCOBO = "IDILCOBO";
    private static final String DD_IDILCOB = "IDILCOB";
    private static final String DD_IDILC = "IDILC";
    private static final String DD_IDIADATA = "IDIADATA";
    private static final String DD_IDIOPTS = "IDIOPTS";
    private static final String PROPERTY_DDS_SET_TO_DEFAULT = "ddsSetToDefault";
    private static final String XML_ELEMENT_DDS = "dds";
    private static final String XML_ELEMENT_DD = "dd";
    private static final String XML_ELEMENT_DATASET = "dataset";
    private static final String XML_ATTRIBUTE_ENABLED = "enabled";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final PDLogger logger = PDLogger.get(PreferencesAnalysis.class);
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.preferences.analysis";
    public static final String IDI_DATASETS = "com.ibm.etools.fa.pdtclient.ui.preferences.analysis.datasets";
    private final Map<String, ListingConcatenation> dds = new LinkedHashMap<String, ListingConcatenation>();

    public PreferencesAnalysis() {
        Activator instance = Activator.getDefault();
        if (instance == null) {
            throw new IllegalStateException("Could not get the FA UI Plugin instance.");
        }
        this.setPreferenceStore(instance.getPreferenceStore());
        this.dds.put(DD_IDIOPTS, new ListingConcatenation(DD_IDIOPTS));
        this.dds.put(DD_IDIADATA, new ListingConcatenation(DD_IDIADATA));
        this.dds.put(DD_IDILC, new ListingConcatenation(DD_IDILC));
        this.dds.put(DD_IDILCOB, new ListingConcatenation(DD_IDILCOB));
        this.dds.put(DD_IDILCOBO, new ListingConcatenation(DD_IDILCOBO));
        this.dds.put(DD_IDILANGX, new ListingConcatenation(DD_IDILANGX));
        this.dds.put(DD_IDIPLI, new ListingConcatenation(DD_IDIPLI));
        this.dds.put(DD_IDIPLIE, new ListingConcatenation(DD_IDIPLIE));
        this.dds.put(DD_IDISYSDB, new ListingConcatenation(DD_IDISYSDB));
    }

    public void init(IWorkbench element) {
        this.loadModel();
    }

    private void loadModel() {
        String datasetsXML = this.getPreferenceStore().getString(IDI_DATASETS);
        if (datasetsXML.isEmpty()) {
            logger.info((Object)"Saved DDs configuration was empty.");
        } else {
            try {
                XMLMemento datasetsMemento = XMLMemento.createReadRoot((Reader)new StringReader(datasetsXML));
                logger.trace((Object)XMLUtils.prettyPrint((String)datasetsXML, (int)4, (boolean)true));
                IMemento[] iMementoArray = datasetsMemento.getChildren();
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento concat = iMementoArray[n2];
                    ListingConcatenation lc = this.dds.get(concat.getString(XML_ATTRIBUTE_NAME));
                    if (lc != null) {
                        lc.enabled = concat.getBoolean(XML_ATTRIBUTE_ENABLED);
                        IMemento[] iMementoArray2 = concat.getChildren(XML_ELEMENT_DATASET);
                        int n3 = iMementoArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento dsMemento = iMementoArray2[n4];
                            lc.datasets.add(new ListingDataset(lc, dsMemento.getString(XML_ATTRIBUTE_NAME), dsMemento.getBoolean(XML_ATTRIBUTE_ENABLED)));
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (WorkbenchException e) {
                logger.error((Object)"Failed to load saved datasets", (Throwable)e);
            }
        }
    }

    public String getAnalysisOptions() {
        this.loadModel();
        ListingConcatenation idiopts = this.dds.get(DD_IDIOPTS);
        StringBuilder opts = new StringBuilder();
        if (!idiopts.datasets.isEmpty()) {
            opts.append("IDIOPTS(").append(idiopts.datasets.get((int)0).name).append(") ");
        }
        opts.append("DATASETS( ");
        for (Map.Entry<String, ListingConcatenation> lc : this.dds.entrySet()) {
            if (lc.getKey().equals(DD_IDIOPTS) || lc.getValue().datasets.isEmpty()) continue;
            opts.append(lc.getValue().name).append("( ");
            for (ListingDataset dsn : lc.getValue().datasets) {
                if (!dsn.enabled) continue;
                opts.append(dsn.name);
            }
            opts.append(" ) ");
        }
        opts.append(" )");
        logger.info((Object)("Analysis options string: " + String.valueOf(opts)));
        return opts.toString();
    }

    private void saveModel() {
        XMLMemento root = XMLMemento.createWriteRoot((String)XML_ELEMENT_DDS);
        for (ListingConcatenation lc : this.dds.values()) {
            IMemento concatenation = root.createChild(XML_ELEMENT_DD);
            concatenation.putString(XML_ATTRIBUTE_NAME, lc.name);
            concatenation.putBoolean(XML_ATTRIBUTE_ENABLED, lc.enabled);
            for (ListingDataset ds : lc.datasets) {
                IMemento dsMemento = concatenation.createChild(XML_ELEMENT_DATASET);
                dsMemento.putString(XML_ATTRIBUTE_NAME, ds.name);
                dsMemento.putBoolean(XML_ATTRIBUTE_ENABLED, ds.enabled);
            }
        }
        String prettyPrint = XMLUtils.prettyPrint((String)root.toString(), (int)4, (boolean)true);
        this.getPreferenceStore().setValue(IDI_DATASETS, prettyPrint);
        logger.trace((Object)prettyPrint);
    }

    public boolean performOk() {
        this.saveModel();
        return super.performOk();
    }

    protected void performDefaults() {
        for (ListingConcatenation lc : this.dds.values()) {
            lc.datasets.clear();
        }
        this.getPreferenceStore().firePropertyChangeEvent(PROPERTY_DDS_SET_TO_DEFAULT, null, null);
        super.performDefaults();
    }

    protected Control createContents(Composite parent) {
        Group options = GUI.group((Composite)parent, (String)Messages.PreferencesAnalysis_FaultEntryRefreshOptions, (Layout)GridLayoutFactory.swtDefaults().numColumns(1).create(), (Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label label2 = new Label((Composite)options, 2112);
        label2.setText(Messages.PreferencesAnalysis_InfoAndUsage);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        final CheckboxTreeViewer treeViwer = new CheckboxTreeViewer((Composite)options, 268503812);
        treeViwer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        treeViwer.setUseHashlookup(true);
        treeViwer.setAutoExpandLevel(3);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (PreferencesAnalysis.PROPERTY_DDS_SET_TO_DEFAULT.equals(event.getProperty()) && !treeViwer.getTree().isDisposed()) {
                    treeViwer.refresh();
                }
            }
        });
        treeViwer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                Object firstElement;
                if (arg0.character == '\u007f' && !treeViwer.getStructuredSelection().isEmpty() && (firstElement = treeViwer.getStructuredSelection().getFirstElement()) instanceof ListingDataset && PDDialogs.openConfirmThreadSafe((String)Messages.PreferencesAnalysis_DeleteDataset, (String)MessageFormat.format(Messages.PreferencesAnalysis_ConfirmDelete, firstElement))) {
                    ListingDataset new_name = (ListingDataset)firstElement;
                    new_name.concatenation.remove((ListingDataset)firstElement);
                    treeViwer.refresh();
                }
            }
        });
        treeViwer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean isChecked = event.getChecked();
                Object element = event.getElement();
                if (element instanceof ListingConcatenation) {
                    ListingConcatenation lc = (ListingConcatenation)element;
                    lc.enabled = isChecked;
                    for (ListingDataset d2 : lc.datasets) {
                        d2.enabled = isChecked;
                    }
                    treeViwer.setChecked((Object)lc, true);
                } else if (element instanceof ListingDataset) {
                    ListingDataset dsn = (ListingDataset)element;
                    dsn.enabled = isChecked;
                    if (isChecked) {
                        dsn.concatenation.enabled = isChecked;
                    }
                    if (!isChecked) {
                        boolean anyEnabled = false;
                        for (ListingDataset sibling : dsn.concatenation.datasets) {
                            if (!sibling.enabled) continue;
                            anyEnabled = true;
                        }
                        if (!anyEnabled) {
                            dsn.concatenation.enabled = false;
                        }
                    }
                }
                treeViwer.refresh();
            }
        });
        treeViwer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object o) {
                if (o instanceof ListingConcatenation) {
                    ListingConcatenation lc = (ListingConcatenation)o;
                    boolean isPartiallyEnabled = false;
                    boolean isPartiallyDisabled = false;
                    for (ListingDataset d2 : lc.datasets) {
                        if (d2.enabled) {
                            isPartiallyEnabled = true;
                            continue;
                        }
                        isPartiallyDisabled = true;
                    }
                    return isPartiallyEnabled && isPartiallyDisabled;
                }
                return false;
            }

            public boolean isChecked(Object o) {
                if (o instanceof ListingConcatenation) {
                    ListingConcatenation lc = (ListingConcatenation)o;
                    return lc.enabled;
                }
                if (o instanceof ListingDataset) {
                    ListingDataset dsn = (ListingDataset)o;
                    return dsn.enabled;
                }
                return false;
            }
        });
        final MenuManager menuManager = new MenuManager();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager arg0) {
                if (treeViwer.getSelection().isEmpty()) {
                    return;
                }
                final Object firstElement = treeViwer.getStructuredSelection().getFirstElement();
                final ListingConcatenation concatenation = firstElement instanceof ListingConcatenation ? (ListingConcatenation)firstElement : ((ListingDataset)firstElement).getConcatenation();
                menuManager.add((IAction)new Action(Messages.PreferencesAnalysis_AddDataset){

                    public void run() {
                        boolean isIDIOPTs = false;
                        if (firstElement instanceof ListingConcatenation) {
                            ListingConcatenation lc = (ListingConcatenation)firstElement;
                            if (lc.name.equals(PreferencesAnalysis.DD_IDIOPTS)) {
                                isIDIOPTs = true;
                            }
                        }
                        String newDsn = null;
                        newDsn = isIDIOPTs ? PromptUserWithDialog.askingForDatasetName(MessageFormat.format(Messages.PreferencesAnalysis_SpecifyXDataset, concatenation.getName()), MessageFormat.format(Messages.PreferencesAnalysis_SpecifyXDataset, concatenation.getName()), Messages.PreferencesAnalysis_DSN, "com.ibm.etools.fa.pdtclient.ui.PreferencesAnalysis." + concatenation.getName(), concatenation.getName(), PromptUserWithDialog.DATASET_MEMBER_NAME_VALIDATOR) : PromptUserWithDialog.askingForDatasetName(MessageFormat.format(Messages.PreferencesAnalysis_AddDSToX, concatenation.getName()), MessageFormat.format(Messages.PreferencesAnalysis_AddDSToX, concatenation.getName()), Messages.PreferencesAnalysis_DSN, "com.ibm.etools.fa.pdtclient.ui.PreferencesAnalysis." + concatenation.getName(), concatenation.getName(), PromptUserWithDialog.DATASET_NAME_VALIDATOR);
                        if (newDsn != null) {
                            ListingDataset ds = new ListingDataset(concatenation, newDsn, true);
                            if (firstElement instanceof ListingDataset) {
                                concatenation.add(((ListingDataset)firstElement).getPositionInConcatenation(), ds);
                            } else {
                                concatenation.add(ds);
                            }
                            treeViwer.refresh();
                            treeViwer.reveal((Object)ds);
                        }
                    }

                    public boolean isEnabled() {
                        if (firstElement instanceof ListingConcatenation) {
                            ListingConcatenation lc = (ListingConcatenation)firstElement;
                            if (lc.name.equals(PreferencesAnalysis.DD_IDIOPTS) && !lc.datasets.isEmpty()) {
                                return false;
                            }
                        }
                        return true;
                    }
                });
                if (firstElement instanceof ListingConcatenation) {
                    menuManager.add((IAction)new Action(Messages.PreferencesAnalysis_RemoveAll){

                        public void run() {
                            if (PDDialogs.openConfirmThreadSafe((String)Messages.PreferencesAnalysis_Confirm, (String)MessageFormat.format(Messages.PreferencesAnalysis_PleaseConfirmRemoveAll, concatenation.getName()))) {
                                concatenation.removeAll();
                                treeViwer.refresh();
                            }
                        }

                        public boolean isEnabled() {
                            if (firstElement instanceof ListingConcatenation) {
                                ListingConcatenation lc = (ListingConcatenation)firstElement;
                                if (lc.datasets.isEmpty()) {
                                    return false;
                                }
                            }
                            return true;
                        }
                    });
                } else if (firstElement instanceof ListingDataset) {
                    menuManager.add((IAction)new Action(Messages.PreferencesAnalysis_Remove){

                        public void run() {
                            if (PDDialogs.openConfirmThreadSafe((String)Messages.PreferencesAnalysis_Confirm, (String)MessageFormat.format(Messages.PreferencesAnalysis_ConfirmDelete, firstElement))) {
                                concatenation.remove((ListingDataset)firstElement);
                                treeViwer.refresh();
                            }
                        }
                    });
                }
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        treeViwer.getTree().setMenu(menuManager.createContextMenu((Control)treeViwer.getTree()));
        treeViwer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof ListingConcatenation) {
                    ListingConcatenation lc = (ListingConcatenation)element;
                    return !lc.datasets.isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof ListingDataset) {
                    return ((ListingDataset)element).getConcatenation();
                }
                return null;
            }

            public Object[] getElements(Object element) {
                return ArrayContentProvider.getInstance().getElements(element);
            }

            public Object[] getChildren(Object element) {
                return element instanceof ListingConcatenation ? ((ListingConcatenation)element).getDatasets() : new ListingDataset[]{};
            }
        });
        treeViwer.setInput(this.dds.values());
        treeViwer.getTree().setHeaderVisible(true);
        treeViwer.getTree().setLinesVisible(true);
        treeViwer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedNode;
                treeViwer.setExpandedState(selectedNode, !treeViwer.getExpandedState(selectedNode = ((IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
        treeViwer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                Object[] objectArray = treeViwer.getStructuredSelection().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (!(item instanceof ListingDataset)) {
                        event.doit = false;
                        return;
                    }
                    if (item instanceof ListingDataset) {
                        ListingDataset ds = (ListingDataset)item;
                        if (ds.concatenation.name.equals(PreferencesAnalysis.DD_IDIOPTS)) {
                            event.doit = false;
                        }
                    }
                    ++n2;
                }
            }
        });
        treeViwer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)treeViwer){

            public void dragOver(DropTargetEvent event) {
                int location = this.determineLocation(event);
                switch (location) {
                    case 1: {
                        event.feedback = 2;
                        break;
                    }
                    case 2: {
                        event.feedback = 4;
                        break;
                    }
                }
                Object target = this.determineTarget(event);
                event.detail = target instanceof ListingDataset && location == 3 ? 0 : 2;
                if (target instanceof ListingConcatenation) {
                    ListingConcatenation lc = (ListingConcatenation)target;
                    if (lc.name.equals(PreferencesAnalysis.DD_IDIOPTS)) {
                        event.detail = 0;
                    }
                } else if (target instanceof ListingDataset) {
                    ListingDataset ds = (ListingDataset)target;
                    if (ds.concatenation.name.equals(PreferencesAnalysis.DD_IDIOPTS)) {
                        event.detail = 0;
                    }
                }
                super.dropAccept(event);
            }

            public void drop(DropTargetEvent event) {
                int location = this.determineLocation(event);
                Object target = this.determineTarget(event);
                ListingDataset dropped = (ListingDataset)treeViwer.getStructuredSelection().getFirstElement();
                if (target instanceof ListingConcatenation) {
                    logger.trace((Object)MessageFormat.format("dropped {0} on {1}", dropped, target));
                    dropped.getConcatenation().remove(dropped);
                    dropped.setConcatenation((ListingConcatenation)target);
                    ((ListingConcatenation)target).add(dropped);
                    treeViwer.refresh();
                } else if (target instanceof ListingDataset) {
                    ListingDataset targetDS = (ListingDataset)target;
                    ListingConcatenation oldConcatenation = dropped.getConcatenation();
                    ListingConcatenation newConcatenation = targetDS.getConcatenation();
                    switch (location) {
                        case 1: {
                            logger.trace((Object)MessageFormat.format("dropped {0} before target: {1}", dropped, targetDS));
                            oldConcatenation.remove(dropped);
                            dropped.setConcatenation(newConcatenation);
                            newConcatenation.add(targetDS.getPositionInConcatenation(), dropped);
                            break;
                        }
                        case 2: {
                            logger.trace((Object)MessageFormat.format("dropped {0} after target {1}", dropped, targetDS));
                            oldConcatenation.remove(dropped);
                            dropped.setConcatenation(newConcatenation);
                            newConcatenation.add(targetDS.getPositionInConcatenation() + 1, dropped);
                            break;
                        }
                        case 3: {
                            logger.trace((Object)MessageFormat.format("dropped {0} on to target {1}", dropped, targetDS));
                            oldConcatenation.remove(dropped);
                            dropped.setConcatenation(newConcatenation);
                            newConcatenation.add(targetDS.getPositionInConcatenation() + 1, dropped);
                            break;
                        }
                        default: {
                            logger.trace((Object)("dropped on target: " + String.valueOf(target)));
                        }
                    }
                }
                treeViwer.refresh();
                super.drop(event);
            }

            public boolean performDrop(Object data) {
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViwer);
        TreeViewerColumn mainColumn = new TreeViewerColumn((TreeViewer)treeViwer, 0);
        mainColumn.getColumn().setText(Messages.PreferencesAnalysis_Concatenation);
        mainColumn.getColumn().setWidth(300);
        mainColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ListingDataset) {
                    return ((ListingDataset)element).getName();
                }
                if (element instanceof ListingConcatenation) {
                    return ((ListingConcatenation)element).getName();
                }
                return Messages.PreferencesAnalysis_EmptyString;
            }

            public String getToolTipText(Object element) {
                if (element instanceof ListingDataset) {
                    ListingDataset ds = (ListingDataset)element;
                    if (ds.enabled) {
                        return MessageFormat.format(Messages.PreferencesAnalysis_tooltipDSEnabled, ds.name);
                    }
                    return MessageFormat.format(Messages.PreferencesAnalysis_tooltipDSDisabled, ds.name);
                }
                if (element instanceof ListingConcatenation) {
                    ListingConcatenation lc = (ListingConcatenation)element;
                    if (lc.datasets.isEmpty()) {
                        return MessageFormat.format(Messages.PreferencesAnalysis_tooltipEmptyConcatenation, lc.name);
                    }
                    if (lc.datasets.size() == 1) {
                        if (lc.enabled) {
                            return MessageFormat.format(Messages.PreferencesAnalysis_tooltipSingleDSIncConcatenationEnabled, lc.name, lc.datasets.get((int)0).name);
                        }
                        return MessageFormat.format(Messages.PreferencesAnalysis_tooltipSingleDSIncConcatenationDisabled, lc.name, lc.datasets.get((int)0).name);
                    }
                    if (lc.enabled) {
                        return MessageFormat.format(Messages.PreferencesAnalysis_tooltipMultipleDSEnabled, lc.name);
                    }
                    return MessageFormat.format(Messages.PreferencesAnalysis_tooltipMultipleDatasetsDisabled, lc.name);
                }
                return null;
            }
        });
        mainColumn.setEditingSupport((EditingSupport)new DSNEditingSupport((TreeViewer)treeViwer));
        TreeViewerEditor.create((TreeViewer)treeViwer, (SWTFocusCellManager)new TreeViewerFocusCellManager((TreeViewer)treeViwer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)treeViwer)), (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)treeViwer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                if (event.eventType == 3) {
                    EventObject source = event.sourceEvent;
                    return !(source instanceof MouseEvent) || ((MouseEvent)source).button != 3;
                }
                return false;
            }
        }, (int)58);
        treeViwer.refresh();
        treeViwer.getTree().setFocus();
        return parent;
    }

    private static class DSNEditingSupport
    extends EditingSupport {
        private TreeViewer viewer;
        private TextCellEditor editor;

        public DSNEditingSupport(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.editor = new TextCellEditor((Composite)this.viewer.getTree());
            this.editor.addListener(new ICellEditorListener(){
                PDPopupDialogWithTimeout popup = null;

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (this.popup != null) {
                        this.popup.close();
                        this.popup = null;
                    }
                    if (!newValidState) {
                        this.popup = new PDPopupDialogWithTimeout(viewer.getTree().getParent().getShell(), 540676, Messages.PreferencesAnalysis_DSNameError, editor.getErrorMessage(), 1000, null);
                        this.popup.open();
                    }
                }

                public void cancelEditor() {
                    if (this.popup != null) {
                        this.popup.close();
                        this.popup = null;
                    }
                }

                public void applyEditorValue() {
                    if (this.popup != null) {
                        this.popup.close();
                        this.popup = null;
                    }
                }
            });
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof ListingDataset) {
                ListingDataset ds = (ListingDataset)element;
                if (ds.concatenation.name.equals(PreferencesAnalysis.DD_IDIOPTS)) {
                    this.editor.setValidator(new ICellEditorValidator(){

                        public String isValid(Object o) {
                            if (Validator.validateDataSetName((String)((String)o))) {
                                return null;
                            }
                            return Messages.PreferencesAnalysis_PleaseSpecifyIDIOPTSDSMember;
                        }
                    });
                } else {
                    this.editor.setValidator(new ICellEditorValidator(){

                        public String isValid(Object o) {
                            if (Validator.validateDataSetName((String)((String)o))) {
                                return null;
                            }
                            return Messages.PreferencesAnalysis_PleaseSpecifyDSN;
                        }
                    });
                }
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof ListingDataset;
        }

        protected Object getValue(Object element) {
            return ((ListingDataset)element).getName().toUpperCase();
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof ListingDataset && value != null) {
                ListingDataset ds = (ListingDataset)element;
                ds.setName(((String)value).toUpperCase());
                this.viewer.update(element, null);
                this.viewer.refresh();
            }
        }
    }

    private static class ListingConcatenation {
        private String name;
        private List<ListingDataset> datasets = new ArrayList<ListingDataset>();
        private boolean enabled = true;

        public int hashCode() {
            return Objects.hash(this.enabled, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListingConcatenation other = (ListingConcatenation)obj;
            return this.enabled == other.enabled && Objects.equals(this.name, other.name);
        }

        public ListingConcatenation(String name) {
            this.name = Objects.requireNonNull(name, "Must specify a non-null listing concatenation name.");
        }

        public void add(ListingDataset dsn) {
            if (!this.datasets.contains(dsn)) {
                this.datasets.add(dsn);
            }
        }

        public void add(int index, ListingDataset ds) {
            this.datasets.add(index, ds);
        }

        public void remove(ListingDataset dataset) {
            this.datasets.remove(dataset);
        }

        public void removeAll() {
            this.datasets.clear();
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getIndexOf(ListingDataset dsn) {
            return this.datasets.indexOf(dsn);
        }

        public ListingDataset[] getDatasets() {
            return this.datasets.toArray(new ListingDataset[0]);
        }
    }

    private static class ListingDataset {
        private ListingConcatenation concatenation;
        private String name;
        private boolean enabled;

        public ListingDataset(ListingConcatenation concatenationName, String name, boolean enabled) {
            this.concatenation = Objects.requireNonNull(concatenationName, "Must specify a non-null parent concatenation");
            this.name = Objects.requireNonNull(name, "Must specify a dataset name.").toUpperCase();
            this.enabled = enabled;
        }

        public String toString() {
            return MessageFormat.format("{0} ", this.name);
        }

        public ListingConcatenation getConcatenation() {
            return this.concatenation;
        }

        public void setConcatenation(ListingConcatenation concatenation) {
            this.concatenation = Objects.requireNonNull(concatenation, "Must provide a non-null concatenation");
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            this.name = Objects.requireNonNull(newName, "Must provide a non-null new Name.").toUpperCase();
        }

        public int getPositionInConcatenation() {
            return this.concatenation.getIndexOf(this);
        }

        public int hashCode() {
            return Objects.hash(this.concatenation, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListingDataset other = (ListingDataset)obj;
            return Objects.equals(this.concatenation, other.concatenation) && Objects.equals(this.name, other.name);
        }
    }
}

