/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.CodePagePropertyChangeListener;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.AutomaticReportsListRefreshJob;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.preferences";
    public static final String TRACE_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.trace";
    public static final String NL_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.nl";
    public static final String BOOKMARK_USERNOTE_COLOR_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.bookmark.colour";
    public static final String TASK_USERNOTE_COLOR_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.task.colour";
    public static final String HOST_USERNOTE_COLOR_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.host.colour";
    public static final String BOOKMARK_USERNOTE_TEXT_COLOR_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.bookmark.colour.text";
    public static final String TASK_USERNOTE_TEXT_COLOR_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.task.colour.text";
    public static final String HOST_USERNOTE_TEXT_COLOR_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.host.colour.text";
    public static final String DELETED_FAULT_ENTRY_COLOR_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.reportslist.deleted.fault.entry.colour";
    public static final String TIMEOUT_VALUE_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.timeout";
    public static final String MINIDUMP_QUEUE_THRESHOLD_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.minidump.queue.threshold";
    public static final String CONFIRM_DELETE_FAULT_ENTRY_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.confirm.delete.fault.entry";
    public static final String AUTOMATIC_REPORTSLIST_REFRESH_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.reportslist.refresh.auto";
    public static final String AUTOMATIC_REPORTSLIST_REFRESH_INTERVAL_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.reportslist.refresh.auto.interval";
    public static final String AUTO_REFRESH_NOTE = "com.ibm.etools.fa.pdtclient.ui.preferences.reportslist.refresh.note";
    public static final String CODEPAGE_FROM_HOST_PREF = "com.ibm.etools.fa.pdtclient.ui.preferences.use.host.codepage";
    private IPropertyChangeListener propertyChangeListener;
    private CodePagePropertyChangeListener nlChangeListener;
    private Control codePageControl;

    public Preferences() {
        super(1);
        this.setPreferenceStore(Preferences.staticGetPreferenceStore());
        this.propertyChangeListener = Preferences.getNewPropertyChangeListener();
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.nlChangeListener != null) {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.nlChangeListener);
        }
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.codePageControl.setEnabled(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getNewValue().equals("en")) {
            this.codePageControl.setEnabled(true);
        } else if (event.getNewValue().equals("ja")) {
            this.codePageControl.setEnabled(false);
        }
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Composite settings = new Composite(parent, 0);
        settings.setLayout((Layout)new GridLayout(1, false));
        settings.setLayoutData((Object)new GridData(1808));
        this.addField((FieldEditor)new IntegerFieldEditor(TIMEOUT_VALUE_PREF, Messages.Preferences_Connection_timeout, settings));
        this.addField((FieldEditor)new IntegerFieldEditor(MINIDUMP_QUEUE_THRESHOLD_PREF, Messages.Preferences_QueueMinidumpSizeThreshold, settings));
        BooleanFieldEditor traceOn = new BooleanFieldEditor(TRACE_PREF, Messages.Preferences_EnableZZDebug, settings);
        Control traceControl = traceOn.getDescriptionControl(settings);
        traceControl.setToolTipText(Messages.Preferences_ZZDebugTooltip);
        this.addField((FieldEditor)traceOn);
        this.addField((FieldEditor)new RadioGroupFieldEditor(NL_PREF, Messages.Preferences_Language, 1, (String[][])new String[][]{{Messages.Preferences_Language_English, "en"}, {Messages.Preferences_Language_Japanese, "ja"}}, settings));
        BooleanFieldEditor codePage = new BooleanFieldEditor(CODEPAGE_FROM_HOST_PREF, Messages.Preferences_0, settings);
        this.codePageControl = codePage.getDescriptionControl(settings);
        this.codePageControl.setToolTipText(Messages.Preferences_1);
        this.nlChangeListener = new CodePagePropertyChangeListener(this.codePageControl);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.nlChangeListener);
        this.nlChangeListener.updateButtonEnablement(Preferences.getNL().equals("en"));
        this.addField((FieldEditor)codePage);
        this.addColourSettingGroups(settings);
        this.addField((FieldEditor)new BooleanFieldEditor(CONFIRM_DELETE_FAULT_ENTRY_PREF, Messages.Preferences_Confirm_Delete_Fault_Entry, settings));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOMATIC_REPORTSLIST_REFRESH_PREF, Messages.Preferences_Refresh_reportslist_automatically, settings));
        IntegerFieldEditor refreshIntervalField = new IntegerFieldEditor(AUTOMATIC_REPORTSLIST_REFRESH_INTERVAL_PREF, Messages.Preferences_Refresh_interval, settings);
        refreshIntervalField.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)refreshIntervalField);
        Composite executeRefreshOptComp = new Composite(settings, 0);
        executeRefreshOptComp.setLayout((Layout)new GridLayout(1, false));
        executeRefreshOptComp.setLayoutData((Object)new GridData(1808));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTO_REFRESH_NOTE, Messages.Preferences_Execute_Refresh, executeRefreshOptComp));
    }

    private static IPropertyChangeListener getNewPropertyChangeListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == Preferences.AUTOMATIC_REPORTSLIST_REFRESH_PREF || event.getProperty() == Preferences.AUTOMATIC_REPORTSLIST_REFRESH_INTERVAL_PREF) {
                    AutomaticReportsListRefreshJob.update();
                } else if (event.getProperty().equals(Preferences.CODEPAGE_FROM_HOST_PREF)) {
                    FaultAnalyzerReportEditor.reopenAllFaultAnalyzerReportEditorsOnActivePages();
                }
            }
        };
    }

    private void addColourSettingGroups(Composite parent) {
        Composite usernoteGroup = new Composite(parent, 0);
        usernoteGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addField((FieldEditor)new ColorFieldEditor(BOOKMARK_USERNOTE_COLOR_PREF, Messages.Preferences_BookmarkUsernoteColour, usernoteGroup));
        this.addField((FieldEditor)new ColorFieldEditor(TASK_USERNOTE_COLOR_PREF, Messages.Preferences_TaskUsernoteColour, usernoteGroup));
        this.addField((FieldEditor)new ColorFieldEditor(HOST_USERNOTE_COLOR_PREF, Messages.Preferences_HostUsernoteColour, usernoteGroup));
        this.addField((FieldEditor)new ColorFieldEditor(DELETED_FAULT_ENTRY_COLOR_PREF, Messages.Preferences_DeletedFaultEntryHighlightColour, usernoteGroup));
        Composite usernoteTextGroup = new Composite(parent, 0);
        usernoteTextGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addField((FieldEditor)new ColorFieldEditor(BOOKMARK_USERNOTE_TEXT_COLOR_PREF, Messages.Preferences_BookmarkTextColour, usernoteTextGroup));
        this.addField((FieldEditor)new ColorFieldEditor(TASK_USERNOTE_TEXT_COLOR_PREF, Messages.Preferences_TaskTextColour, usernoteTextGroup));
        this.addField((FieldEditor)new ColorFieldEditor(HOST_USERNOTE_TEXT_COLOR_PREF, Messages.Preferences_HostTextColour, usernoteTextGroup));
    }

    private static IPreferenceStore staticGetPreferenceStore() {
        Activator instance = Activator.getDefault();
        if (instance == null) {
            throw new IllegalStateException("Could not get the FA UI Plugin instance.");
        }
        return instance.getPreferenceStore();
    }

    public static boolean isTraceEnabled() {
        return Preferences.staticGetPreferenceStore().getBoolean(TRACE_PREF);
    }

    public static boolean isUseCodePageFromHostEnabled() {
        return Preferences.staticGetPreferenceStore().getBoolean(CODEPAGE_FROM_HOST_PREF);
    }

    public static String getNL() {
        String string = Preferences.staticGetPreferenceStore().getString(NL_PREF);
        int maxLen = 2;
        if (string.length() < maxLen) {
            maxLen = string.length();
        }
        return string.substring(0, maxLen);
    }

    private static Color getColor(String preferenceId) {
        return new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)Preferences.staticGetPreferenceStore(), (String)preferenceId));
    }

    public static Color getBookmarkUsernoteColor() {
        return Preferences.getColor(BOOKMARK_USERNOTE_COLOR_PREF);
    }

    public static Color getTaskUsernoteColor() {
        return Preferences.getColor(TASK_USERNOTE_COLOR_PREF);
    }

    public static Color getHostUsernoteColor() {
        return Preferences.getColor(HOST_USERNOTE_COLOR_PREF);
    }

    public static Color getBookmarkUsernoteTextColor() {
        return Preferences.getColor(BOOKMARK_USERNOTE_TEXT_COLOR_PREF);
    }

    public static Color getTaskUsernoteTextColor() {
        return Preferences.getColor(TASK_USERNOTE_TEXT_COLOR_PREF);
    }

    public static Color getHostUsernoteTextColor() {
        return Preferences.getColor(HOST_USERNOTE_TEXT_COLOR_PREF);
    }

    public static Color getDeletedFaultEntryHighlightColor() {
        return Preferences.getColor(DELETED_FAULT_ENTRY_COLOR_PREF);
    }

    public static int getTimeout() {
        return Preferences.staticGetPreferenceStore().getInt(TIMEOUT_VALUE_PREF);
    }

    public static int getMinidumpQueueThreshold() {
        return Preferences.staticGetPreferenceStore().getInt(MINIDUMP_QUEUE_THRESHOLD_PREF);
    }

    public static boolean isConfirmDeleteEnabled() {
        return Preferences.staticGetPreferenceStore().getBoolean(CONFIRM_DELETE_FAULT_ENTRY_PREF);
    }

    public static boolean isAutomaticReportsListRefreshEnabled() {
        return Preferences.staticGetPreferenceStore().getBoolean(AUTOMATIC_REPORTSLIST_REFRESH_PREF);
    }

    public static int getAutomaticReportsListRefreshInterval() {
        return Preferences.staticGetPreferenceStore().getInt(AUTOMATIC_REPORTSLIST_REFRESH_INTERVAL_PREF);
    }

    public static boolean isExecuteRefreshOnOpenHistoryFile() {
        return Preferences.staticGetPreferenceStore().getBoolean(AUTO_REFRESH_NOTE);
    }
}

