/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui;

import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader.FATPQueries;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FAVersionHolder {
    private static final PDLogger logger = PDLogger.get(FAVersionHolder.class);
    private static FAVersionHolder instance = new FAVersionHolder();
    private Map<String, Version> map = new HashMap<String, Version>();

    private FAVersionHolder() {
    }

    public static FAVersionHolder getInstance() {
        return instance;
    }

    public String getVersionDetails(IPDHost ipdHost) {
        Version version = this.lazyGetVersion(ipdHost.getHostID());
        return version == null ? null : version.details;
    }

    public int getVersion(IPDHost ipdHost) {
        Version version = this.lazyGetVersion(ipdHost.getHostID());
        return version == null ? 0 : version.version;
    }

    public int getVersion(String hostId) {
        Version version = this.lazyGetVersion(hostId);
        return version == null ? 0 : version.version;
    }

    private Version lazyGetVersion(String hostId) {
        if (this.map.containsKey(hostId)) {
            return this.map.get(hostId);
        }
        HostDetails hostDetails = ConnectionUtilities.getHostDetails((String)hostId);
        if (hostDetails != null) {
            Version version = FATPQueries.getVersionFromHost(hostDetails.getHostname(), hostDetails.getPortNumber(), (IProgressMonitor)new NullProgressMonitor());
            if (version != null) {
                version = FATPQueries.getVersionFromHost(hostDetails.getHostname(), hostDetails.getPortNumber(), (IProgressMonitor)new NullProgressMonitor());
            }
            if (version != null) {
                logger.info((Object)String.format("FA Host version retrieved for %s:%d [%d]", hostDetails.getHostname(), hostDetails.getPortNumber(), version.getVersion()));
                this.map.put(hostId, version);
            } else {
                logger.debug((Object)String.format("FA Host version could not be retrieved for %s:%d", hostDetails.getHostname(), hostDetails.getPortNumber()));
            }
            return version;
        }
        return null;
    }

    public static class Version {
        private String details;
        private int version;

        public Version(int version, String details) {
            this.version = version;
            this.details = details;
        }

        public String getDetails() {
            return this.details;
        }

        public int getVersion() {
            return this.version;
        }

        public int hashCode() {
            return Objects.hash(this.details, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            return Objects.equals(this.details, other.details) && this.version == other.version;
        }
    }
}

