/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATPCleanupTracker;
import com.ibm.etools.fa.pdtclient.ui.impl.system.AddSystem;
import com.ibm.etools.fa.pdtclient.ui.impl.system.NameSystem;
import com.ibm.etools.fa.pdtclient.ui.impl.system.RemoveSystem;
import com.ibm.etools.fa.pdtclient.ui.usermessages.UserMessageManager;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionChangeListener;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PLUGIN_ID = "com.ibm.etools.fa.pdtclient.ui";
    private static Activator plugin;
    private static final PDLogger logger;

    static {
        logger = PDLogger.get(Activator.class);
    }

    public static void cache(String key, String value) {
        if (key == null || key.trim().isEmpty() || value == null || value.trim().isEmpty()) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        String[] array = Activator.get_cache().getArray(key);
        if (array != null) {
            values.addAll(Arrays.asList(array));
        }
        if (values.contains(value)) {
            values.remove(value);
        }
        values.add(0, value);
        Activator.get_cache().put(key, values.toArray(new String[values.size()]));
        if (plugin != null) {
            plugin.saveDialogSettings();
        }
    }

    public static List<String> retrieve(String _key) {
        String[] array = Activator.get_cache().getArray(_key);
        if (array != null) {
            return new ArrayList<String>(Arrays.asList(array));
        }
        return Collections.EMPTY_LIST;
    }

    public static void removeValue(String _key, String value) {
        String[] array = Activator.get_cache().getArray(_key);
        ArrayList<String> newItems = new ArrayList<String>();
        newItems.addAll(Arrays.asList(array));
        newItems.remove(value);
        Activator.get_cache().put(_key, newItems.toArray(new String[newItems.size()]));
    }

    private static IDialogSettings get_cache() {
        return Activator.getDefault().getDialogSettings();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        Objects.requireNonNull(path, "Must provide a non-null path.");
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void updateAll(SystemsTreeNode targetNode) {
        ReportsList reportList = ReportsList.getIfOpen();
        if (reportList != null) {
            reportList.refresh();
        }
        if (targetNode != null) {
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)targetNode);
        }
    }

    public static <T extends SystemsTreeNode> void updateAll(Class<T> clazz) {
        Objects.requireNonNull(clazz, "Must provide non-null class");
        ReportsList reportList = ReportsList.getIfOpen();
        if (reportList != null) {
            reportList.refresh();
        }
        for (SystemsTreeNode node : PDTreeContentHolder.getInstance().getNodesOfType(clazz)) {
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)node);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ConnectionUtilities.addPDConnectionChangeListener((IPDToolsConnectionChangeListener)new IPDToolsConnectionChangeListener(){

            public void deletedConnection(String hostID) {
            }

            public void newConnection(HostDetails newHostDetails) {
            }

            public void updatedConnection(final HostDetails oldHostDetails, final HostDetails updatedHostDetails) {
                final IFolder old_server_local = FAResourceUtils.getSystemFolder((String)oldHostDetails.getHostname(), (String)String.valueOf(oldHostDetails.getPortNumber()));
                if (old_server_local.exists()) {
                    if (oldHostDetails.getHostname().equals(updatedHostDetails.getHostname()) && oldHostDetails.getPortNumber() == updatedHostDetails.getPortNumber()) {
                        if (!oldHostDetails.getDescription().equals(updatedHostDetails.getDescription())) {
                            NameSystem.nameSystem(updatedHostDetails.getHostname(), String.valueOf(updatedHostDetails.getPortNumber()), String.valueOf(updatedHostDetails.getDescription()));
                        }
                        return;
                    }
                    logger.debug((Object)("Changing connection from " + String.valueOf(oldHostDetails) + " to " + String.valueOf(updatedHostDetails)));
                    Job.createSystem((String)Messages.FAHost_Removing, (ICoreRunnable)new ICoreRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            AddSystem.addSystem(updatedHostDetails.getHostname(), String.valueOf(updatedHostDetails.getPortNumber()));
                            IFolder new_server_local = FAResourceUtils.getSystemFolder((String)updatedHostDetails.getHostname(), (String)Integer.toString(updatedHostDetails.getPortNumber()));
                            for (IResource member : IResourceUtils.ls((IFolder)old_server_local, (IProgressMonitor)monitor, (boolean)false)) {
                                try {
                                    member.move(new_server_local.getFullPath().append(member.getProjectRelativePath().removeFirstSegments(2)), true, monitor);
                                }
                                catch (CoreException e) {
                                    logger.warn((Object)e.getMessage());
                                }
                            }
                            RemoveSystem.remove(oldHostDetails.getHostname(), String.valueOf(oldHostDetails.getPortNumber()), monitor);
                            ReportsList reportList = ReportsList.getIfOpen();
                            if (reportList != null) {
                                reportList.refresh();
                            }
                        }
                    }).schedule();
                }
            }
        });
        UserMessageManager.getInstance().startup();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            FATPCleanupTracker.cleanup();
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }
}

