/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.bidi.ui;

import java.util.ResourceBundle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SegmentEvent;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class VisualField {
    private static final char LRO = '\u202d';
    private static final char RLO = '\u202e';
    private static final char PDF = '\u202c';
    private static final String eolStr = "\r\n";
    private static final String BUNDLE_NAME = "com.ibm.pdtools.common.component.bidi.ui.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.pdtools.common.component.bidi.ui.messages");
    private Listener listener;
    private Text myField;
    private boolean isPushMode;
    private boolean isWidgetReversed;
    private boolean isAutoPush;
    private int indxPushSegmentStart = -1;
    private int lengthPushSegment = 0;
    private MenuItem rtlMenuItem;
    private MenuItem autopushMenuItem;
    private int prevLength = 0;

    public VisualField(Text field) {
        this.myField = field;
        if (Util.isWindows()) {
            this.addListeners();
            this.myField.setMenu(this.createContextMenu());
            Display display = Display.getCurrent();
            this.myField.setBackground(display.getSystemColor(2));
            this.myField.setForeground(display.getSystemColor(5));
        }
    }

    private void addListeners() {
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        VisualField.this.handleMouseDown();
                        break;
                    }
                    case 1: {
                        VisualField.this.handleKeyDown(event);
                    }
                }
            }
        };
        this.myField.addListener(1, this.listener);
        this.myField.addListener(3, this.listener);
        this.myField.addListener(22, this.listener);
        this.myField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 117 && (keyEvent.stateMask & 0x40000) != 0) {
                    VisualField.this.setPush(true);
                    keyEvent.doit = false;
                } else if (keyEvent.keyCode == 111 && (keyEvent.stateMask & 0x40000) != 0) {
                    VisualField.this.setPush(false);
                    keyEvent.doit = false;
                } else if (keyEvent.keyCode == 116 && (keyEvent.stateMask & 0x40000) != 0) {
                    VisualField.this.switchAutoPush();
                    keyEvent.doit = false;
                } else if (VisualField.this.isPushMode && (keyEvent.keyCode == 0x1000007 || keyEvent.keyCode == 0x1000008)) {
                    int carPos = VisualField.this.getCaretOffset();
                    VisualField.this.setPush(false);
                    VisualField.this.setCaretOffset(carPos);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private Menu createContextMenu() {
        Menu menu = this.myField.getMenu() == null ? new Menu((Control)this.myField) : this.myField.getMenu();
        MenuItem copy = new MenuItem(menu, 64);
        copy.setText(RESOURCE_BUNDLE.getString("VisualField.Copy"));
        copy.setAccelerator(262243);
        copy.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VisualField.this.copy();
                e.doit = false;
            }
        });
        MenuItem cut = new MenuItem(menu, 64);
        cut.setText(RESOURCE_BUNDLE.getString("VisualField.Cut"));
        cut.setAccelerator(262264);
        cut.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VisualField.this.cut();
                e.doit = false;
            }
        });
        MenuItem paste = new MenuItem(menu, 64);
        paste.setText(RESOURCE_BUNDLE.getString("VisualField.Paste"));
        paste.setAccelerator(262262);
        paste.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VisualField.this.paste();
                e.doit = false;
            }
        });
        this.rtlMenuItem = new MenuItem(menu, 32);
        this.rtlMenuItem.setText(RESOURCE_BUNDLE.getString("VisualField.RTLOrder"));
        this.rtlMenuItem.setAccelerator(393216);
        this.rtlMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                e = this.createEventForSwithchDir(e);
                VisualField.this.handleKeyDown(e);
                VisualField.this.rtlMenuItem.setSelection(VisualField.this.isWidgetReversed);
            }

            private Event createEventForSwithchDir(Event e) {
                e.widget = VisualField.this.myField;
                e.keyCode = 131072;
                e.keyLocation = VisualField.this.isWidgetReversed ? 16384 : 131072;
                e.stateMask = 262144;
                return e;
            }
        });
        new MenuItem(menu, 2);
        this.autopushMenuItem = new MenuItem(menu, 32);
        this.autopushMenuItem.setText(RESOURCE_BUNDLE.getString("VisualField.AutoPush"));
        this.autopushMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VisualField.this.switchAutoPush();
            }
        });
        MenuItem pushon = new MenuItem(menu, 64);
        pushon.setText(RESOURCE_BUNDLE.getString("VisualField.PushOn"));
        pushon.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VisualField.this.setPush(true);
            }
        });
        MenuItem pushoff = new MenuItem(menu, 64);
        pushoff.setText(RESOURCE_BUNDLE.getString("VisualField.PushOff"));
        pushoff.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VisualField.this.setPush(false);
            }
        });
        return menu;
    }

    private void copy() {
        this.myField.copy();
    }

    private void cut() {
        this.myField.cut();
    }

    private void paste() {
        this.myField.paste();
    }

    private void handleMouseDown() {
        if (this.isPushMode && !this.isCaretInsidePushSegment()) {
            int caretPos = this.getCaretOffset();
            this.setPush(false);
            this.setCaretOffset(this.getUpdatedCaret(caretPos));
        }
    }

    private void handleKeyDown(Event event) {
        if (event.keyCode == 0x1000004 && this.isPushMode) {
            if (!this.isWidgetReversed && this.isCursorAtStartPushSegment()) {
                this.setPush(false);
            } else if (this.isWidgetReversed && this.isCursorAtEndPushSegment()) {
                int newCaretPos = this.indxPushSegmentStart;
                this.setPush(false);
                this.setCaretOffset(newCaretPos);
            }
        } else if (event.keyCode == 0x1000003 && this.isPushMode) {
            if (!this.isWidgetReversed && this.isCursorAtEndPushSegment()) {
                int newCaretPos = this.indxPushSegmentStart;
                this.setPush(false);
                this.setCaretOffset(newCaretPos);
            } else if (this.isWidgetReversed && this.isCursorAtStartPushSegment()) {
                this.setPush(false);
            }
        } else if (this.isPushMode && (event.keyCode == 0x1000007 || event.keyCode == 0x1000008)) {
            this.setPush(false);
        } else if (event.keyCode == 127 && this.isPushMode) {
            if (!this.isCursorAtEndPushSegment()) {
                --this.lengthPushSegment;
            }
        } else if (event.keyCode == 8 && this.isPushMode) {
            if (!this.isCursorAtStartPushSegment()) {
                --this.lengthPushSegment;
            } else {
                this.setPush(false);
            }
        } else if ((event.stateMask & SWT.MODIFIER_MASK) == 262144 && event.keyCode == 131072) {
            if (!this.isWidgetReversed && event.keyLocation == 131072 || this.isWidgetReversed && event.keyLocation == 16384) {
                this.switchWidgetDir(false);
            }
        } else if (this.isPushMode && event.character == '\r') {
            this.setPush(false);
        } else if (this.isAutoPush && event.character >= ' ' && event.character != '\u007f') {
            this.handleAutoPush();
        }
    }

    private boolean isCursorAtStartPushSegment() {
        int mirroredBoundPosition;
        int caretOffset = this.getCaretOffset();
        if (this.isCaretAtTheLastLine()) {
            --caretOffset;
        }
        return (mirroredBoundPosition = this.calculateMirroredPushSegmentStart()) == caretOffset - 1;
    }

    private boolean isCursorAtEndPushSegment() {
        int mirroredBoundPosition;
        int caretOffset = this.getCaretOffset();
        if (this.isCaretAtTheLastLine()) {
            --caretOffset;
        }
        return (mirroredBoundPosition = this.calculateMirroredPushSegmentEnd()) == caretOffset;
    }

    private int calculateMirroredCaretPosition(int caretPos) {
        LineIndx lineIndx = new LineIndx(this.myField.getText(), this.getCaretOffset());
        return lineIndx.getEndIndx() - (caretPos - lineIndx.getStartIndx());
    }

    private int calculateMirroredPushSegmentEnd() {
        return this.calculateMirroredCaretPosition(this.indxPushSegmentStart);
    }

    private int calculateMirroredPushSegmentStart() {
        return this.calculateMirroredPushSegmentEnd() - this.lengthPushSegment;
    }

    private boolean isCaretAtTheLastLine() {
        LineIndx lineIndx = new LineIndx(this.myField.getText(), this.getCaretOffset());
        return lineIndx.getEndIndx() == this.myField.getText().length() - 1;
    }

    private boolean isCaretInsidePushSegment() {
        int mirroredPushSegmentEnd = this.calculateMirroredPushSegmentEnd();
        int mirroredPushSegmentStart = this.calculateMirroredPushSegmentStart();
        int caretPos = this.getCaretOffset();
        return caretPos >= mirroredPushSegmentStart && caretPos <= mirroredPushSegmentEnd;
    }

    private void switchAutoPush() {
        this.isAutoPush = !this.isAutoPush;
        this.autopushMenuItem.setSelection(this.isAutoPush);
    }

    public void switchWidgetDir(boolean forceSringReverse) {
        this.isWidgetReversed = !this.isWidgetReversed;
        int carPos = this.getCaretOffset();
        if (forceSringReverse) {
            this.myField.setText(VisualField.reverseStr(this.myField.getText()));
        } else {
            this.myField.setText(this.myField.getText());
        }
        this.setCaretOffset(carPos);
        if (this.rtlMenuItem != null) {
            this.rtlMenuItem.setSelection(this.isWidgetReversed);
        }
        if (this.isPushMode) {
            this.setPush(false);
        }
        if (this.isWidgetReversed) {
            this.setBidiKeyboardLanguage();
            this.myField.setOrientation(0x4000000);
        } else {
            this.setNonBidiKeyboardLanguage();
            this.myField.setOrientation(0x2000000);
        }
    }

    public boolean isWidgetReversed() {
        return this.isWidgetReversed;
    }

    public boolean isPushMode() {
        return this.isPushMode;
    }

    private void setPush(boolean pushOn) {
        if (this.isPushMode == pushOn) {
            return;
        }
        this.isPushMode = pushOn;
        if (pushOn) {
            this.startPushMode();
        } else {
            this.endPushMode();
            this.indxPushSegmentStart = -1;
            this.lengthPushSegment = 0;
        }
    }

    private void endPushMode() {
        this.myField.setText(VisualField.reverseStr(this.myField.getText()));
        this.setCaretOffset(this.indxPushSegmentStart + this.lengthPushSegment);
        if (!this.isWidgetReversed) {
            this.setNonBidiKeyboardLanguage();
        } else {
            this.setBidiKeyboardLanguage();
        }
    }

    public static String reverseStr(String str) {
        StringBuffer sb;
        Object resultStr = "";
        String orgStr = new String(str);
        int i = -1;
        while ((i = orgStr.indexOf(eolStr)) != -1) {
            sb = new StringBuffer(orgStr.substring(0, i));
            resultStr = (String)resultStr + String.valueOf(sb.reverse()) + eolStr;
            orgStr = orgStr.substring(i + eolStr.length());
        }
        if (orgStr.length() > 0) {
            sb = new StringBuffer(orgStr);
            resultStr = (String)resultStr + String.valueOf(sb.reverse());
        }
        return resultStr;
    }

    private void addBidiSegmentListener() {
        this.myField.addSegmentListener(new SegmentListener(){

            public void getSegments(SegmentEvent event) {
                int length = event.lineText.length();
                if (VisualField.this.isPushMode && !VisualField.this.isWidgetReversed || !VisualField.this.isPushMode && VisualField.this.isWidgetReversed) {
                    event.segments = new int[1];
                    event.segmentsChars = new char[]{'\u202e'};
                } else {
                    int[] nArray = new int[2];
                    nArray[1] = length;
                    event.segments = nArray;
                    event.segmentsChars = new char[]{'\u202d', '\u202c'};
                }
                if (VisualField.this.isPushMode && VisualField.this.indxPushSegmentStart != -1 && VisualField.this.prevLength < length) {
                    ++VisualField.this.lengthPushSegment;
                }
                VisualField.this.prevLength = length;
            }
        });
    }

    private void startPushMode() {
        int carOffset = this.getCaretOffset();
        String str = VisualField.reverseStr(this.myField.getText());
        this.myField.setText(str);
        this.indxPushSegmentStart = carOffset;
        this.setCaretOffset(this.getUpdatedCaret(carOffset));
        if (!this.isWidgetReversed) {
            this.setBidiKeyboardLanguage();
        } else {
            this.setNonBidiKeyboardLanguage();
        }
    }

    private int getUpdatedCaret(int carOffset) {
        String str = this.myField.getText();
        LineIndx lineIndx = new LineIndx(str, carOffset);
        int starIndx = lineIndx.getStartIndx();
        int endIndx = lineIndx.getEndIndx();
        if (endIndx == str.length() - 1) {
            --carOffset;
        }
        return starIndx + (endIndx - carOffset);
    }

    private void handleAutoPush() {
        if (this.isPushMode && !this.isWidgetReversed && BidiUtil.getKeyboardLanguage() == 0 || this.isPushMode && this.isWidgetReversed && BidiUtil.getKeyboardLanguage() == 1) {
            this.setPush(false);
        } else if (!this.isPushMode && !this.isWidgetReversed && BidiUtil.getKeyboardLanguage() == 1 || !this.isPushMode && this.isWidgetReversed && BidiUtil.getKeyboardLanguage() == 0) {
            this.setPush(true);
        }
    }

    private void setBidiKeyboardLanguage() {
        BidiUtil.setKeyboardLanguage((int)1);
    }

    private void setNonBidiKeyboardLanguage() {
        BidiUtil.setKeyboardLanguage((int)0);
    }

    private int getCaretOffset() {
        return this.myField.getCaretPosition();
    }

    private void setCaretOffset(int offset) {
        this.myField.setSelection(offset);
    }

    private class LineIndx {
        private int startIndx = -1;
        private int endIndx = -1;

        LineIndx(String str, int indx) {
            this.startIndx = str.substring(0, indx).lastIndexOf(VisualField.eolStr);
            this.startIndx = this.startIndx == -1 ? 0 : (this.startIndx += VisualField.eolStr.length());
            this.endIndx = str.substring(this.startIndx).indexOf(VisualField.eolStr);
            if (this.endIndx == -1) {
                this.endIndx = str.substring(this.startIndx).length() - 1;
            }
            this.endIndx += this.startIndx;
        }

        private int getStartIndx() {
            return this.startIndx;
        }

        private int getEndIndx() {
            return this.endIndx;
        }
    }
}

