/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.Messages;
import java.util.Calendar;

public abstract class TimeUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String UNIT_DAY = Messages.DAYS;
    private static final String UNIT_HOURS = Messages.HOURS;
    private static final String UNIT_MINUTES = Messages.MINS;
    private static final String UNIT_SECONDS = Messages.SECS;
    private static final String UNIT_MILLISECONDS = Messages.MILLISECS;

    public static String formatDifference(Calendar start, Calendar end) {
        Calendar ended = start;
        Calendar started = end;
        if (started == null || ended == null) {
            return null;
        }
        long diff = started.getTimeInMillis() - ended.getTimeInMillis();
        long days = diff / 86400000L;
        long hours = diff / 3600000L % 24L;
        long minutes = diff / 60000L % 60L;
        long seconds = diff / 1000L % 60L;
        long milliseconds = diff % 1000L;
        Object formatted = "";
        if (days > 0L) {
            formatted = (String)formatted + days + " " + UNIT_DAY;
        }
        if (hours > 0L) {
            if (!((String)formatted).isEmpty()) {
                formatted = (String)formatted + ", ";
            }
            formatted = (String)formatted + hours + " " + UNIT_HOURS;
        }
        if (minutes > 0L) {
            if (!((String)formatted).isEmpty()) {
                formatted = (String)formatted + ", ";
            }
            formatted = (String)formatted + minutes + " " + UNIT_MINUTES;
        }
        if (seconds > 0L) {
            if (!((String)formatted).isEmpty()) {
                formatted = (String)formatted + ", ";
            }
            formatted = (String)formatted + seconds + " " + UNIT_SECONDS;
        }
        if (milliseconds >= 0L) {
            if (!((String)formatted).isEmpty()) {
                formatted = (String)formatted + ", ";
            }
            formatted = (String)formatted + milliseconds + " " + UNIT_MILLISECONDS;
        }
        return formatted;
    }
}

