/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.util.Objects;
import java.util.concurrent.Callable;

public abstract class PDSafeRunner {
    private static PDLoggerJhost logger;

    private static PDLoggerJhost getLogger() {
        if (logger == null) {
            logger = PDLoggerJhost.get(PDSafeRunner.class);
        }
        return logger;
    }

    public static void run(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            PDSafeRunner.getLogger().error((Object)"An error occurred while performing an operation: ", t);
            PDSafeRunner.getLogger().printCurrentStackTrace(t.getMessage() + "\n");
        }
    }

    public static <T> T call(Callable<T> c) {
        try {
            return c.call();
        }
        catch (Throwable t) {
            PDSafeRunner.getLogger().error((Object)"An error occurred while performing an operation: ", t);
            PDSafeRunner.getLogger().printCurrentStackTrace(t.getMessage() + "\n");
            return null;
        }
    }

    public static Runnable wrap(final Runnable r) {
        Objects.requireNonNull(r, "Please specify a non-null runnable.");
        return new Runnable(){

            @Override
            public void run() {
                PDSafeRunner.run(r);
            }
        };
    }
}

