/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum PDJhostEventBus {
    BUS;

    private Map<String, List<IPDJhostEventHandler>> handlers = new ConcurrentHashMap<String, List<IPDJhostEventHandler>>();
    private Set<IPDJhostEventPublisher> brokers = new HashSet<IPDJhostEventPublisher>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subscribe(String topic, IPDJhostEventHandler eventHandler) {
        if (topic == null || eventHandler == null) {
            return false;
        }
        Map<String, List<IPDJhostEventHandler>> map = this.handlers;
        synchronized (map) {
            if (this.handlers.containsKey(topic)) {
                List<IPDJhostEventHandler> list = this.handlers.get(topic);
                list.add(eventHandler);
            } else {
                ArrayList<IPDJhostEventHandler> list = new ArrayList<IPDJhostEventHandler>();
                list.add(eventHandler);
                this.handlers.put(topic, list);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String topic, IPDJhostEventHandler eventHandler) {
        if (topic == null || eventHandler == null) {
            return false;
        }
        Map<String, List<IPDJhostEventHandler>> map = this.handlers;
        synchronized (map) {
            List<IPDJhostEventHandler> list = this.handlers.get(topic);
            if (list != null && list.contains(eventHandler)) {
                list.remove(eventHandler);
            }
        }
        return true;
    }

    private PDJhostEventBus() {
        this.addBroker(new IPDJhostEventPublisher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void send(String topic, Map<String, String> data) {
                Map<String, List<IPDJhostEventHandler>> map = PDJhostEventBus.this.handlers;
                synchronized (map) {
                    for (Map.Entry<String, List<IPDJhostEventHandler>> handler : PDJhostEventBus.this.handlers.entrySet()) {
                        if (!handler.getKey().equals(topic)) continue;
                        for (IPDJhostEventHandler h : handler.getValue()) {
                            h.handleEvent(data);
                        }
                    }
                }
            }

            @Override
            public void post(final String topic, final Map<String, String> parameters) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map<String, List<IPDJhostEventHandler>> map = (this).PDJhostEventBus.this.handlers;
                        synchronized (map) {
                            for (Map.Entry<String, List<IPDJhostEventHandler>> handler : (this).PDJhostEventBus.this.handlers.entrySet()) {
                                if (!handler.getKey().equals(topic)) continue;
                                for (IPDJhostEventHandler h : handler.getValue()) {
                                    h.handleEvent(parameters);
                                }
                            }
                        }
                    }
                }).start();
            }
        });
        boolean addTestingSubsriber = false;
        if (addTestingSubsriber) {
            this.subscribe("com/ibm/pdtools/model/changed", new IPDJhostEventHandler(){

                @Override
                public void handleEvent(Map<String, String> parameters) {
                    PDLoggerJhost.get(PDJhostEventBus.class).trace((Object)MessageFormat.format("Jhost Test event handler: handling {0} event: {1}", "com/ibm/pdtools/model/changed", parameters));
                }
            });
        }
    }

    private void addBroker(IPDJhostEventPublisher broker) {
        if (broker != null) {
            PDLoggerJhost.get(PDJhostEventBus.class).trace((Object)MessageFormat.format("Added broker:{0}", broker));
            this.brokers.add(broker);
        }
    }

    private void removeBroker(IPDJhostEventPublisher broker) {
        if (broker != null) {
            this.brokers.remove(broker);
        }
    }

    public void post(String topic, Map<String, String> parameters) {
        Objects.requireNonNull(topic, "A topic must be specified.");
        Objects.requireNonNull(parameters, "A parameters map must be specified. ( it can be empty if needed, just not null).");
        this.checkBrokersAvailable();
        if (!this.isTopicSubscribed(topic)) {
            PDLoggerJhost.get(((Object)((Object)this)).getClass()).warn((Object)MessageFormat.format("WARNING: There are no subscribers for topic: {0}. Please ensure all required plugins are installed.", topic));
        }
        PDLoggerJhost.get(PDJhostEventBus.class).trace((Object)MessageFormat.format("{0} {1}", topic, parameters));
        for (IPDJhostEventPublisher ipdEventBroker : this.brokers) {
            ipdEventBroker.post(topic, parameters);
        }
    }

    private void checkBrokersAvailable() {
        if (this.brokers.isEmpty()) {
            throw new IllegalStateException(MessageFormat.format("Error: no brokers are available  - can not post event! (Add a {0} and try again)", IPDJhostEventPublisher.class.getCanonicalName()));
        }
    }

    public void send(String topic, Map<String, String> parameters) {
        Objects.requireNonNull(topic, "A topic must be specified.");
        Objects.requireNonNull(parameters, "A parameters map must be specified. ( it can be empty if needed, just not null).");
        this.checkBrokersAvailable();
        if (!this.isTopicSubscribed(topic)) {
            PDLoggerJhost.get(((Object)((Object)this)).getClass()).warn((Object)MessageFormat.format("WARNING: There are no subscribers for topic: {0}. Please ensure all required plugins are installed.", topic));
        }
        PDLoggerJhost.get(PDJhostEventBus.class).trace((Object)MessageFormat.format("{0} {1}", topic, parameters));
        for (IPDJhostEventPublisher ipdEventBroker : this.brokers) {
            ipdEventBroker.send(topic, parameters);
        }
    }

    public boolean isTopicSubscribed(String topic) {
        if (topic == null) {
            return false;
        }
        return this.handlers.containsKey(topic);
    }

    public static interface IPDJhostEventHandler {
        public void handleEvent(Map<String, String> var1);
    }

    public static interface IPDJhostEventPublisher {
        public void post(String var1, Map<String, String> var2);

        public void send(String var1, Map<String, String> var2);
    }
}

