/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.text.MessageFormat;
import java.util.Objects;

public enum PDGenerics {
    UTIL;

    private static final PDLoggerJhost logger;

    static {
        logger = PDLoggerJhost.get(PDGenerics.class);
    }

    public static <T> T cast(Object o, Class<T> c) throws NullPointerException {
        Objects.requireNonNull(o, "Must specify a non-null object.");
        Objects.requireNonNull(c, "Must specify a non-null class.");
        try {
            return c.cast(o);
        }
        catch (ClassCastException e) {
            logger.warn((Object)MessageFormat.format("Could not cast {0} class: {1} to {2}", o, o.getClass(), c.getClass()));
            return null;
        }
    }

    public static <T, V> T castIfInstanceOf(V objectToCast, Class<T> expectedType) throws ClassCastException {
        if (expectedType != null && objectToCast != null && expectedType.isInstance(objectToCast)) {
            return expectedType.cast(objectToCast);
        }
        return null;
    }
}

