/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.Messages;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;

public class EncodingUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ASCII_CODE_PAGE = "ISO-8859-1";
    public static final String DEFAULT_DBCS_ENCODING = "cp930";
    private static final String[] DEFAULT_ENCODING_VALUES = new String[]{"cp037: " + Messages.Host_CP037, "cp273: " + Messages.Host_CP273, "cp297: " + Messages.Host_CP297, "cp420: " + Messages.Host_CP420, "cp424: " + Messages.Host_CP424, "cp930: " + Messages.Host_CP930, "cp933: " + Messages.Host_CP933, "cp939: " + Messages.Host_CP939, "cp1047: " + Messages.Host_CP1047, "cp1140: " + Messages.Host_CP1140, "cp1141: " + Messages.Host_CP1141};
    private static final String[] DEFAULT_DBCS_ENCODING_VALUES = new String[]{"", "cp930: " + Messages.Host_CP930, "cp933: " + Messages.Host_CP933, "cp939: " + Messages.Host_CP939};
    private static final char ENCODING_DESCRIPTION_SEPARATOR = ':';

    public static String[] getDefaultEncodingValues() {
        return Arrays.copyOf(DEFAULT_ENCODING_VALUES, DEFAULT_ENCODING_VALUES.length);
    }

    public static String[] getDefaultDBCSEncodingValues() {
        return Arrays.copyOf(DEFAULT_DBCS_ENCODING_VALUES, DEFAULT_DBCS_ENCODING_VALUES.length);
    }

    public static boolean isValidCodePage(String parsedCodePage) {
        if (parsedCodePage == null || parsedCodePage.isEmpty()) {
            return false;
        }
        try {
            return Charset.isSupported(parsedCodePage);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    public static String parseCodePage(String codePage) {
        if (codePage == null) {
            return "";
        }
        if (codePage.indexOf(58) != -1) {
            codePage = codePage.substring(0, codePage.indexOf(58));
        }
        return codePage.toLowerCase();
    }

    public static String codepageConverter(String input, String codepageIn, String codepageOut) {
        try {
            byte[] cpbytes = input.getBytes(codepageIn);
            return new String(cpbytes, codepageOut);
        }
        catch (Exception exception) {
            return input;
        }
    }

    public static char codepageConverter(char input, String codepageIn, String codepageOut) {
        char[] arr = new char[]{input};
        String result = EncodingUtils.codepageConverter(new String(arr), codepageIn, codepageOut);
        return result.charAt(0);
    }
}

