/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ArrayUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static <E> Iterable<E> padTo(Iterable<E> iterable, final E padding, final int size) {
        Objects.requireNonNull(iterable, "Please provide a non-null iterable.");
        final Iterator<E> iter = iterable.iterator();
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    int count = 0;

                    @Override
                    public boolean hasNext() {
                        return this.count < size;
                    }

                    @Override
                    public E next() {
                        ++this.count;
                        if (iter.hasNext()) {
                            return iter.next();
                        }
                        return padding;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static StringBuilder join(Object[] array, String separator) {
        if (array == null || array.length == 0) {
            return new StringBuilder();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(array[0]);
        if (array.length == 1) {
            return sb;
        }
        int i = 1;
        while (i < array.length) {
            sb.append(separator);
            sb.append(array[i]);
            ++i;
        }
        return sb;
    }

    public static Object[] slice(Object[] array, int end) {
        return ArrayUtils.slice(0, array, end);
    }

    public static Object[] slice(int begin, Object[] array) {
        Objects.requireNonNull(array);
        return ArrayUtils.slice(begin, array, array.length);
    }

    public static Object[] slice(int begin, Object[] array, int end) {
        if (array == null) {
            return null;
        }
        begin = Math.max(0, begin);
        end = Math.min(array.length, end);
        Object[] newArray = new Object[end - begin];
        int i = begin;
        while (i < end) {
            newArray[begin + i] = array[i];
            ++i;
        }
        return newArray;
    }

    public static Object[] concat(Object[] a, Object[] b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Object[] c = new Object[a.length + b.length];
        int i = 0;
        while (i < c.length) {
            c[i] = i < a.length ? a[i] : b[i - a.length];
            ++i;
        }
        return c;
    }

    public static <T> StringBuffer concatArrayList(ArrayList<T> al) {
        Objects.requireNonNull(al);
        return ArrayUtils.concatArrayList(al, "", "");
    }

    public static <O> StringBuffer concatArrayList(ArrayList<O> al, String prefix, String suffix) {
        Objects.requireNonNull(al);
        return ArrayUtils.concatArrayList(al, prefix, suffix, 0, al.size());
    }

    public static <O> StringBuffer concatArrayList(ArrayList<O> al, String prefix, String suffix, int startFrom, int endAt) {
        int lenEst = al.size() > 0 ? 0 : al.get(0).toString().length() + suffix.length();
        StringBuffer sb = new StringBuffer(al.size() * lenEst);
        if (endAt == 0) {
            endAt = al.size();
        }
        int i = startFrom;
        while (i < Math.min(endAt, al.size())) {
            sb.append(prefix).append(al.get(i).toString()).append(suffix);
            ++i;
        }
        return sb;
    }

    public static <A> int findIndexOf(A toFind, A[] inArray, int valueToReturnIfNotFound) {
        if (toFind == null) {
            return valueToReturnIfNotFound;
        }
        int i = 0;
        while (i < inArray.length) {
            if (toFind.equals(inArray[i])) {
                return i;
            }
            ++i;
        }
        return valueToReturnIfNotFound;
    }

    public static String[] getToStringArray(Object[] array) {
        Objects.requireNonNull(array);
        String[] toStringArray = new String[array.length];
        int i = 0;
        while (i < array.length) {
            toStringArray[i] = array[i] == null ? "" : array[i].toString();
            ++i;
        }
        return toStringArray;
    }

    public static <A> List<A> filter(A[] objects, ArrayTester<A> tester) {
        ArrayList<A> newList = new ArrayList<A>(objects.length);
        A[] AArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            A object = AArray[n2];
            if (tester.test(object)) {
                newList.add(object);
            }
            ++n2;
        }
        return newList;
    }

    public static abstract class ArrayTester<A> {
        public static ArrayTester<Object> EXCLUDE_NULL = new ArrayTester<Object>(){

            @Override
            protected boolean test(Object obj) {
                return obj != null;
            }
        };

        protected boolean test(A obj) {
            return true;
        }
    }
}

