/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.socket.response;

import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.core.Messages;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;

public class SimpleResponsePacket {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int HEADER_LENGATH = 24;
    protected NonBlockingSocketIOJhost socketIO;
    protected IHowIsGoing howIsGoing;
    private int totalBytes = 0;
    private int replyCode = 0;
    private int returnCode = 0;
    private int msgCount = 0;
    private int msgOffset = 0;
    private int flags = 0;
    private boolean iRepFinal = false;
    private boolean iRepMoreData = false;
    private boolean iRepNoMoreData = false;
    private boolean iRepDidAttn = false;
    private boolean iRepDidAbend = false;
    private boolean iRepSession = false;
    private boolean iRepXml = false;
    private String[] pdMessages = null;
    private boolean messagesParsed = false;
    private int totalMessageDataLength = 0;
    private static final PDLoggerJhost logger = PDLoggerJhost.get(SimpleResponsePacket.class);

    public SimpleResponsePacket(NonBlockingSocketIOJhost socketIO, IHowIsGoing howIsGoing) throws IOException, InterruptedException, CommunicationException {
        if (socketIO == null) {
            throw new IllegalArgumentException("Must pass in a non-null NonBlockingSocketIO.");
        }
        Objects.requireNonNull(socketIO.getSocket(), "Underlying socket is null.");
        this.socketIO = socketIO;
        this.howIsGoing = howIsGoing;
        this.readCommonReplyHeader(socketIO);
    }

    protected CommunicationException getBadReplyCodeException(int ... expectedCodes) {
        StringBuilder msg = new StringBuilder(MessageFormat.format(Messages.SimpleResponsePacket_INVALID_REPLY_CODE, this.getReplyCode()));
        if (expectedCodes.length > 0) {
            msg.append(MessageFormat.format(Messages.SimpleResponsePacket_EXPECTED, expectedCodes[0]));
        }
        if (expectedCodes.length > 1) {
            int i = 1;
            while (i < expectedCodes.length) {
                msg.append(MessageFormat.format(Messages.SimpleResponsePacket_OR, expectedCodes[i]));
                ++i;
            }
        }
        return new CommunicationException(msg.toString());
    }

    private void parseMessages(String codepage) throws IOException, InterruptedException {
        if (this.messagesParsed) {
            logger.trace((Object)"messages parsed before.");
            return;
        }
        if (this.getMsgCount() == 0) {
            logger.trace((Object)"no messages.");
            this.totalMessageDataLength = 0;
            return;
        }
        this.totalMessageDataLength = 0;
        this.pdMessages = new String[this.getMsgCount()];
        logger.trace((Object)("expecting read " + this.getMsgCount() + " messages."));
        int i = 0;
        while (i < this.msgCount) {
            int msgID = this.socketIO.readUnsignedInt(this.howIsGoing);
            logger.trace((Object)("msgID=" + msgID));
            this.totalMessageDataLength += 4;
            int msgLen = this.socketIO.readUnsignedInt(this.howIsGoing);
            logger.trace((Object)("msgLen=" + msgLen));
            this.totalMessageDataLength += 4;
            byte[] msgBytes = new byte[msgLen];
            this.socketIO.readBytes(msgBytes, msgLen, this.howIsGoing);
            this.pdMessages[i] = codepage != null ? new String(msgBytes, 0, msgLen, codepage) : new String(msgBytes, 0, msgLen, this.socketIO.getEncoding());
            logger.trace((Object)("msg: " + this.pdMessages[i]));
            this.totalMessageDataLength += msgLen;
            ++i;
        }
        this.messagesParsed = true;
    }

    @Deprecated
    public String[] getMessages() throws IOException, InterruptedException {
        this.parseMessages(null);
        return this.pdMessages == null ? new String[]{} : this.pdMessages;
    }

    public String[] getMessages(String codepage) throws IOException, InterruptedException {
        this.parseMessages(codepage);
        return this.pdMessages == null ? new String[]{} : this.pdMessages;
    }

    public int getMessageDataSize() {
        return this.totalMessageDataLength;
    }

    private void readCommonReplyHeader(NonBlockingSocketIOJhost socketIO) throws IOException, InterruptedException {
        this.totalBytes = socketIO.readUnsignedInt(this.howIsGoing);
        this.replyCode = socketIO.readUnsignedInt(this.howIsGoing);
        this.returnCode = socketIO.readUnsignedInt(this.howIsGoing);
        this.msgCount = socketIO.readUnsignedInt(this.howIsGoing);
        this.msgOffset = socketIO.readUnsignedInt(this.howIsGoing);
        this.flags = socketIO.readUnsignedInt(this.howIsGoing);
        this.iRepFinal = (this.flags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        this.iRepMoreData = (this.flags & 0x40000000) == 0x40000000;
        this.iRepNoMoreData = (this.flags & 0x20000000) == 0x20000000;
        this.iRepDidAttn = (this.flags & 0x10000000) == 0x10000000;
        this.iRepDidAbend = (this.flags & 0x8000000) == 0x8000000;
        this.iRepSession = (this.flags & 0x4000000) == 0x4000000;
        boolean bl = this.iRepXml = (this.flags & 0x800000) == 0x800000;
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("totalBytes={0} replyCode={1} returnCode={2} msgCount={3} msgOffset={4} iRepFinal={5} iRepMoreData={6} iRepNoMoreData={7} iRepDidAttn={8} iRepDidAbend={9} iRepSession={10} iRepXml={11}", this.totalBytes, this.replyCode, this.returnCode, this.msgCount, this.msgOffset, this.iRepFinal, this.iRepMoreData, this.iRepNoMoreData, this.iRepDidAttn, this.iRepDidAbend, this.iRepSession, this.iRepXml));
        }
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public int getMsgOffset() {
        return this.msgOffset;
    }

    @Deprecated
    public boolean isiRepFinal() {
        return this.iRepFinal;
    }

    public boolean isiRepMoreData() {
        return this.iRepMoreData;
    }

    @Deprecated
    public boolean isiRepNoMoreData() {
        return this.iRepNoMoreData;
    }

    public boolean isiRepDidAttn() {
        return this.iRepDidAttn;
    }

    public boolean isiRepDidAbend() {
        return this.iRepDidAbend;
    }

    public boolean isiRepSession() {
        return this.iRepSession;
    }

    public boolean isiRepXml() {
        return this.iRepXml;
    }
}

