/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.socket.response;

import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.socket.response.SimpleResponsePacket;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Objects;

public class GetRecResponsePacket
extends SimpleResponsePacket {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private int iRepGetRecType = 0;
    private int iRepNum = 0;
    private static final PDLoggerJhost logger = PDLoggerJhost.get(GetRecResponsePacket.class);
    private byte[][] records = null;

    public GetRecResponsePacket(NonBlockingSocketIOJhost socketIO, IHowIsGoing howIsGoing) throws IOException, CommunicationException, InterruptedException {
        super(socketIO, howIsGoing);
        if (this.getReplyCode() != 16) {
            socketIO.closeConnection();
            throw this.getBadReplyCodeException(16);
        }
        this.iRepGetRecType = socketIO.readUnsignedInt(howIsGoing);
        this.iRepNum = socketIO.readUnsignedInt(howIsGoing);
        this.parseRecords();
    }

    public int getiRepGetRecType() {
        return this.iRepGetRecType;
    }

    public int getiRepNum() {
        return this.iRepNum;
    }

    private void parseRecords() throws IOException, InterruptedException {
        if (this.getiRepNum() == 0) {
            logger.trace((Object)"no records to read.");
            return;
        }
        this.records = new byte[this.getiRepNum()][];
        logger.trace((Object)("expecting to read " + this.getiRepNum() + " records."));
        int i = 0;
        while (i < this.records.length) {
            int recLen = this.socketIO.readUnsignedInt(this.howIsGoing);
            this.records[i] = new byte[recLen];
            this.socketIO.readBytes(this.records[i], recLen, this.howIsGoing);
            ++i;
        }
    }

    private byte[][] getRecords() {
        return this.records;
    }

    public String getRecordsAsString(String encoding) throws UnsupportedEncodingException {
        Objects.requireNonNull(encoding, "Please provide a non-null encoding.");
        StringBuffer sb = new StringBuffer();
        byte[][] recs = this.getRecords();
        if (recs == null) {
            return "";
        }
        int i = 0;
        while (i < recs.length) {
            String s = new String(recs[i], encoding);
            sb.append(s + "\n");
            ++i;
        }
        return sb.toString();
    }
}

