/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.socket.io;

import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.socket.io.CommonConnectionJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ConnPoolManagerJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static ConnPoolManagerJhost instance = new ConnPoolManagerJhost();
    private static final PDLoggerJhost logger = PDLoggerJhost.get(ConnPoolManagerJhost.class);
    private Map<IPDConnectEndpoint, Set<CommonConnectionJhost>> conns = new HashMap<IPDConnectEndpoint, Set<CommonConnectionJhost>>();
    protected final Map<IPDConnectEndpoint, IHowIsGoing> currentConnAttempts = new HashMap<IPDConnectEndpoint, IHowIsGoing>();

    public static ConnPoolManagerJhost instance() {
        return instance;
    }

    public ConnPoolManagerJhost() {
        RegistryLocator.instance().getHostRegistry().addListener(new EListener<EntityEvent<IPDHost>>(){

            @Override
            public void onEvent(EntityEvent<IPDHost> event) {
                if (event.getType() == EntityEventType.REMOVED) {
                    IPDHost entity = event.getEntity();
                    ConnPoolManagerJhost.this.closeAllConnections(entity);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasConnectionInUse(IPDHost pdHost) {
        Objects.requireNonNull(pdHost, "Please provide a non-null pdHost.");
        Map<IPDConnectEndpoint, Set<CommonConnectionJhost>> map = this.conns;
        synchronized (map) {
            Set<IPDConnectEndpoint> endPoints = this.conns.keySet();
            for (IPDConnectEndpoint endpoint : endPoints) {
                Set<CommonConnectionJhost> systemConnections = this.conns.get(endpoint);
                if (systemConnections == null) continue;
                for (CommonConnectionJhost connection : systemConnections) {
                    if (!connection.getSystem().equals(pdHost) || !connection.isLocked()) continue;
                    logger.trace((Object)("hasConnectionInUse() detected locked connection so returning true: " + String.valueOf(connection)));
                    return true;
                }
            }
            if (this.currentConnAttempts.size() <= 0) return false;
            boolean bl = true;
            boolean connectionBeingMade = bl;
            if (!connectionBeingMade) return connectionBeingMade;
            logger.trace((Object)("hasConnectionInUse() detected connection attempt in progress so returning true; num connections in progress: " + this.currentConnAttempts.size()));
            return connectionBeingMade;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasConnectionInUse(IPDConnectEndpoint endpoint) {
        Objects.requireNonNull(endpoint, "Please provide a non-null endpoint.");
        Map<IPDConnectEndpoint, Set<CommonConnectionJhost>> map = this.conns;
        synchronized (map) {
            Set<CommonConnectionJhost> systemConnections = this.conns.get(endpoint);
            if (systemConnections != null) {
                for (CommonConnectionJhost connection : systemConnections) {
                    if (!connection.isLocked()) continue;
                    logger.trace((Object)("hasConnectionInUse() detected locked connection so returning true: " + String.valueOf(connection)));
                    return true;
                }
            }
            if (this.currentConnAttempts.size() <= 0) return false;
            boolean bl = true;
            boolean connectionBeingMade = bl;
            if (!connectionBeingMade) return connectionBeingMade;
            logger.trace((Object)("hasConnectionInUse() detected connection attempt in progress so returning true; num connections in progress: " + this.currentConnAttempts.size()));
            return connectionBeingMade;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnectionsForEndpoint(IPDConnectEndpoint endpoint) {
        Map<IPDConnectEndpoint, Set<CommonConnectionJhost>> map = this.conns;
        synchronized (map) {
            for (Map.Entry<IPDConnectEndpoint, Set<CommonConnectionJhost>> entry : this.conns.entrySet()) {
                if (!entry.getKey().equals(endpoint)) continue;
                for (CommonConnectionJhost c : entry.getValue()) {
                    c.forceConnectionClose();
                }
            }
            for (Map.Entry<IPDConnectEndpoint, Object> entry : this.currentConnAttempts.entrySet()) {
                if (!entry.getKey().equals(endpoint)) continue;
                ((IHowIsGoing)entry.getValue()).setCanceled(true);
            }
            logger.trace((Object)("Cancelled all (" + this.currentConnAttempts.size() + ") in progress connection attempts for endpoint " + String.valueOf(endpoint)));
            this.currentConnAttempts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections(IPDHost pdHost) {
        if (pdHost == null) {
            logger.trace((Object)"Was Passed a null host...");
        }
        Map<IPDConnectEndpoint, Set<CommonConnectionJhost>> map = this.conns;
        synchronized (map) {
            for (Map.Entry<IPDConnectEndpoint, Set<CommonConnectionJhost>> entry : this.conns.entrySet()) {
                for (CommonConnectionJhost aCommonConnection : entry.getValue()) {
                    if (!aCommonConnection.getSystem().equals(pdHost)) continue;
                    aCommonConnection.forceConnectionClose();
                }
            }
            for (Map.Entry<IPDConnectEndpoint, Object> entry : this.currentConnAttempts.entrySet()) {
                if (!entry.getKey().endPointPDHost(pdHost)) continue;
                ((IHowIsGoing)entry.getValue()).setCanceled(true);
            }
            logger.trace((Object)("Cancelled all (" + this.currentConnAttempts.size() + ") in progress connection attempts for system " + (pdHost == null ? "null" : pdHost.toString())));
            this.currentConnAttempts.clear();
        }
    }

    @Deprecated
    public CommonConnectionJhost getConnection(IPDHost pdHost, IPDConnectEndpoint endpoint, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        return this.getConnection(pdHost, endpoint, null, howIsGoing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonConnectionJhost getConnection(IPDHost pdHost, IPDConnectEndpoint endpoint, PDContext pdContext, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        Set<CommonConnectionJhost> systemConnections;
        logger.debug((Object)("New connection request arrived for endpoint " + String.valueOf(endpoint == null ? "null" : endpoint) + " on system " + (pdHost == null ? "null" : pdHost.toString())));
        Objects.requireNonNull(endpoint, "Please specify a non-null endpoint.");
        CommonConnectionJhost chosenConnection = null;
        Map<IPDConnectEndpoint, Set<CommonConnectionJhost>> map = this.conns;
        synchronized (map) {
            systemConnections = this.getConnectionsForEndpoint(endpoint);
            HashSet<CommonConnectionJhost> deadConnections = new HashSet<CommonConnectionJhost>();
            logger.trace((Object)("Doing cleanup: there are " + systemConnections.size() + " connections for endpoint" + String.valueOf(endpoint == null ? "null" : endpoint) + " on system " + (pdHost == null ? "null" : pdHost.toString())));
            Iterator<CommonConnectionJhost> iterator = systemConnections.iterator();
            while (chosenConnection == null && iterator.hasNext()) {
                CommonConnectionJhost systemConnection = iterator.next();
                logger.trace((Object)(endpoint.toString() + "-->" + String.valueOf(systemConnection)));
                if (systemConnection.isLocked()) continue;
                if (systemConnection.isClosed(howIsGoing)) {
                    deadConnections.add(systemConnection);
                    continue;
                }
                if (systemConnection.bytesAvailable(howIsGoing) == -1 || systemConnection.bytesAvailable(howIsGoing) > 0) {
                    deadConnections.add(systemConnection);
                    continue;
                }
                if (chosenConnection != null) continue;
                chosenConnection = systemConnection;
            }
            int totalBefore = systemConnections.size();
            int deadTotal = deadConnections.size();
            systemConnections.removeAll(deadConnections);
            logger.trace((Object)("Cleanup completed: active connection before: " + totalBefore + " Dead connection: " + deadTotal + " Active connection after: " + systemConnections.size()));
            if (chosenConnection != null) {
                logger.debug((Object)("Found an existing connection for re-use for endpoint " + String.valueOf(endpoint == null ? "null" : endpoint) + " on system " + (pdHost == null ? "null" : pdHost.toString())));
                chosenConnection.lock();
                return chosenConnection;
            }
            this.currentConnAttempts.put(endpoint, howIsGoing);
        }
        logger.debug((Object)("No re-useable connection available for endpoint " + String.valueOf(endpoint == null ? "null" : endpoint) + " on system " + (pdHost == null ? "null" : pdHost.toString()) + ". Establishing new connection."));
        chosenConnection = endpoint.getNewConnection(pdHost, pdContext, howIsGoing);
        if (chosenConnection == null) {
            return null;
        }
        chosenConnection.lock();
        logger.debug((Object)("Got a new connection and set compiler options for endpoint " + String.valueOf(endpoint == null ? "null" : endpoint) + " on system " + (pdHost == null ? "null" : pdHost.toString())));
        map = this.conns;
        synchronized (map) {
            logger.debug((Object)("Just about to finish returning a new connection for endpoint " + String.valueOf(endpoint == null ? "null" : endpoint) + " on system " + (pdHost == null ? "null" : pdHost.toString())));
            this.currentConnAttempts.remove(endpoint);
            if (howIsGoing != null && howIsGoing.isCanceled()) {
                logger.trace((Object)"Connect attempt was cancelled");
                chosenConnection.forceConnectionClose();
                chosenConnection.unlock();
                throw new InterruptedException();
            }
            systemConnections = this.getConnectionsForEndpoint(endpoint);
            systemConnections.add(chosenConnection);
            logger.trace((Object)("Now have " + systemConnections.size() + " connections"));
        }
        return chosenConnection;
    }

    private Set<CommonConnectionJhost> getConnectionsForEndpoint(IPDConnectEndpoint endpoint) {
        Objects.requireNonNull(endpoint, "Can't get connections for a null endpoint.");
        Objects.requireNonNull(this.conns, "The endpoint connection map is null.");
        Set<CommonConnectionJhost> systemConnections = this.conns.get(endpoint);
        if (systemConnections == null) {
            systemConnections = new HashSet<CommonConnectionJhost>();
            this.conns.put(endpoint, systemConnections);
        }
        return systemConnections;
    }
}

