/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.logging;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;

public class ThrowableRenderer {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static Pattern interestingClasses = null;

    public static void setInterestingClasses(Pattern interestingClasses) {
        ThrowableRenderer.interestingClasses = interestingClasses;
    }

    public static String renderLocalizedOneLiner(Throwable t) {
        String token;
        Objects.requireNonNull(t, "Must specify a non-null Throwable.");
        if (t.getLocalizedMessage() == null || t.getLocalizedMessage().isEmpty()) {
            return MessageFormat.format("Error: {0}", t.getClass().getSimpleName());
        }
        StringTokenizer tokenizer = new StringTokenizer(t.getLocalizedMessage(), "\r\n");
        while ((token = tokenizer.nextToken().trim()).isEmpty()) {
        }
        if (token.charAt(token.length() - 1) == ':' || token.charAt(token.length() - 1) == ';') {
            token = token.substring(0, token.length() - 1);
        }
        return MessageFormat.format("Error: {0}", token.trim());
    }

    public static Object[] renderLocalizedManyLiner(Throwable t) {
        Objects.requireNonNull(t, "Must specify a non-null Throwable.");
        if (t.getLocalizedMessage() == null || t.getLocalizedMessage().isEmpty()) {
            return new String[]{MessageFormat.format("Error: {0}", t.getClass().getSimpleName())};
        }
        ArrayList<String> msgList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(t.getLocalizedMessage(), "\r\n");
        String token = tokenizer.nextToken().trim();
        if (token != null) {
            msgList.add(MessageFormat.format("Error: {0}", token.trim()));
            try {
                while (token != null && !token.isEmpty()) {
                    token = tokenizer.nextToken().trim();
                    if (token == null || token.length() <= 0) continue;
                    msgList.add(token);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return msgList.toArray();
    }

    public static StringBuilder renderShortForm(Throwable t) {
        Objects.requireNonNull(t, "Must specify a non-null Throwable.");
        StringBuilder sb = new StringBuilder();
        sb.append(t.getClass().getSimpleName());
        String msg = t.getLocalizedMessage();
        if (msg == null) {
            msg = t.getMessage();
        }
        if (msg != null) {
            sb.append(": ");
            sb.append(msg);
        }
        if (t.getCause() != null && t.getCause() != t) {
            sb.append("\nCaused by: ");
            sb.append((CharSequence)ThrowableRenderer.renderShortForm(t.getCause()));
        }
        return sb;
    }

    public static void doRender(PrintWriter printer, Throwable t) {
        Throwable previousThrowable = null;
        while (t != null && t != previousThrowable) {
            if (previousThrowable != null) {
                printer.println();
                printer.print("Caused by: ");
            }
            String msg = t.getMessage();
            printer.print(t.getClass().getSimpleName());
            if (msg != null && !"".equals(msg)) {
                printer.print(": ");
                printer.print(msg);
            }
            ThrowableRenderer.insertCustomExceptionText(printer, t);
            StackTraceElement[] stackTraceElementArray = t.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement traceElement = stackTraceElementArray[n2];
                ThrowableRenderer.printStackTraceElement(printer, traceElement);
                ++n2;
            }
            previousThrowable = t;
            t = t.getCause();
        }
    }

    private static int printStackTraceElement(PrintWriter printer, StackTraceElement element) {
        printer.println();
        if (interestingClasses != null && interestingClasses.matcher(element.getClassName()).matches()) {
            printer.print("--> ");
        } else {
            printer.print("    ");
        }
        printer.print(element.getClassName());
        printer.print(".");
        printer.print(element.getMethodName());
        printer.print("(");
        printer.print(element.getFileName());
        printer.print(":");
        printer.print(element.getLineNumber());
        printer.print(")");
        return 1;
    }

    private static void insertCustomExceptionText(PrintWriter printer, Throwable t) {
        if (t instanceof SAXParseException) {
            SAXParseException saxParseException = (SAXParseException)t;
            printer.println();
            printer.print("Sax parsing info: line: ");
            printer.print(saxParseException.getLineNumber());
            printer.print(", column: ");
            printer.print(saxParseException.getColumnNumber());
            printer.print(", public id: ");
            printer.print(saxParseException.getPublicId());
            printer.print(", system id: ");
            printer.print(saxParseException.getSystemId());
        }
    }

    public static Pattern getInterestingClasses() {
        return interestingClasses;
    }
}

