/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.logging;

import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.prefs.PDCommonPreferencePageJhost;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class PDLoggerJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    @Deprecated
    public static final String CONFIG_FILE = "";
    public static final int INT_EQUIV_LOG4J_TRACE = 5000;
    public static final int INT_EQUIV_LOG4J_DEBUG = 10000;
    public static final int INT_EQUIV_LOG4J_FATAL = 50000;
    public static final int INT_EQUIV_LOG4J_INFO = 20000;
    public static final int INT_EQUIV_LOG4J_WARN = 30000;
    public static final int INT_EQUIV_LOG4J_OFF = Integer.MAX_VALUE;
    public static final int INT_EQUIV_LOG4J_ALL = Integer.MIN_VALUE;
    public static final int INT_EQUIV_LOG4J_ERROR = 40000;
    public static final String ID = "com.ibm.pdtools.common.component.core.logger";
    @Deprecated
    public static boolean log4jConfigured = false;
    private String loggerName = "";
    private static Level currentLogLevel;

    static {
        ThrowableRenderer.setInterestingClasses(Pattern.compile("^com\\.ibm\\.(etools\\.f.\\..*|fmi\\..*|pdtools\\..*)"));
        currentLogLevel = Level.ERROR;
    }

    private static PDLoggerJhost getInstance(String name) {
        return new PDLoggerJhost(name){

            @Override
            protected void logToEclipse(Level level, String msg, Throwable t) {
            }
        };
    }

    public static PDLoggerJhost get(Class<?> clazz) {
        return PDLoggerJhost.getInstance(Objects.requireNonNull(clazz).getName());
    }

    public static PDLoggerJhost get(Object o) {
        return PDLoggerJhost.getInstance(Objects.requireNonNull(o).getClass().getName());
    }

    static PDLoggerJhost get(String name) {
        return PDLoggerJhost.getInstance(Objects.requireNonNull(name));
    }

    @Deprecated
    protected void setLogDir(String dir) {
    }

    protected String getLogDir() {
        return null;
    }

    protected PDLoggerJhost(String name) {
        if (name == null) {
            name = "--LoggerNameNotSet--";
        }
        this.loggerName = name;
        PDLoggerJhost.enableLogging(PDCommonPreferencePageJhost.getDebugMode());
        String csl = System.getenv("client-side-logging");
        if (csl != null && "on".equals(csl)) {
            PDLoggerJhost.enableLogging(true);
        }
    }

    @Deprecated
    public File getLogFile() {
        return null;
    }

    public static String filteredTrace(StackTraceElement[] trace) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = PDLoggerJhost.filteredTraceArray(trace);
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            sb.append(" <-- ").append(e).append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public static StackTraceElement[] filteredTraceArray(StackTraceElement[] trace) {
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>();
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.toString().toLowerCase().contains("ibm")) {
                filtered.add(e);
            }
            ++n2;
        }
        return filtered.toArray(new StackTraceElement[0]);
    }

    public static StackTraceElement[] filter(StackTraceElement[] trace, String ... classes) {
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>(Arrays.asList(trace));
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement s = stackTraceElementArray[n2];
            String[] stringArray = classes;
            int n3 = classes.length;
            int n4 = 0;
            while (n4 < n3) {
                String c = stringArray[n4];
                if (c.contains(s.getClassName()) || s.getClassName().contains(c)) {
                    filtered.remove(s);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return filtered.toArray(new StackTraceElement[filtered.size()]);
    }

    public static void enableLogging(boolean enabled) {
        currentLogLevel = enabled ? Level.ALL : Level.ERROR;
    }

    private void log(Level level, Object ... items) {
        this.log(level, true, items);
    }

    public void log(Level level, boolean logToEclipse, Object ... items) {
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter(sw);
        Throwable t = null;
        StringBuffer msg = new StringBuffer();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (i == items.length - 1 && items[i] instanceof Throwable) {
                    if (i > 0) {
                        p.println();
                    }
                    t = (Throwable)items[i];
                } else {
                    String strMsg = PDLoggerJhost.renderMessageToString(items[i]);
                    if (strMsg != null && !strMsg.isEmpty()) {
                        msg.append(strMsg);
                    }
                }
                ++i;
            }
        }
        if (msg.length() > 0) {
            p.print(msg.toString());
            if (t != null) {
                p.println();
            }
        }
        if (t != null) {
            ThrowableRenderer.doRender(p, t);
        }
        if (level == null) {
            level = Level.ERROR;
        }
        if (logToEclipse) {
            String theMessage = msg.toString();
            String theSwMessage = sw.toString();
            this.logToEclipse(level, theMessage, t);
            if (!theMessage.equals(theSwMessage)) {
                this.logToEclipse(level, theSwMessage, t);
            }
        }
    }

    protected abstract void logToEclipse(Level var1, String var2, Throwable var3);

    private static String renderMessageToString(Object msg) {
        return msg == null ? null : msg.toString();
    }

    public boolean trace() {
        return currentLogLevel.isEnabledFor(Level.TRACE);
    }

    public void trace(Object ... items) {
        this.log(Level.TRACE, items);
    }

    public void trace(Object msg) {
        this.log(Level.TRACE, msg);
    }

    public void trace(Throwable t) {
        this.log(Level.TRACE, t);
    }

    public void trace(Object msg, Throwable t) {
        this.log(Level.TRACE, msg, t);
    }

    public boolean debug() {
        return currentLogLevel.isEnabledFor(Level.DEBUG);
    }

    public void debug(Object ... items) {
        this.log(Level.DEBUG, items);
    }

    public void debug(Object msg) {
        this.log(Level.DEBUG, msg);
    }

    public void debug(Throwable t) {
        this.log(Level.DEBUG, t);
    }

    public void debug(Object msg, Throwable t) {
        this.log(Level.DEBUG, msg, t);
    }

    public boolean info() {
        return currentLogLevel.isEnabledFor(Level.INFO);
    }

    public void info(Object ... items) {
        this.log(Level.INFO, items);
    }

    public void info(Object msg) {
        this.log(Level.INFO, msg);
    }

    public void info(Throwable t) {
        this.log(Level.INFO, t);
    }

    public void info(Object msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public boolean warn() {
        return currentLogLevel.isEnabledFor(Level.WARN);
    }

    public void warn(Object ... items) {
        this.log(Level.WARN, items);
    }

    public void warn(Object msg) {
        this.log(Level.WARN, msg);
    }

    public void warn(Throwable t) {
        this.log(Level.WARN, t);
    }

    public void warn(Object msg, Throwable t) {
        this.log(Level.WARN, msg, t);
    }

    public boolean error() {
        return currentLogLevel.isEnabledFor(Level.ERROR);
    }

    public void error(Object ... items) {
        this.log(Level.ERROR, items);
    }

    public void error(Object msg) {
        this.log(Level.ERROR, msg);
    }

    public void error(Throwable t) {
        this.log(Level.ERROR, t);
    }

    public void error(Object msg, Throwable t) {
        this.log(Level.ERROR, msg, t);
    }

    public String getName() {
        return this.loggerName;
    }

    public void printCurrentStackTrace(Level level, String msg) {
        this.log(level, msg, new Throwable());
    }

    public void printCurrentStackTrace(int level, String msg) {
        this.log(Level.fromLog4jLevel(level), msg, new Throwable());
    }

    public void printCurrentStackTrace(String msg) {
        this.printCurrentStackTrace(Level.DEBUG, msg);
    }

    @Deprecated
    public void rolloverPluginLog() {
    }

    public static boolean isTraceEnabled() {
        return currentLogLevel.isEnabledFor(Level.TRACE);
    }

    public static enum Level {
        OFF(Integer.MAX_VALUE),
        FATAL(50000),
        ERROR(40000),
        WARN(30000),
        INFO(20000),
        DEBUG(10000),
        TRACE(5000),
        ALL(Integer.MIN_VALUE);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public boolean isEnabledFor(Level level) {
            if (Level.isDisabled(level.level)) {
                return false;
            }
            return level.isGreaterOrEqual(this);
        }

        public static boolean isDisabled(int level) {
            return PDLoggerJhost.currentLogLevel.level > level;
        }

        public boolean isGreaterOrEqual(Level r) {
            return this.level >= r.level;
        }

        public static Level fromLog4jLevel(int level) {
            switch (level) {
                case 5000: {
                    return TRACE;
                }
                case 10000: {
                    return DEBUG;
                }
                case 50000: {
                    return FATAL;
                }
                case 20000: {
                    return INFO;
                }
                case 30000: {
                    return WARN;
                }
                case 0x7FFFFFFF: {
                    return OFF;
                }
                case -2147483648: {
                    return ALL;
                }
                case 40000: {
                    return ERROR;
                }
            }
            return ERROR;
        }
    }
}

