/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.core.model.data;

import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractImmutableProperties
implements ImmutableProperties {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLoggerJhost logger = PDLoggerJhost.get(AbstractImmutableProperties.class);
    private final HashMap<String, String> propertyValues;

    public AbstractImmutableProperties(HashMap<String, String> rawProperties) {
        Objects.requireNonNull(rawProperties, "Must provide non-null rawProperties");
        this.propertyValues = (HashMap)rawProperties.clone();
    }

    @Override
    public Set<String> getAllPropertyKeys() {
        Map<String, String> allPropertyNames = this.getAllPropertyNames();
        return allPropertyNames == null ? null : allPropertyNames.keySet();
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.propertyValues.keySet();
    }

    @Override
    public int getPropertyCount() {
        return this.propertyValues.size();
    }

    @Override
    public String getPropertyValue(String key) {
        return this.propertyValues.get(key);
    }

    @Override
    public String getPropertyName(String key) {
        Map<String, String> allPropertyNames = this.getAllPropertyNames();
        return allPropertyNames == null ? null : allPropertyNames.get(key);
    }

    @Override
    public Map<String, String> getNamedProperties() {
        HashMap<String, String> namedProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> property : this.propertyValues.entrySet()) {
            String propertyName = this.getPropertyName(property.getKey());
            if (propertyName != null && propertyName.length() > 0) {
                namedProperties.put(propertyName, property.getValue());
                continue;
            }
            logger.warn((Object)("Unknown property key; using key as property name: " + property.getKey()));
            namedProperties.put(property.getKey(), property.getValue());
        }
        return namedProperties;
    }

    protected abstract Map<String, String> getAllPropertyNames();

    public String toString() {
        return String.valueOf(this.getClass()) + ": " + String.valueOf(this.propertyValues);
    }
}

