/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.core.model;

import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.IDelegatingHost;
import com.ibm.pdtools.common.component.jhost.core.Messages;
import com.ibm.pdtools.common.component.jhost.core.model.IHostSystem;
import com.ibm.pdtools.common.component.jhost.core.model.IHostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.PDPlatformObjectJhost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.BidiCharsetUtils;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class PDHostJhost
extends PDPlatformObjectJhost
implements IPDHost,
Comparable<IPDHost>,
Cloneable,
IEntityEventDispatcher<IPDHost>,
IHostType {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Object PROPERTY_HOST_PORT = new Object();
    private static final Object PROPERTY_DESCRIPTION = new Object();
    private static final Object PROPERTY_CODE_PAGE = new Object();
    private static final Object PROPERTY_HOST_TYPE = new Object();
    private static final Object PROPERTY_SERVER_PROPERTIES = new Object();
    private static final Object PROPERTY_SERVER_VERSION = new Object();
    private String installedApars;
    private static final String PROPERTY_LOGIN = "PROPERTY_LOGIN";
    private static final Pattern VALID_REGEX = Pattern.compile(".+");
    private static final int MIN_PORT_NUM = 0;
    private static final int MAX_PORT_NUM = 65535;
    private String hostID = "";
    private String hostName = "";
    private int portNumber = -1;
    private String customCodePage = null;
    private String description = "";
    private HostType hostType = HostType.getDefaultHostType();
    private String bidiFormat = "";
    private final EntityEventDispatcher<IPDHost> eventDispatcher = new EntityEventDispatcher<PDHostJhost>(this);
    private Map<String, String> ipvServerProps = new HashMap<String, String>();
    private List<IHostSystem> hostExtends = new ArrayList<IHostSystem>();
    private IDelegatingHost delegatingHost = null;
    @Deprecated
    private IHostSystem FMHostSystem = null;

    private static boolean isValidHost(String hostName) {
        if (hostName == null) {
            return false;
        }
        return VALID_REGEX.matcher(hostName).matches();
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    @Deprecated
    public static PDHostJhost create(String hostID, String hostName, int port) {
        return new PDHostJhost(hostID, hostName, port);
    }

    public PDHostJhost() {
    }

    public PDHostJhost(String hostID, String hostName, int port) {
        if (hostID == null) {
            throw new IllegalArgumentException("Please provide a non-null hostID.");
        }
        if (!PDHostJhost.isValidHost(hostName)) {
            throw new IllegalArgumentException(hostName);
        }
        if (!PDHostJhost.isValidPort(port)) {
            throw new IllegalArgumentException(Integer.toString(port));
        }
        this.hostID = hostID;
        this.hostName = hostName;
        this.portNumber = port;
        this.setSystem(this);
    }

    public EntityEventDispatcher<IPDHost> getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public String getConnectionName() {
        return this.hostName + "-" + this.portNumber;
    }

    public String toString() {
        return this.getConnectionName();
    }

    @Override
    public int compareTo(IPDHost o) {
        return this.getHostID().compareTo(o.getHostID());
    }

    public int hashCode() {
        return this.getHostID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PDHostJhost) {
            PDHostJhost otherCommHost = (PDHostJhost)obj;
            return this.getHostID().equals(otherCommHost.getHostID());
        }
        return false;
    }

    public static boolean xnorDeligated(IPDHost obj1, IPDHost obj2) {
        if (obj1 instanceof PDHostJhost && obj2 instanceof PDHostJhost) {
            IDelegatingHost dHost1 = obj1.getDelegatingHost();
            IDelegatingHost dHost2 = obj2.getDelegatingHost();
            if (dHost1 == null && dHost2 == null) {
                return true;
            }
            if (dHost1 != null && dHost2 != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public AuthDetails getLogin(boolean forceLoginDialog) throws InterruptedException {
        return this.getLogin(forceLoginDialog, null);
    }

    @Override
    @Deprecated
    public AuthDetails getLogin(boolean forceLoginDialog, IHowIsGoing monitor) throws InterruptedException {
        return null;
    }

    @Override
    public void setHostID(String hostID) {
        if (hostID == null) {
            throw new IllegalArgumentException("Must provide a non-null hostID.");
        }
        this.hostID = hostID;
    }

    @Override
    public String getHostID() {
        return this.hostID;
    }

    @Override
    public void setHostName(String hostName) {
        if (!PDHostJhost.isValidHost(hostName)) {
            throw new IllegalArgumentException(hostName);
        }
        this.hostName = hostName;
        this.eventDispatcher.fireChangedEvent(PDHostJhost.getPropertyHostPort());
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setPort(int portNumber) {
        if (!PDHostJhost.isValidPort(portNumber)) {
            throw new IllegalArgumentException(Integer.toString(portNumber));
        }
        this.portNumber = portNumber;
        this.eventDispatcher.fireChangedEvent(PDHostJhost.getPropertyHostPort());
    }

    @Override
    public int getPort() {
        return this.portNumber;
    }

    @Override
    public void setDescription(String description) {
        if (description == null) {
            this.description = "";
        }
        this.description = description;
        this.eventDispatcher.fireChangedEvent(PROPERTY_DESCRIPTION);
    }

    @Override
    public String getBidiFormat() {
        return this.bidiFormat;
    }

    @Override
    public void setBidiFormat(String bidiFormat) {
        if (bidiFormat == null) {
            this.bidiFormat = "";
        }
        this.bidiFormat = bidiFormat;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isSecured() {
        return "Y".equals(this.getIPVServerProperties().get("SSL"));
    }

    public PDHostJhost clone() {
        try {
            return (PDHostJhost)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Clone of host failed", e);
        }
    }

    @Override
    public void addListener(EListener<EntityEvent<IPDHost>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    @Override
    public void removeListener(EListener<EntityEvent<IPDHost>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    @Override
    public void setCodePage(String customCodePage) {
        if (customCodePage == null) {
            this.customCodePage = null;
            this.eventDispatcher.fireChangedEvent(PROPERTY_CODE_PAGE);
            return;
        }
        String parsedCodePage = EncodingUtils.parseCodePage(customCodePage);
        if (!EncodingUtils.isValidCodePage(parsedCodePage)) {
            throw new IllegalArgumentException((parsedCodePage == null ? "null" : parsedCodePage) + " is not supported by this JVM.");
        }
        this.customCodePage = parsedCodePage;
        this.eventDispatcher.fireChangedEvent(PROPERTY_CODE_PAGE);
    }

    @Override
    public String getCustomCodePage() {
        return this.customCodePage;
    }

    @Override
    public String getCodePage() {
        if (this.customCodePage != null) {
            return this.getCustomCodePage();
        }
        return this.getHostType().getDefaultEncoding();
    }

    @Override
    public String getCommunicationCodePage() {
        String encoding = this.getCodePage().toLowerCase();
        if (BidiCharsetUtils.isBidiCharsetName(encoding)) {
            return encoding;
        }
        return this.getHostType().getCommunicationEncoding();
    }

    @Override
    public void setIPVServerProperties(Map<String, String> props) {
        boolean propChanged = false;
        if (this.ipvServerProps == null || props == null || this.ipvServerProps.size() != props.size()) {
            propChanged = true;
        } else {
            Set<String> keys = props.keySet();
            for (String key : keys) {
                if (this.ipvServerProps.containsKey(key) && this.ipvServerProps.get(key).equals(props.get(key))) continue;
                propChanged = true;
                break;
            }
        }
        if (propChanged) {
            this.ipvServerProps = new HashMap<String, String>(props);
            this.eventDispatcher.fireChangedEvent(PROPERTY_SERVER_PROPERTIES);
            if (PDLoggerJhost.isTraceEnabled()) {
                PDLoggerJhost.get(this.getClass()).trace((Object)this.ipvServerProps);
            }
        }
    }

    @Override
    public Map<String, String> getIPVServerProperties() {
        return Collections.unmodifiableMap(this.ipvServerProps);
    }

    @Override
    public boolean supports(PDFeature feature) {
        for (IHostSystem hostExtend : this.hostExtends) {
            if (!hostExtend.supports(this, feature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IHostSystem getHostWhichSupports(String pdConnectEndpointType) {
        for (IHostSystem hostExtend : this.hostExtends) {
            if (!hostExtend.providesConnectEndpointType(pdConnectEndpointType)) continue;
            return hostExtend;
        }
        return null;
    }

    @Override
    public Result<StringBuffer> executeOnHost(String componentName, String command, IHowIsGoing howIsGoing) throws InterruptedException {
        IHostSystem hostSystem = this.getHostWhichSupports(componentName);
        if (hostSystem != null) {
            return hostSystem.executeOnHost(this, command, howIsGoing);
        }
        Result<StringBuffer> failedResult = new Result<StringBuffer>();
        failedResult.setRC(8);
        failedResult.add(MessageFormat.format(Messages.ConnectionEndpointProviderNotfound, componentName));
        return failedResult;
    }

    @Override
    public Result<StringBuffer> executeOnHost(String command, IHowIsGoing howIsGoing) {
        for (IHostSystem hostExtend : this.hostExtends) {
            Result<StringBuffer> result = hostExtend.executeOnThisHost(this, command, howIsGoing);
            if (result == null) continue;
            return result;
        }
        Result<StringBuffer> failedResult = new Result<StringBuffer>();
        failedResult.setRC(8);
        return failedResult;
    }

    @Override
    public void updateFrom(IPDHost host) {
        int i = 0;
        while (i < this.hostExtends.size()) {
            this.hostExtends.get(i).updateFrom(host.getHostExtends()[i]);
            ++i;
        }
        this.hostID = host.getHostID();
        this.hostName = host.getHostName();
        this.portNumber = host.getPort();
        this.customCodePage = host.getCodePage();
        this.bidiFormat = host.getBidiFormat();
        this.description = host.getDescription();
        this.hostType = host.getHostType();
        this.ipvServerProps = new HashMap<String, String>(this.ipvServerProps);
    }

    @Override
    public void serverVersionChanged() {
        this.eventDispatcher.fireChangedEvent(PROPERTY_SERVER_VERSION);
    }

    @Override
    public HostType getHostType() {
        return this.hostType;
    }

    @Override
    public boolean isLocalHost() {
        return false;
    }

    @Override
    public void setHostType(HostType aType) {
        this.hostType = Objects.requireNonNull(aType, "Must specify a non-null HostType.");
        this.eventDispatcher.fireChangedEvent(PROPERTY_HOST_TYPE);
    }

    @Override
    public void setHostType(String newHostType) {
        if (HostType.validHostType(newHostType)) {
            this.setHostType(HostType.parseHostType(newHostType));
        } else {
            this.setHostType(HostType.getDefaultHostType());
        }
        this.eventDispatcher.fireChangedEvent(PROPERTY_HOST_TYPE);
    }

    @Override
    @Deprecated
    public IHostSystem[] getHostExtends() {
        return this.hostExtends.toArray(new IHostSystem[0]);
    }

    protected List<IHostSystem> getHostExtendsList() {
        return this.hostExtends;
    }

    @Override
    public IHostSystem getHostSystem(String className) {
        for (IHostSystem aHostExtend : this.hostExtends) {
            String hostExtendClass = aHostExtend.getClass().getCanonicalName();
            if (!hostExtendClass.endsWith("." + className) && !hostExtendClass.endsWith("." + className + "Jhost")) continue;
            return aHostExtend;
        }
        return null;
    }

    @Override
    public String translate(String str) {
        String codePage = null;
        String communicationCodePage = null;
        codePage = this.getCodePage();
        communicationCodePage = this.getHostType().getCommunicationEncoding();
        if (codePage != null && !communicationCodePage.equals(codePage)) {
            try {
                return new String(str.getBytes(communicationCodePage), codePage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean confirmRemoveHost() {
        for (IHostSystem aHostExtend : this.hostExtends) {
            if (aHostExtend.confirmRemoveHost(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeHost() {
        for (IHostSystem aHostExtend : this.hostExtends) {
            if (aHostExtend.removeHost(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public void setAHostExtend(IHostSystem aHostExtent) {
        if (!this.hostExtends.contains(aHostExtent)) {
            this.hostExtends.add(aHostExtent);
        }
    }

    @Override
    @Deprecated
    public IHostSystem getFMHostSystem() {
        if (this.FMHostSystem == null) {
            this.FMHostSystem = this.getHostSystem("FMHost");
        }
        return this.FMHostSystem;
    }

    @Override
    @Deprecated
    public void setFMHostSystem(IHostSystem fMHostSystem) {
        this.FMHostSystem = fMHostSystem;
    }

    public static Object getPropertyHostPort() {
        return PROPERTY_HOST_PORT;
    }

    @Deprecated
    public static IPDHost findPDHost(String hostName, int portNo) {
        List pdHostList = RegistryLocator.instance().getHostRegistry().all();
        for (IPDHost pdHost : pdHostList) {
            if (pdHost.getPort() != portNo || !pdHost.getHostName().equals(hostName)) continue;
            return pdHost;
        }
        return null;
    }

    @Deprecated
    public static IPDHost findPDHostIgnoreHostNameCase(String hostName, int portNo) {
        List pdHostList = RegistryLocator.instance().getHostRegistry().all();
        for (IPDHost pdHost : pdHostList) {
            if (pdHost.getPort() != portNo || !pdHost.getHostName().equalsIgnoreCase(hostName)) continue;
            return pdHost;
        }
        return null;
    }

    public static List<IPDHost> findPDHosts(String hostName, int portNo) {
        return PDHostJhost.findPDHosts(hostName, portNo, false);
    }

    public static List<IPDHost> findPDHosts(String hostName, int portNo, boolean ignoreCase) {
        List pdHostList = RegistryLocator.instance().getHostRegistry().all();
        ArrayList<IPDHost> hosts = new ArrayList<IPDHost>();
        for (IPDHost pdHost : pdHostList) {
            if (pdHost.getPort() != portNo || !(ignoreCase ? pdHost.getHostName().equalsIgnoreCase(hostName) : pdHost.getHostName().equals(hostName))) continue;
            hosts.add(pdHost);
        }
        return hosts;
    }

    public static IPDHost findPDHost(String hostId) {
        List pdHostList = RegistryLocator.instance().getHostRegistry().all();
        for (IPDHost pdHost : pdHostList) {
            if (!pdHost.getHostID().equals(hostId)) continue;
            return pdHost;
        }
        return null;
    }

    @Override
    public void setInstalledApars(String installedApars) {
        if (installedApars != null) {
            this.installedApars = installedApars;
        }
    }

    @Override
    public boolean isAparInstalled(String aparNo) {
        return aparNo != null && !aparNo.trim().isEmpty() && this.installedApars != null && this.installedApars.indexOf(aparNo) >= 0;
    }

    @Override
    public String getFormattedUserName() throws InterruptedException {
        Object user = "";
        AuthDetails details = this.getLogin(false, null);
        if (details != null) {
            user = details.getUsername();
            if (user == null) {
                user = "";
            }
            if (!((String)user).isEmpty()) {
                user = (String)user + "@";
            }
        }
        return user;
    }

    @Override
    public String getFullHostName() {
        String description = this.getDescription().isEmpty() ? "" : "(" + this.getDescription() + ") ";
        try {
            return description + this.getFormattedUserName() + this.getConnectionName();
        }
        catch (InterruptedException e) {
            return description + "[UserNotFound]@" + this.getConnectionName();
        }
    }

    @Override
    public boolean isAparInfoLoaded() {
        return this.installedApars != null;
    }

    @Override
    public boolean isSameSystem(IPDHost other) {
        return this.getHostName() != null && this.getHostName().equals(other.getHostName()) && this.getPort() == other.getPort();
    }

    @Override
    public boolean isSameSecurity(IPDHost other) {
        return this.isSecured() == other.isSecured();
    }

    @Override
    public IDelegatingHost getDelegatingHost() {
        return this.delegatingHost;
    }

    @Override
    public void setDelegatingHost(IDelegatingHost delegatingHost) {
        this.delegatingHost = delegatingHost;
    }

    public static boolean doAllHostsHaveSameCodePage(List<IPDHost> findPDHosts) {
        String firstCp = findPDHosts.get(0).getCodePage();
        for (IPDHost h : findPDHosts) {
            if (h.getCodePage().equals(firstCp)) continue;
            return false;
        }
        return true;
    }
}

