/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.IDelegatingHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.BidiCharsetUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HostDetails {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String KEY_SSL = "SSL";
    public static final String KEY_ATTLS = "ATTLS";
    public static final String KEY_SERVERVERSION = "SERVERVERSION";
    public static final String KEY_SYSNAME = "SYSNAME";
    public static final String KEY_NODENAME = "NODENAME";
    public static final String KEY_RELESE = "RELEASE";
    public static final String KEY_VERSION = "VERSION";
    public static final String KEY_MACHINE = "MACHINE";
    public static final String YES_MESSAGE = "Y";
    public static final String KEY_SERVER_JOB_NAME = "SERVERNAME";
    public static final String KEY_AUTH = "AUTH";
    public static final String KEY_ERROR = "ERROR";
    public static final String KEY_PROTOCOL = "PROTOCOL";
    public static final String KEY_PASSTK = "PASSTK";
    public static final String DEFAULT_PROTOCOL = "TLSv1.1";
    public static final String SERVER_ERROR_MSG_INVALID_PWD = "'INVALID PASSWORD'";
    public static final String SERVER_ERROR_MSG_EXPIRED_PWD = "'EXPIRED PASSWORD'";
    public static final String SERVER_ERROR_MSG_INVALID_NEW_PWD = "'NEW PASSWORD INVALID'";
    public static final String SERVER_ERROR_MSG_UNKNOWN_USER = "'UNKNOWN USER'";
    public static final String SERVER_ERROR_SAF_FAILURE = "'SAF FAILURE'";
    private String hostID = null;
    private String hostname = null;
    private int portNumber = -1;
    private String description = null;
    private String hostDefaultEncoding = null;
    private HostType hostType = HostType.getDefaultHostType();
    private String bidiFormat = null;
    private Map<String, String> serverProps = null;
    private IPDHost pdHost = null;

    @Deprecated
    public HostDetails(String hostID, String hostname, int portNumber, String description, String defaultEncoding, String hostType) {
        this(hostID, hostname, portNumber, description, defaultEncoding, HostType.getDefaultHostType());
        if (HostType.validHostType(hostType)) {
            this.hostType = HostType.parseHostType(hostType);
        }
    }

    public HostDetails(String hostID, String hostname, int portNumber, String description, String defaultEncoding, HostType hostType) {
        this.hostID = hostID;
        this.hostname = hostname;
        this.portNumber = portNumber;
        this.description = description != null ? description : "";
        this.hostDefaultEncoding = defaultEncoding;
        Objects.requireNonNull(hostType, "Please specify a non-null hostType.");
        if (this.hostDefaultEncoding == null || this.hostDefaultEncoding.isEmpty()) {
            this.hostDefaultEncoding = hostType.getDefaultEncoding();
        }
        this.hostType = hostType;
        this.serverProps = new HashMap<String, String>();
    }

    public HostDetails(String hostID, String hostname, int portNumber, String description, String defaultEncoding, HostType hostType, String bidiFormat) {
        this(hostID, hostname, portNumber, description, defaultEncoding, hostType);
        this.bidiFormat = bidiFormat;
    }

    public HostDetails(IPDHost pdHost) {
        this(Objects.requireNonNull(pdHost, "Please provide a non-null pdhost.").getHostID(), pdHost.getHostName(), pdHost.getPort(), pdHost.getDescription(), pdHost.getCodePage(), Objects.requireNonNull(pdHost.getHostType(), "Please specify a non-null hostType."), pdHost.getBidiFormat());
        this.pdHost = pdHost;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = description;
    }

    public String getBidiFormat() {
        return this.bidiFormat;
    }

    @Deprecated
    public void setBidiFormat(String bidiFormat) {
        this.bidiFormat = bidiFormat;
    }

    public String getHostDefaultEncoding() {
        return this.hostDefaultEncoding;
    }

    @Deprecated
    public void setHostDefaultEncoding(String hostDefaultEncoding) {
        this.hostDefaultEncoding = hostDefaultEncoding;
    }

    public HostType getHostType() {
        return this.hostType;
    }

    @Deprecated
    public void setHostType(HostType hostType) {
        this.hostType = hostType;
    }

    @Deprecated
    public void setHostType(String hostType) {
        this.hostType = HostType.parseHostType(hostType);
    }

    public String getHostID() {
        return this.hostID;
    }

    @Deprecated
    public void setHostID(String hostID) {
        this.hostID = hostID;
    }

    public String getHostname() {
        return this.hostname;
    }

    @Deprecated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPortNumber(AuthDetails authDetails) {
        IDelegatingHost delegatingHost;
        if (this.portNumber == 0 && authDetails != null && this.pdHost != null && (delegatingHost = this.pdHost.getDelegatingHost()) != null) {
            this.portNumber = delegatingHost.getPDPort(authDetails);
            if (this.portNumber != 0) {
                this.pdHost.setPort(this.portNumber);
            }
        }
        return this.portNumber;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    @Deprecated
    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public boolean isSecured() {
        String value = this.serverProps.get(KEY_SSL);
        return YES_MESSAGE.equals(value);
    }

    public boolean isUsingATTLS() {
        String value = this.serverProps.get(KEY_ATTLS);
        return YES_MESSAGE.equals(value);
    }

    public String getConnectionName() {
        return this.hostname + ":" + this.portNumber;
    }

    public String toString() {
        return this.hostname + ":" + this.portNumber;
    }

    public String getProtocol() {
        return this.serverProps.get(KEY_PROTOCOL);
    }

    public Map<String, String> getServerProperties() {
        return Collections.unmodifiableMap(this.serverProps);
    }

    public void setServerProperties(Map<String, String> props) {
        this.serverProps = new HashMap<String, String>(props);
    }

    public String getCommunicationCodePage() {
        String encoding;
        if (this.hostDefaultEncoding != null && BidiCharsetUtils.isBidiCharsetName(encoding = this.hostDefaultEncoding.toLowerCase())) {
            return encoding;
        }
        return this.getHostType().getCommunicationEncoding();
    }

    public IPDHost getHost() {
        return this.pdHost;
    }

    public void setHost(IPDHost host) {
        this.pdHost = host;
    }
}

