/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util.sax;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class PDSaxParser {
    private static final PDLogger logger = PDLogger.get(PDSaxParser.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parse(URL fileName, DefaultHandler handler) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                InputStream inputStream = fileName.openStream();
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        InputSource is = new InputSource(reader);
                        is.setEncoding(StandardCharsets.UTF_8.name());
                        SAXParser saxParser = PDSaxParser.getParser();
                        if (saxParser != null) {
                            saxParser.parse(is, handler);
                        }
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("An IO Exception occurred  while parsing: ", e);
            return;
        }
        catch (SAXException e) {
            logger.error("A parsing error occurred while reading lookup data: ", e);
        }
    }

    private static SAXParser getParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            logger.error("The sax parser could not be created: ", e);
            return null;
        }
    }
}

