/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.eclipse.ui.WorkbenchException;

public class PDFileUtils {
    private static final PDLogger logger = PDLogger.get(PDFileUtils.class);

    public static <T> T readFile(File file, PDUTF8Reader<T> callback) throws IOException, WorkbenchException {
        Objects.requireNonNull(file, "Must provide a non-null file.");
        Objects.requireNonNull(callback, "Must provide a non-null callback.");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                return callback.read(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | WorkbenchException e) {
            logger.error(e);
            throw e;
        }
    }

    public static void writeFile(File file, StringWriter sw) throws IOException {
        Objects.requireNonNull(file, "Please specify a non-null File file");
        Objects.requireNonNull(sw, "Please specify a non-null StringWriter sw");
        PDFileUtils.writeFile(file, sw.toString());
    }

    public static void writeFile(File file, String str) throws IOException {
        Objects.requireNonNull(file, "Please specify a non-null File file");
        Objects.requireNonNull(str, "Please specify a non-null String str");
        try {
            Files.write(file.toPath(), str.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error(e);
            throw e;
        }
    }

    public static interface PDUTF8Reader<T> {
        public T read(Reader var1) throws WorkbenchException;
    }

    public static interface PDUTF8Writer {
        public void write(Writer var1) throws WorkbenchException;
    }
}

