/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.core.util.PDBidiTextDirection;
import com.ibm.pdtools.common.component.core.util.PDBidiTextLayout;
import java.util.Objects;

public class PDBidiFormat {
    private PDBidiTextDirection direction = PDBidiTextDirection.LeftToRight;
    private PDBidiTextLayout layout = PDBidiTextLayout.Logical;

    public PDBidiFormat() {
    }

    public PDBidiFormat(PDBidiTextDirection direction, PDBidiTextLayout layout) {
        this.setDirection(direction);
        this.setLayout(layout);
    }

    public static PDBidiFormat parse(String s) {
        PDBidiFormat pdBidiFormat = new PDBidiFormat();
        if (s == null || s.trim().isEmpty()) {
            PDLogger.get(PDBidiFormat.class).trace("Null bidi format specified; returning default format.");
            return pdBidiFormat;
        }
        if (s.toLowerCase().contains("RightToLeft".toLowerCase())) {
            pdBidiFormat.setDirection(PDBidiTextDirection.RightToLeft);
        }
        if (s.toLowerCase().contains("Visual".toLowerCase())) {
            pdBidiFormat.setLayout(PDBidiTextLayout.Visual);
        }
        return pdBidiFormat;
    }

    public PDBidiTextDirection getDirection() {
        return this.direction;
    }

    public PDBidiTextLayout getLayout() {
        return this.layout;
    }

    public PDBidiFormat setDirection(PDBidiTextDirection bidiDirection) {
        if (bidiDirection != null) {
            this.direction = bidiDirection;
        } else {
            PDLogger.get(this.getClass()).trace("WARNING: null direction specified - it is being ignored.");
        }
        return this;
    }

    public PDBidiFormat setLayout(PDBidiTextLayout layout) {
        this.layout = Objects.requireNonNull(layout);
        return this;
    }

    public String toString() {
        return PDBiDiHelpers.getBidiFormat(this.layout.name(), this.direction.name());
    }
}

