/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.bidi.BidiUtils;
import com.ibm.pdtools.common.component.bidi.ui.VisualField;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.BidiCharsetUtils;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PDBiDiHelpers {
    private static final PDLogger logger = PDLogger.get(PDBiDiHelpers.class);

    private PDBiDiHelpers() {
    }

    public static boolean isResourceEncodingBiDi(IZRL zrl) {
        Objects.requireNonNull(zrl, "Please provide non-null zrl.");
        return BidiCharsetUtils.isBidiCharsetName((String)zrl.getPersistentProperty("encoding"));
    }

    public static boolean isRTLRequired(IZRL zrl) {
        Objects.requireNonNull(zrl, "Please provide non-null zrl.");
        if (PDBiDiHelpers.isResourceEncodingBiDi(zrl)) {
            return BidiUtils.isBidiRTLSupportRequired((String)zrl.getPersistentProperty("bidiFormat"));
        }
        return false;
    }

    public static boolean isBidiVisualSupportRequired(IZRL zrl) {
        Objects.requireNonNull(zrl, "Please provide non-null zrl.");
        if (PDBiDiHelpers.isResourceEncodingBiDi(zrl)) {
            return BidiUtils.isBidiVisualSupportRequired((String)zrl.getPersistentProperty("bidiFormat")) && Util.isWindows();
        }
        return false;
    }

    public static String ifBidiRequiredAddMarkersToString(IZRL zrl, String value) {
        Objects.requireNonNull(zrl, "Please provide non-null zrl.");
        if (PDBiDiHelpers.isResourceEncodingBiDi(zrl)) {
            return BidiUtils.addMarkersToStr((String)value, (boolean)PDBiDiHelpers.isBidiVisualSupportRequired(zrl), (boolean)PDBiDiHelpers.isRTLRequired(zrl));
        }
        return value;
    }

    public static String updateFieldValue(IZRL zrl, AtomicReference<VisualField> visualFld, String string) {
        Objects.requireNonNull(zrl, "Please provide non-null zrl.");
        return string;
    }

    private static void doSetValue(VisualField visualFld, Text text2, String value, boolean isRtl) {
        Objects.requireNonNull(text2, "Please provide non-null text.");
        Objects.requireNonNull(value, "Please provide non-null value.");
        if (visualFld != null) {
            value = value.substring(1);
            if (visualFld.isPushMode()) {
                text2.setText(VisualField.reverseStr((String)value));
            } else {
                text2.setText(value);
            }
        } else {
            text2.setText(value);
        }
    }

    private static String doGetValue(VisualField visualFld, String value, boolean isRtl) {
        Objects.requireNonNull(value, "Please provide non-null value.");
        if (visualFld != null) {
            if (visualFld.isPushMode()) {
                return VisualField.reverseStr((String)value);
            }
            return value;
        }
        return value;
    }

    public static void prepareTextForEdit(AtomicReference<VisualField> visualFld, IZRL resource, String rowText, Text text2) {
        Objects.requireNonNull(visualFld, "Must provide a non-null visualField.");
        Objects.requireNonNull(resource, "Must provide a non-null resource.");
        Objects.requireNonNull(rowText, "Must provide a non-null rowText.");
        Objects.requireNonNull(text2, "Must provide a non-null text.");
        if (PDBiDiHelpers.isResourceEncodingBiDi(resource)) {
            if (BidiCharsetUtils.doesTextContainBidiCharacters((String)rowText)) {
                BidiUtil.setKeyboardLanguage((int)1);
            } else {
                BidiUtil.setKeyboardLanguage((int)0);
            }
            if (PDBiDiHelpers.isBidiVisualSupportRequired(resource) && BidiUtils.startsWithMarker((String)rowText)) {
                visualFld.set(new VisualField(text2));
                if (PDBiDiHelpers.isRTLRequired(resource)) {
                    visualFld.get().switchWidgetDir(false);
                }
            }
            text2.setText(rowText);
        } else {
            text2.setText(rowText);
        }
    }

    public static String getBidiFormat(String textLayout, String textDirection) {
        String textLayoutPropStr = "Logical";
        if (Messages.Connection_TEXT_LAYOUT_VISUAL.equals(textLayout)) {
            textLayoutPropStr = "Visual";
        }
        String textDirectionPropStr = "LeftToRight";
        if (Messages.Connection_TEXT_DIRECTION_RTL.equals(textDirection)) {
            textDirectionPropStr = "RightToLeft";
        }
        return textLayoutPropStr + textDirectionPropStr;
    }

    public static void enableBidiCombos(String encoding, Combo layoutCombo, Combo directionCombo, boolean initial) {
        Objects.requireNonNull(encoding, "Must provide a non-null encoding.");
        Objects.requireNonNull(layoutCombo, "Must provide a non-null layoutCombo.");
        Objects.requireNonNull(directionCombo, "Must provide a non-null directionCombo.");
        encoding = encoding.toLowerCase();
        if (PDBiDiHelpers.isBidiCharset(encoding)) {
            layoutCombo.setEnabled(true);
            directionCombo.setEnabled(true);
            if (!initial) {
                layoutCombo.select(1);
            } else {
                PDBiDiHelpers.setComboSaver(layoutCombo, directionCombo, true);
            }
        } else {
            layoutCombo.select(0);
            directionCombo.select(0);
            layoutCombo.setEnabled(false);
            directionCombo.setEnabled(false);
            if (initial) {
                PDBiDiHelpers.setComboSaver(layoutCombo, directionCombo, false);
            }
        }
    }

    private static void setComboSaver(Combo layoutCombo, Combo directionCombo, boolean enable) {
        Objects.requireNonNull(layoutCombo, "Must provide a non-null layoutCombo.");
        Objects.requireNonNull(directionCombo, "Must provide a non-null directionCombo.");
        ComboValueSaver textLayoutSaver = ComboValueSaver.getInstance(layoutCombo);
        ComboValueSaver textDirSaver = ComboValueSaver.getInstance(directionCombo);
        if (textLayoutSaver != null) {
            textLayoutSaver.setDoRestore(enable);
        }
        if (textDirSaver != null) {
            textDirSaver.setDoRestore(enable);
        }
    }

    public static String translateIfBidiRequired(IZRL zrl, String string, boolean sendToHost) {
        Objects.requireNonNull(zrl, "Must provide a non-null zrl.");
        Objects.requireNonNull(string, "Must provide a non-null string.");
        String encoding = zrl.getPersistentProperty("encoding");
        if (encoding != null && BidiCharsetUtils.isBidiCharsetName((String)encoding)) {
            String bidiFormat = zrl.getPersistentProperty("bidiFormat");
            if (bidiFormat != null) {
                string = BidiUtils.bidiTransform((String)string, (String)BidiUtils.getInputFormat((String)bidiFormat, (boolean)sendToHost), (String)BidiUtils.getOutputFormat((String)bidiFormat, (boolean)sendToHost));
            } else {
                logger.info(MessageFormat.format("Using a BiDi codepage {0} but a BiDi format has not been specified.", encoding));
            }
        }
        return string;
    }

    public static boolean isBidiCharset(String encoding) {
        return !encoding.trim().isEmpty() && BidiCharsetUtils.isBidiCharsetName((String)encoding) || encoding.startsWith("cp420") || encoding.startsWith("cp424");
    }

    public static String reverseIfVisualRTLRequired(IZRL resource, String value) {
        Objects.requireNonNull(resource, "Must provide a non-null resource.");
        if (PDBiDiHelpers.isBidiVisualSupportRequired(resource) && PDBiDiHelpers.isRTLRequired(resource) && value != null) {
            return BidiUtils.reverseHexaRepresentation((String)value);
        }
        return value;
    }

    public static void ifNotVisualAndRTLRequiredUseRTLOrientation(IZRL zrl, Control control) {
        int orientation;
        Objects.requireNonNull(zrl, "Must provide a non-null zrl.");
        Objects.requireNonNull(control, "Must provide a non-null control.");
        int n = orientation = !PDBiDiHelpers.isBidiVisualSupportRequired(zrl) && PDBiDiHelpers.isRTLRequired(zrl) ? 0x4000000 : 0x2000000;
        if (orientation != control.getOrientation()) {
            control.setOrientation(orientation);
        }
    }
}

