/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public enum IResourceUtils {
    UTILITY_CLASS;

    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger;

    static {
        logger = PDLogger.get(IResourceUtils.class);
    }

    private static boolean doBoolean(final Callable<?> c) {
        Boolean result = (Boolean)PDSafeRunner.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                c.call();
                return true;
            }
        });
        if (result == null) {
            return false;
        }
        return result;
    }

    @Deprecated
    public static boolean refresh(final IFile file, final int depth, final IProgressMonitor monitor) {
        return IResourceUtils.doBoolean(new Callable<Void>(){

            @Override
            public Void call() throws CoreException {
                file.refreshLocal(depth, monitor);
                return null;
            }
        });
    }

    public static boolean delete(final IFile file, final boolean force, final IProgressMonitor monitor) {
        return IResourceUtils.doBoolean(new Callable<Void>(){

            @Override
            public Void call() throws CoreException {
                file.delete(force, monitor);
                return null;
            }
        });
    }

    public static boolean createLink(final IFile file, final Path path, final int updateFlags, final IProgressMonitor monitor) {
        return IResourceUtils.doBoolean(new Callable<Void>(){

            @Override
            public Void call() throws CoreException {
                file.createLink((IPath)path, updateFlags, monitor);
                return null;
            }
        });
    }

    public static boolean create(final IProject project, final IProgressMonitor monitor) {
        return IResourceUtils.doBoolean(new Callable<Void>(){

            @Override
            public Void call() throws CoreException {
                project.create(monitor);
                return null;
            }
        });
    }

    public static boolean open(final IProject project, final IProgressMonitor monitor) {
        return IResourceUtils.doBoolean(new Callable<Void>(){

            @Override
            public Void call() throws CoreException {
                project.open(monitor);
                return null;
            }
        });
    }

    public static boolean setHidden(final IProject project, final boolean hidden) {
        return IResourceUtils.doBoolean(new Callable<Void>(){

            @Override
            public Void call() throws CoreException {
                project.setHidden(hidden);
                return null;
            }
        });
    }

    @Deprecated
    public static boolean createFolderIfNotExist(IFolder folder) {
        return IResourceUtils.createFolderIfNotExist(folder, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean createFolderIfNotExist(final IFolder folder, final IProgressMonitor monitor) {
        Objects.requireNonNull(folder, "Please specify a non-null folder.");
        return IResourceUtils.doBoolean(new Callable<Void>(){

            @Override
            public Void call() throws CoreException {
                if (!folder.exists()) {
                    folder.create(true, true, monitor);
                }
                return null;
            }
        });
    }

    public static IFile getFile(IProject project, String file) {
        if (project != null) {
            return project.getFile(file);
        }
        return null;
    }

    public static IFolder getFolder(IProject project, String folder) {
        if (project != null) {
            return project.getFolder(folder);
        }
        return null;
    }

    @Deprecated
    public static boolean deleteIResource(IResource resource, boolean force, boolean keepHistory, IProgressMonitor monitor) {
        return IResourceUtils.deleteIResource(resource, force, keepHistory, monitor, true);
    }

    public static boolean deleteIResource(IResource resource, boolean force, boolean keepHistory, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(resource, "Must provide a non-null file.");
        try {
            if (resource instanceof IFile) {
                return IResourceUtils.deleteIFile((IFile)resource, force, keepHistory, monitor, refresh);
            }
            if (resource instanceof IFolder) {
                return IResourceUtils.deleteIFolder((IFolder)resource, force, keepHistory, monitor, refresh);
            }
            resource.delete(force, monitor);
            return true;
        }
        catch (CoreException e) {
            logger.error("Error occurred when attempting to delete file: " + String.valueOf(resource), e);
            return false;
        }
    }

    @Deprecated
    public static boolean deleteIFile(IFile file, boolean force, boolean keepHistory, IProgressMonitor monitor) {
        return IResourceUtils.deleteIFile(file, force, keepHistory, monitor, true);
    }

    public static boolean deleteIFile(IFile file, boolean force, boolean keepHistory, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(file, "Must provide a non-null file.");
        try {
            if (refresh) {
                IResourceUtils.refreshLocalIResource((IResource)file, 0, monitor);
            }
            if (IResourceUtils.existsCaseInsensitive((IResource)file, monitor, refresh)) {
                file.delete(force, keepHistory, monitor);
                return true;
            }
        }
        catch (CoreException e) {
            logger.error("Error occurred when attempting to delete file: " + String.valueOf(file), e);
        }
        return false;
    }

    @Deprecated
    public static boolean deleteIFolder(IFolder folder, boolean force, boolean keepHistory, IProgressMonitor monitor) {
        return IResourceUtils.deleteIFolder(folder, force, keepHistory, monitor, true);
    }

    public static boolean deleteIFolder(IFolder folder, boolean force, boolean keepHistory, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(folder, "Must provide a non-null folder.");
        try {
            if (refresh) {
                IResourceUtils.refreshLocalIResource((IResource)folder, 1, monitor);
            }
            if (IResourceUtils.existsCaseInsensitive((IResource)folder, monitor, refresh)) {
                folder.delete(force, keepHistory, monitor);
                return true;
            }
        }
        catch (CoreException e) {
            logger.error("Error occurred when attempting to delete folder: " + String.valueOf(folder), e);
        }
        return false;
    }

    public static boolean refreshLocalIResource(IResource resource, int depth, IProgressMonitor monitor) {
        Objects.requireNonNull(resource, "Must provide a non-null resource.");
        try {
            resource.refreshLocal(depth, monitor);
            return true;
        }
        catch (CoreException e) {
            logger.error("Error occurred when attempting to refresh resource: " + String.valueOf(resource), e);
            return false;
        }
    }

    @Deprecated
    public static boolean createEmptyIFile(IFile file, boolean force, IProgressMonitor monitor) {
        return IResourceUtils.createEmptyIFile(file, force, monitor, true);
    }

    public static boolean createEmptyIFile(IFile file, boolean force, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(file, "Must provide a non-null IFile.");
        return IResourceUtils.createIFile(file, "", StandardCharsets.UTF_8, force, monitor, refresh);
    }

    @Deprecated
    public static boolean createIFile(IFile file, String contents, Charset charset, boolean force, IProgressMonitor monitor) {
        return IResourceUtils.createIFile(file, contents, charset, force, monitor, true);
    }

    public static boolean createIFile(IFile file, String contents, Charset charset, boolean force, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(file, "Must provide a non-null IFile.");
        Objects.requireNonNull(contents, "Must provide a non-null contents.");
        Objects.requireNonNull(charset, "Must provide a non-null charset.");
        try {
            if (file.getParent() != null && file.getParent() instanceof IFolder) {
                IResourceUtils.mkdirs((IFolder)file.getParent(), monitor, refresh);
            }
            if (!IResourceUtils.existsCaseInsensitive((IResource)file, monitor, refresh)) {
                file.create((InputStream)new ByteArrayInputStream(contents.getBytes(charset)), force, monitor);
                return true;
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 275) {
                IStatus status = e.getStatus();
                if (status instanceof IResourceStatus) {
                    logger.debug(MessageFormat.format("A resource with a different case variant already exists. Asked to create: {0} but variant exists: {1}", file, ((IResourceStatus)status).getPath()));
                }
            }
            logger.error("Error occurred when attempting to create file: " + String.valueOf(file), e);
        }
        return false;
    }

    @Deprecated
    public static boolean setIFileContents(IFile file, String contents, Charset charset, boolean force, boolean keepHistory, IProgressMonitor monitor) {
        return IResourceUtils.setIFileContents(file, contents, charset, force, keepHistory, monitor, true);
    }

    public static boolean setIFileContents(IFile file, String contents, Charset charset, boolean force, boolean keepHistory, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(file, "Must provide a non-null IFile.");
        Objects.requireNonNull(contents, "Must provide a non-null contents.");
        Objects.requireNonNull(charset, "Must provide a non-null charset.");
        try {
            if (IResourceUtils.existsCaseInsensitive((IResource)file, monitor, refresh)) {
                file.setContents((InputStream)new ByteArrayInputStream(contents.getBytes(charset)), force, keepHistory, monitor);
                return true;
            }
        }
        catch (CoreException e) {
            logger.error("Error occurred when attempting to create file: " + String.valueOf(file), e);
        }
        return false;
    }

    @Deprecated
    public static boolean createIFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) {
        return IResourceUtils.createIFolder(folder, force, local, monitor, true);
    }

    public static boolean createIFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(folder, "Must provide a non-null Ifolder.");
        try {
            if (refresh) {
                IResourceUtils.refreshLocalIResource((IResource)folder, 0, monitor);
            }
            if (!IResourceUtils.existsCaseInsensitive((IResource)folder, monitor, refresh)) {
                folder.create(force, local, monitor);
                logger.trace("Created folder: " + String.valueOf(folder));
                if (refresh) {
                    IResourceUtils.refreshLocalIResource((IResource)folder, 0, monitor);
                }
                return true;
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 275) {
                IStatus status = e.getStatus();
                if (status instanceof IResourceStatus) {
                    logger.debug(MessageFormat.format("A resource with a different case variant already exists. Asked to create: {0} but variant exists: {1}", folder, ((IResourceStatus)status).getPath()));
                }
            }
            logger.error("Error occurred when attempting to create folder: " + String.valueOf(folder), e);
        }
        return false;
    }

    @Deprecated
    public static boolean existsCaseInsensitive(IResource resource) {
        return IResourceUtils.existsCaseInsensitive(resource, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    public static boolean existsCaseInsensitive(IResource resource, IProgressMonitor monitor, boolean refresh) {
        return IResourceUtils.getCaseInsensitive(resource, monitor, refresh) != null;
    }

    @Deprecated
    public static <T extends IResource> T getCaseInsensitive(T resource) {
        return IResourceUtils.getCaseInsensitive(resource, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    public static <T extends IResource> T getCaseInsensitive(T resource, IProgressMonitor monitor, boolean refresh) {
        Objects.requireNonNull(resource, "Must provide a non-null resource");
        if (resource.exists()) {
            return resource;
        }
        IContainer parent = resource.getParent();
        if (!parent.exists()) {
            parent = IResourceUtils.getCaseInsensitive(parent, monitor, refresh);
        }
        if (parent != null) {
            Collection<IResource> contents = IResourceUtils.ls(parent, monitor, refresh);
            for (IResource r : contents) {
                if (!r.getFullPath().toString().toUpperCase().equals(resource.getFullPath().toString().toUpperCase())) continue;
                return (T)r;
            }
        }
        return null;
    }

    @Deprecated
    public static boolean mkdirsChecked(IFolder folder, IProgressMonitor monitor) throws CoreException {
        return IResourceUtils.mkdirsChecked(folder, monitor, true);
    }

    public static boolean mkdirsChecked(IFolder folder, IProgressMonitor monitor, boolean refresh) throws CoreException {
        if (folder.getParent() instanceof IFolder) {
            IResourceUtils.mkdirsChecked((IFolder)folder.getParent(), monitor, refresh);
        }
        return IResourceUtils.createIFolder(folder, true, true, monitor, refresh);
    }

    @Deprecated
    public static boolean mkdirs(IFolder folder) {
        return IResourceUtils.mkdirs(folder, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    @Deprecated
    public static boolean mkdirs(IFolder folder, IProgressMonitor monitor) {
        return IResourceUtils.mkdirs(folder, monitor, true);
    }

    public static boolean mkdirs(IFolder folder, IProgressMonitor monitor, boolean refresh) {
        try {
            return IResourceUtils.mkdirsChecked(folder, monitor, refresh);
        }
        catch (CoreException e) {
            logger.error("Error occurred when attempting to create folder: " + String.valueOf(folder), e);
            return false;
        }
    }

    @Deprecated
    public static <T extends IResource> Collection<T> ls(IContainer iContainer) {
        return IResourceUtils.ls(iContainer, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    public static <T extends IResource> Collection<T> ls(IContainer iContainer, IProgressMonitor monitor, boolean refresh) {
        try {
            if (refresh) {
                IResourceUtils.refreshLocalIResource((IResource)iContainer, 0, monitor);
            }
            if (iContainer.exists()) {
                IResource[] members = iContainer.members();
                return members == null ? Collections.EMPTY_LIST : Arrays.asList(members);
            }
        }
        catch (CoreException e) {
            logger.warn(e);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static Collection<IResource> ls(IFolder iFolder) {
        return IResourceUtils.ls(iFolder, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    public static Collection<IResource> ls(IFolder iFolder, IProgressMonitor monitor, boolean refresh) {
        return IResourceUtils.ls((IContainer)iFolder, monitor, refresh);
    }

    public static boolean createAnOpenProjectAsNeeded(IProject configProject, IProgressMonitor monitor) {
        return IResourceUtils.createProjectIfNotExist(configProject, monitor) && IResourceUtils.openIProjectIfNotOpen(configProject, monitor);
    }

    public static boolean openIProjectIfNotOpen(IProject project, IProgressMonitor monitor) {
        Objects.requireNonNull(project, "Must provide a non-null project.");
        if (!project.isOpen()) {
            return IResourceUtils.open(project, monitor);
        }
        return true;
    }

    public static boolean createProjectIfNotExist(IProject project, IProgressMonitor monitor) {
        Objects.requireNonNull(project, "Must provide a non-null project.");
        if (!project.exists()) {
            return IResourceUtils.create(project, monitor);
        }
        return true;
    }

    @Deprecated
    public static IFolder mkdirs(IProject project, String folderName, IProgressMonitor monitor) {
        return IResourceUtils.mkdirs(project, folderName, monitor, true);
    }

    public static IFolder mkdirs(IProject project, String folderName, IProgressMonitor monitor, boolean refresh) {
        try {
            return IResourceUtils.mkdirsChecked(project, folderName, monitor, refresh);
        }
        catch (CoreException e) {
            logger.error(MessageFormat.format("Error occurred when attempting to create folder: {0} in project {1}", folderName, project), e);
            return null;
        }
    }

    @Deprecated
    public static IFolder mkdirsChecked(IProject project, String folderName, IProgressMonitor monitor) throws CoreException {
        return IResourceUtils.mkdirsChecked(project, folderName, monitor, true);
    }

    public static IFolder mkdirsChecked(IProject project, String folderName, IProgressMonitor monitor, boolean refresh) throws CoreException {
        Objects.requireNonNull(project, "Must provide a non-null project.");
        Objects.requireNonNull(folderName, "Must provide a non-null name.");
        if (!project.exists()) {
            logger.error(MessageFormat.format("Error: the project {0} does not exist, so folder {1} could not be created.", project, folderName));
            return null;
        }
        IFolder folder = project.getFolder((IPath)new Path(folderName));
        IResourceUtils.mkdirsChecked(folder, monitor, refresh);
        return folder;
    }

    public static boolean deleteIProject(IProject project, boolean deleteContent, boolean force, IProgressMonitor monitor) {
        Objects.requireNonNull(project, "Must provide a non-null project.");
        try {
            project.delete(deleteContent, force, monitor);
            return true;
        }
        catch (NullPointerException | CoreException e) {
            logger.error("Error occurred when attempting to delete project: " + String.valueOf(project), e);
            return true;
        }
    }
}

