/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DialogWithText;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(DialogUtils.class);

    @Deprecated
    public static void openGenericError(String message) {
        DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, message);
    }

    public static boolean openQuestionThreadSafe(final String message) {
        logger.trace(new Object[]{"message: ", message});
        final AtomicBoolean result = new AtomicBoolean(true);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.QUESTION_TITLE, (String)message)) {
                    result.set(Boolean.TRUE);
                } else {
                    result.set(Boolean.FALSE);
                }
            }
        });
        return result.get();
    }

    public static void openErrorThreadSafe(String message) {
        DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, message);
    }

    public static void openErrorThreadSafe(final String title, final String message) {
        DialogUtils.logTitleMessage(title, message);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public static void openErrorThreadSafe(String title, Throwable t) {
        String errorMessage = "";
        errorMessage = t.getMessage() != null ? t.getMessage() : (t.getCause() != null ? t.getCause().getMessage() : t.toString());
        String exceptionRendered = ThrowableRenderer.renderShortForm((Throwable)t).toString();
        if (t instanceof CommunicationException && errorMessage != null && exceptionRendered.contains(errorMessage)) {
            DialogUtils.openErrorThreadSafe(title, Messages.DialogUtils_ErrorOcurredSeeBelowForDetails, errorMessage);
        } else {
            DialogUtils.openErrorThreadSafe(title, errorMessage, exceptionRendered);
        }
    }

    public static void openErrorThreadSafe(final String title, final String message, final String longMessage) {
        logger.trace(MessageFormat.format("title: {0} message: {1} longMessage: {2} ", title, message, longMessage));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DialogWithText.openError(Display.getCurrent().getActiveShell(), title, message, longMessage);
            }
        });
    }

    @Deprecated
    public static void openWarningThreadSafe(final String title, final String message) {
        DialogUtils.logTitleMessage(title, message);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    @Deprecated
    public static void openWarningThreadSafe(final String title, final String message, final String longMessage) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DialogWithText.openWarning(Display.getCurrent().getActiveShell(), title, message, longMessage);
            }
        });
    }

    public static boolean openWarningWithToggleThreadSafe(final String title, final String message, final String toggleMessage, final boolean initialToggleState) {
        DialogUtils.logTitleMessage(title, message);
        final AtomicBoolean toggleState = new AtomicBoolean();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                toggleState.set(MessageDialogWithToggle.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message, (String)toggleMessage, (boolean)initialToggleState, null, null).getToggleState());
            }
        });
        return toggleState.get();
    }

    @Deprecated
    public static void openInfoThreadSafe(final String title, final String message) {
        DialogUtils.logTitleMessage(title, message);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    private static void logTitleMessage(String title, String message) {
        logger.trace(MessageFormat.format("title: {0} message: {1}", title, message), new Exception());
    }

    public static void openInfoThreadSafe(final String title, final String message, final String longMessage) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DialogWithText.openInformation(Display.getCurrent().getActiveShell(), title, message, longMessage);
            }
        });
    }
}

