/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BaseTitleAreaDialog
extends TitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(BaseTitleAreaDialog.class);
    private boolean complete = true;
    private boolean validated = true;

    public BaseTitleAreaDialog() {
        super(Display.getCurrent() != null ? Display.getCurrent().getActiveShell() : Display.getDefault().getActiveShell());
        this.setHelpAvailable(false);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    private void setOkEnableStatus(boolean enable) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enable);
        }
    }

    protected void setComplete(boolean complete) {
        this.setOkEnableStatus(complete && this.validated);
        this.complete = complete;
    }

    protected void setValidated(boolean validated) {
        this.setOkEnableStatus(validated && this.complete);
        this.validated = validated;
    }

    protected Control createButtonBar(Composite parent) {
        Composite baseButtonBar = new Composite(parent, 0);
        try {
            this.createButtonsForButtonBar(baseButtonBar);
            int numberOfButtons = baseButtonBar.getChildren().length;
            baseButtonBar.setLayout((Layout)GUI.button.getLayout(numberOfButtons));
            baseButtonBar.setLayoutData((Object)GUI.button.getLayoutData());
        }
        catch (Exception e) {
            baseButtonBar = (Composite)super.createButtonBar(parent);
            this.getButton(0).setEnabled(this.complete);
        }
        return baseButtonBar;
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        return super.open();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean close() {
        return (this.complete || this.getReturnCode() == 1) && super.close();
    }

    public void setTitle(String newTitle) {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setText(newTitle);
        } else {
            logger.error("Could not set shell text as shell was null.");
        }
        super.setTitle(newTitle);
    }

    public static Composite createScrolledComposite(Composite parent, Composite content) {
        Composite contentComposite = GUI.composite(parent, (Layout)GUI.grid.l.noMargins(1, false), GUI.grid.d.fillAll());
        ScrolledComposite scrolledComposite = GUI.scrolledComposite(contentComposite, 768);
        scrolledComposite.setLayoutData((Object)GUI.grid.d.fillAll());
        content.setParent((Composite)scrolledComposite);
        scrolledComposite.setContent((Control)content);
        scrolledComposite.setMinSize(parent.computeSize(-1, -1));
        return scrolledComposite;
    }

    protected Composite createDialogContent(Composite parent) {
        throw new IllegalAccessError("This method must be overridden if not overriding createDialogArea()");
    }

    protected Control createDialogArea(Composite parent) {
        return BaseTitleAreaDialog.createScrolledComposite(parent, this.createDialogContent((Composite)super.createDialogArea(parent)));
    }

    public static boolean checkIfNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

