/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.product.actions;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class OpenPerspectiveAction
implements IIntroAction {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String CON_PLUGIN_NAME_KEY = "pluginName";
    private static final String PERSPECTIVE_ID_KEY = "pId";
    private static final String PLUGIN_ID_KEY = "pluginId";

    private static String getPerspectiveId(Properties param) {
        return param.getProperty(PERSPECTIVE_ID_KEY, "");
    }

    private static String getPluginId(Properties param) {
        return param.getProperty(PLUGIN_ID_KEY, "");
    }

    private static String getContainingPluginName(Properties param) {
        return param.getProperty(CON_PLUGIN_NAME_KEY, "");
    }

    public final void run(IIntroSite site, final Properties params) {
        final IWorkbenchWindow window = site.getWorkbenchWindow();
        IPerspectiveDescriptor currentPerspective = window.getActivePage().getPerspective();
        final String perspectiveId = OpenPerspectiveAction.getPerspectiveId(params);
        String pluginId = OpenPerspectiveAction.getPluginId(params);
        if ("".equals(perspectiveId)) {
            String message = Messages.OpenPerspectiveAction_0;
            OpenPerspectiveAction.log(message, new IllegalArgumentException(message), pluginId);
            throw new IllegalArgumentException(message);
        }
        if (currentPerspective == null || !currentPerspective.getId().equals(perspectiveId)) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        window.getWorkbench().showPerspective(perspectiveId, window);
                    }
                    catch (WorkbenchException e) {
                        String pName = OpenPerspectiveAction.getContainingPluginName(params);
                        String installMessage = "".equals(pName) ? Messages.OpenPerspectiveAction_1 : MessageFormat.format(Messages.OpenPerspectiveAction_3, pName);
                        DialogUtils.openErrorThreadSafe(MessageFormat.format(Messages.OpenPerspectiveAction_5, perspectiveId, installMessage));
                    }
                }
            });
        }
        IIntroPart introPart = window.getWorkbench().getIntroManager().getIntro();
        window.getWorkbench().getIntroManager().setIntroStandby(introPart, true);
    }

    private static void log(String msg, Exception e, String pluginID) {
        PDTCCcore.getDefault().getLog().log((IStatus)new Status(1, pluginID, 0, msg, (Throwable)e));
    }
}

