/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.model;

import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ITreeContentHolder;
import com.ibm.pdtools.common.component.core.model.IUIPluginHostConnection;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PDHost
extends PDHostJhost
implements IAdaptable,
IPDPlatformObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PDHost.class);
    private static final String PROPERTY_LOGIN = "PROPERTY_LOGIN";
    private static final String IUI_SYSTEM_EXTENDS_ID = "com.ibm.pdtools.common.component.ui.plugin.extend";
    private static List<IUIPluginHostConnection> uiSystemExtendPlugins = new ArrayList<IUIPluginHostConnection>();
    private static List<ITreeContentHolder> treeContentHolders = new ArrayList<ITreeContentHolder>();

    static {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        if (er != null) {
            IConfigurationElement[] iConfigurationElementArray = er.getConfigurationElementsFor(IUI_SYSTEM_EXTENDS_ID);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement uiSystemExtend = iConfigurationElementArray[n2];
                try {
                    Object uiSystemExtendPluginObj = uiSystemExtend.createExecutableExtension("uiPluginHostConnection");
                    if (uiSystemExtendPluginObj instanceof IUIPluginHostConnection) {
                        uiSystemExtendPlugins.add((IUIPluginHostConnection)uiSystemExtendPluginObj);
                        treeContentHolders.add(((IUIPluginHostConnection)uiSystemExtendPluginObj).getTreeContentHolder());
                    } else {
                        logger.trace("An extension is not an " + IUIPluginHostConnection.class.getCanonicalName() + " it is a " + uiSystemExtendPluginObj.getClass().getCanonicalName());
                        uiSystemExtendPlugins.add(null);
                        treeContentHolders.add(null);
                    }
                }
                catch (Exception e) {
                    logger.error(e);
                }
                ++n2;
            }
            logger.trace("uiSystemExtendPlugins.length=" + uiSystemExtendPlugins.size());
        }
    }

    public static PDHost create(String hostID, String hostName, int port) {
        return new PDHost(hostID, hostName, port);
    }

    public static IPDHost create(HostDetails hd) {
        PDHost host = new PDHost(hd.getHostID(), hd.getHostname(), hd.getPortNumber());
        host.setDescription(hd.getDescription());
        host.setCodePage(hd.getHostDefaultEncoding());
        host.setHostType(hd.getHostType());
        host.setBidiFormat(hd.getBidiFormat());
        return host;
    }

    public PDHost(String hostID, String hostName, int port) {
        super(hostID, hostName, port);
        this.setHostID(hostID);
        this.setHostName(hostName);
        this.setPort(port);
        this.setSystem((IPDHost)this);
        if (uiSystemExtendPlugins != null && uiSystemExtendPlugins.size() > 0) {
            int i = 0;
            while (i < uiSystemExtendPlugins.size()) {
                this.getHostExtendsList().add(uiSystemExtendPlugins.get(i).createHostSystem());
                ++i;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PDHost) {
            PDHost otherCommHost = (PDHost)((Object)obj);
            return this.getHostID().equals(otherCommHost.getHostID());
        }
        return false;
    }

    @Deprecated
    public AuthDetails getLogin(boolean forceLoginDialog) throws InterruptedException {
        return this.getLogin(forceLoginDialog, null);
    }

    public AuthDetails getLogin(boolean forceLoginDialog, IHowIsGoing monitor) throws InterruptedException {
        if (forceLoginDialog) {
            return ConnectionUtilities.getLogin(new TheHost(this.getHostName(), this.getHostID()), monitor);
        }
        return ConnectionUtilities.hasLogin(new TheHost(this.getHostName(), this.getHostID()), monitor);
    }

    public PDHost clone() {
        try {
            return (PDHost)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Clone of host failed", e);
        }
    }

    public Result<StringBuffer> executeOnHost(String componentName, String command, IProgressMonitor monitor) throws InterruptedException {
        return this.executeOnHost(componentName, command, PDUtils.convertIprogressToIHowIsGoing(monitor));
    }

    public Result<StringBuffer> executeOnHost(String command, IProgressMonitor monitor) {
        return this.executeOnHost(command, PDUtils.convertIprogressToIHowIsGoing(monitor));
    }

    public String getPDImageName() {
        switch (this.getHostType()) {
            case LOCAL_HOST: {
                return "IMG_OBJ_FOLDER";
            }
        }
        return "host";
    }

    public String getPDLabel() {
        String msg = this.getHostName() + ":" + this.getPort();
        if (!this.getDescription().isEmpty()) {
            msg = msg + " - " + this.getDescription();
        }
        return msg;
    }

    public String getPDPluginId() {
        return "com.ibm.pdtools.common.component.ui";
    }

    public static ITreeContentHolder[] getTreeContentHolders() {
        return treeContentHolders.toArray(new ITreeContentHolder[0]);
    }

    public static IUIPluginHostConnection[] getUiSystemExtendPlugins() {
        return uiSystemExtendPlugins.toArray(new IUIPluginHostConnection[0]);
    }

    public static Object getPropertyHostPort() {
        return PDHostJhost.getPropertyHostPort();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

